/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.common;

import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Rect;

public class ProgressView
extends View {
    protected int foregroundColor = -1;
    protected int borderColor = -1;
    int progress = 0;
    int progressSteps = 0;

    public ProgressView(int progressSteps, int foregroundColor, int borderColor) {
        this.progressSteps = progressSteps;
        this.foregroundColor = foregroundColor;
        this.borderColor = borderColor;
    }

    public void advanceProgress() {
        if (this.progress < this.progressSteps) {
            ++this.progress;
            this.setNeedsDisplay();
        }
    }

    public void setValue(int value) {
        this.progress = value;
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        if (this.backgroundImage != null) {
            g.drawImageRectCenterdInRect(this.backgroundImage, this.frame, this.frame);
        } else {
            g.setColor(this.backgroundColor);
            g.fillRect(this.frame);
        }
        int progressWidth = (int)((double)(this.frame.width - 4) / (double)this.progressSteps * (double)this.progress);
        g.setColor(this.foregroundColor);
        g.graphics().fillRect(this.frame.x + 2, this.frame.y + 2, progressWidth, this.frame.height - 4);
    }
}

