/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.common;

import javax.microedition.lcdui.Image;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.util.Log;

public class SpinnerView
extends View
implements Runnable {
    Image[] images = null;
    boolean run = false;
    int index = 0;
    Image currentImage = null;

    public SpinnerView() {
        this.opaque = false;
    }

    public void useImagesWithPaths(String[] paths) {
        this.images = new Image[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            try {
                this.images[i] = Image.createImage((String)paths[i]);
                continue;
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
        }
    }

    public boolean isSpinning() {
        return this.run;
    }

    public void start() {
        if (!this.run) {
            this.run = true;
            this.index = 0;
            new Thread(this).start();
            this.setNeedsDisplay();
        }
    }

    public void stop() {
        this.currentImage = null;
        this.run = false;
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        if (this.currentImage != null) {
            g.drawImageAtPoint(this.currentImage, this.frame.getOrigin());
        }
    }

    public void setActive(boolean flag) {
        super.setActive(flag);
        if (!flag) {
            this.stop();
        }
    }

    public void run() {
        try {
            if (this.images != null) {
                while (this.run) {
                    this.index = (this.index + 1) % this.images.length;
                    this.currentImage = this.images[this.index];
                    this.setNeedsDisplay();
                    Thread.sleep(190L);
                }
                this.setNeedsDisplay();
            }
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }
}

