/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.interactivity;

import java.util.Vector;
import se.tactel.tvclient.RichMediaMIDlet;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.gui.common.ButtonBar;
import se.tactel.tvclient.gui.common.TextView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Fonts;
import se.tactel.tvclient.gui.constants.Images;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.userdialog.Command;
import se.tactel.tvclient.gui.userdialog.UserDialogView;
import se.tactel.tvclient.gui.windowing.NotPossibleToGoBackWindow;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.gui.windowing.WindowDelegate;
import se.tactel.tvclient.util.Log;

public abstract class SVGWindow
extends Window
implements NotPossibleToGoBackWindow,
WindowDelegate {
    protected UserDialogView userDialogView;
    private ButtonBar buttonBar;
    private Rect userDialogRect;
    private Action selectAction = new Action(){

        public void clicked(View sender) {
            Log.log(128L, "User clicked RSK  on a form (selectas)");
            SVGWindow.this.userDialogView.event(Event.keyEvent(1, -5));
        }
    };
    private Action cancelAction = new Action(){

        public void clicked(View sender) {
            Log.log(128L, "User clicked right softkeybutton on a form (cancelbutton)");
            RichMediaMIDlet.instance().tController.getInteractivityController().processUserdialogCommand(new Command("mtv:closeDialog", null), null, SVGWindow.this.userDialogView.isMtvRootUserDialog());
        }
    };

    public SVGWindow(UserDialogView userDialogView, Rect userDialogRect) {
        this.userDialogView = userDialogView;
        this.userDialogRect = userDialogRect;
        this.processUserDialog();
        this.setButtonBar(this.createButtonBar());
        this.setDelegate(this);
    }

    private void processUserDialog() {
        Rect winFrame = new Rect(this.userDialogRect);
        this.userDialogView.setFrame(winFrame);
        double scaleFactor = this.getUserDialogScalefactor(this.userDialogView, new Rect(this.userDialogRect));
        if (this.userDialogView.getKeyViews().size() > 0) {
            this.userDialogView.setInitialKeyView(0);
        }
        if (!this.userDialogView.getAvoidScaling()) {
            Vector views = this.userDialogView.getSubviews();
            for (int i = 0; i < views.size(); ++i) {
                View v = (View)views.elementAt(i);
                v.scale(scaleFactor, scaleFactor);
            }
        }
        this.userDialogView.setAvoidScaling(true);
        this.userDialogView.setYMaxForAllSvgElements((int)((double)this.userDialogView.getYMaxForAllSvgElements() * scaleFactor));
        if (this.userDialogView.isScrollingUserdialog()) {
            this.userDialogView.initViewportBottomY(winFrame.height);
            this.userDialogView.setScrollVertically(true);
        } else {
            this.userDialogView.setScrollVertically(false);
        }
    }

    private ButtonBar createButtonBar() {
        Action rightKeyAction;
        String leftKeyText = this.userDialogView.getLeftKeyText();
        Action leftKeyAction = this.userDialogView.getLeftKeyAction() == null && this.userDialogView.getKeyViews().size() != 0 ? this.selectAction : this.userDialogView.getLeftKeyAction();
        String rightKeyText = this.userDialogView.getRightKeyText();
        Action action = rightKeyAction = this.userDialogView.getRightKeyAction() == null ? this.cancelAction : this.userDialogView.getRightKeyAction();
        if ("".equals(leftKeyText)) {
            leftKeyAction = null;
        } else if (leftKeyText == null && this.userDialogView.getKeyViews().size() != 0) {
            leftKeyText = ServiceRegistry.instance().getLocalization().getString(3);
        }
        if ("".equals(rightKeyText)) {
            rightKeyAction = null;
        } else if (rightKeyText == null) {
            rightKeyText = ServiceRegistry.instance().getLocalization().getString(2);
        }
        this.buttonBar = ButtonBar.createButtonBar();
        this.buttonBar.setRightSoftKeyTextAndAction(rightKeyText, rightKeyAction);
        this.buttonBar.setLeftSoftKeyTextAndAction(leftKeyText, leftKeyAction);
        return this.buttonBar;
    }

    public boolean eventForWindow(Event event, Window window) {
        if (event.type() == 1 && event.keyCode() == -11) {
            if (this.buttonBar != null && this.buttonBar.right.action() == this.cancelAction) {
                Log.log(128L, "User clicked back key button");
                RichMediaMIDlet.instance().tController.getInteractivityController().processUserdialogCommand(new Command("mtv:closeDialog", null), null, this.userDialogView.isMtvRootUserDialog());
            }
            return true;
        }
        return false;
    }

    public void windowDidBecomeTopWindow(Window window) {
        ServiceRegistry.instance().getController().getTvScreenController().playerView.showTv(false);
    }

    public void windowDidLoseTopWindow(Window window) {
        ServiceRegistry.instance().getController().getTvScreenController().playerView.showTv(true);
    }

    private double getUserDialogScalefactor(UserDialogView udView, Rect userDialogScreen) {
        double scaleFactor = 1.0;
        if (udView != null && !udView.getAvoidScaling()) {
            Rect svgViewBox = udView.getSvgViewBox();
            double horizontalScalefactor = (double)userDialogScreen.width / (double)svgViewBox.width;
            double verticalScalefactor = (double)userDialogScreen.height / (double)svgViewBox.height;
            scaleFactor = horizontalScalefactor < verticalScalefactor ? horizontalScalefactor : verticalScalefactor;
        }
        return scaleFactor;
    }

    protected View createHeader() {
        String headerText = ServiceRegistry.instance().getLocalization().getString(600);
        if (this.userDialogView.getHeaderText() != null) {
            headerText = this.userDialogView.getHeaderText();
        }
        TextView headerTextView = new TextView();
        headerTextView.setFont(Fonts.NORMAL_BOLD);
        headerTextView.setTextColor(-16777216);
        headerTextView.setAlignment(1);
        headerTextView.setFrame(new Rect(Skin.SVG_WINDOW_HEADER_FRAME));
        headerTextView.setBackgroundImage(Images.getDatebar());
        headerTextView.setDrawsBackground(true);
        headerTextView.setText(headerText);
        return headerTextView;
    }
}

