/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.position;

import java.util.Vector;
import se.tactel.tvclient.gui.position.ImmutableRect;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Size;

public class Rect {
    public static final Rect NULLRECT = new Rect(0, 0, 0, 0);
    public int x = 0;
    public int y = 0;
    public int width = 0;
    public int height = 0;

    public Rect() {
    }

    public Rect(Rect orig) {
        this.x = orig.x;
        this.y = orig.y;
        this.width = orig.width;
        this.height = orig.height;
    }

    public Rect(ImmutableRect orig) {
        this.x = orig.x;
        this.y = orig.y;
        this.width = orig.width;
        this.height = orig.height;
    }

    public Rect(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rect setSize(Size size) {
        this.width = size.width;
        this.height = size.height;
        return this;
    }

    public Rect setOrgin(Point point) {
        this.x = point.x;
        this.y = point.y;
        return this;
    }

    public String toString() {
        return this.x + "x" + this.y + "x" + this.width + "x" + this.height;
    }

    public void unionRect(Rect rect) {
        this.x = this.x < rect.x ? this.x : rect.x;
        this.y = this.y < rect.y ? this.y : rect.y;
        int width1 = this.width + this.x;
        int width2 = rect.width + rect.x;
        this.width = width2 > width1 ? width2 - this.x : width1 - this.x;
        int height1 = this.height + this.y;
        int height2 = rect.height + rect.y;
        this.height = height2 > height1 ? height2 - this.y : height1 - this.y;
    }

    public void unionWithValues(int x, int y, int width, int height) {
        this.unionRect(new Rect(x, y, width, height));
    }

    public boolean intersectsRect(Rect rect) {
        if (this.isNullRect() || rect.isNullRect()) {
            return false;
        }
        return this.x + this.width > rect.x && this.x < rect.x + rect.width && this.y + this.height > rect.y && this.y < rect.y + rect.height;
    }

    public boolean isSubrectOfRectVertically(Rect rect) {
        if (this.isNullRect() || rect.isNullRect()) {
            return false;
        }
        int inset = 2;
        return rect.y <= this.y && this.height + this.y - inset <= rect.y + rect.height;
    }

    public Rect rectByIntersectingRect(Rect rect) {
        if (rect.intersectsRect(this)) {
            int x1 = this.x < rect.x ? rect.x : this.x;
            int y1 = this.y < rect.y ? rect.y : this.y;
            int i1 = this.x + this.width > rect.x + rect.width ? rect.x + rect.width : this.x + this.width;
            int k1 = this.y + this.height > rect.y + rect.height ? rect.y + rect.height : this.y + this.height;
            return new Rect(x1, y1, i1 - x1, k1 - y1);
        }
        return NULLRECT;
    }

    public boolean isNullRect() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof Rect && ((Rect)obj).x == this.x && ((Rect)obj).y == this.y && ((Rect)obj).width == this.width && ((Rect)obj).height == this.height;
    }

    public Point getOrigin() {
        return new Point(this.x, this.y);
    }

    public Rect[] rectsBySubtractingRect(Rect rect) {
        Rect d1;
        Rect c1;
        Rect b1;
        Rect a1;
        Rect a = new Rect(this.x, this.y, this.width, rect.y - this.y);
        Rect b = new Rect(this.x, rect.y, rect.x - this.x, rect.height);
        Rect c = new Rect(rect.x + rect.width, rect.y, this.x + this.width - (rect.x + rect.width), rect.height);
        Rect d = new Rect(this.x, rect.y + rect.height, this.width, this.y + this.height - (rect.y + rect.height));
        Vector<Rect> rects = new Vector<Rect>(4);
        if (!a.isNullRect() && !(a1 = this.rectByIntersectingRect(a)).isNullRect()) {
            rects.addElement(a1);
        }
        if (!b.isNullRect() && !(b1 = this.rectByIntersectingRect(b)).isNullRect()) {
            rects.addElement(b1);
        }
        if (!c.isNullRect() && !(c1 = this.rectByIntersectingRect(c)).isNullRect()) {
            rects.addElement(c1);
        }
        if (!d.isNullRect() && !(d1 = this.rectByIntersectingRect(d)).isNullRect()) {
            rects.addElement(d1);
        }
        Object[] array = new Rect[rects.size()];
        rects.copyInto(array);
        return array;
    }
}

