/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.guide;

import java.util.Date;
import java.util.Vector;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Epg;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.Observer;
import se.tactel.tvclient.gui.list.DataSource;
import se.tactel.tvclient.gui.list.ListView;
import se.tactel.tvclient.notificationcenter.Notification;
import se.tactel.tvclient.notificationcenter.NotificationCenter;
import se.tactel.tvclient.util.Utils;

public class EpgDatasource
implements DataSource,
Observer,
Runnable {
    public static final String EPG_UPDATED = "epg";
    Vector programs;
    Epg.EpgDay day;
    String channelId;

    public EpgDatasource() {
        ServiceRegistry.instance().getDataProvider().getEpg().addObserver(this);
        this.programs = new Vector();
        new Thread(this).start();
    }

    public Object listViewObjectValueForLocation(ListView aListView, int cell, int rowIndex) {
        if (this.programs != null && rowIndex < this.programs.size()) {
            Epg.EpgProgram p = (Epg.EpgProgram)this.programs.elementAt(rowIndex);
            switch (cell) {
                case 0: {
                    return Utils.getFormatedTime(p.startTime);
                }
                case 1: {
                    return p.programName;
                }
            }
        }
        return null;
    }

    public int numberOfRowsInListView(ListView list) {
        if (this.programs != null) {
            return this.programs.size();
        }
        return 0;
    }

    public void useEpgForChannelIdAtDate(String channelId, Date date) {
        this.channelId = channelId;
        this.day = ServiceRegistry.instance().getDataProvider().getEpg().getEpgDataFull(channelId, date);
        this.update(null);
    }

    public void useDate(Date date) {
        this.day = ServiceRegistry.instance().getDataProvider().getEpg().getEpgDataFull(this.channelId, date);
        this.update(null);
    }

    public boolean epgListExist(Date date) {
        return !ServiceRegistry.instance().getDataProvider().getEpg().isEpgDataEmpty(this.channelId, date);
    }

    public Epg.EpgDay getDayAsIs(Date date) {
        return ServiceRegistry.instance().getDataProvider().getEpg().getDayAsIs(this.channelId, date);
    }

    public void forceDownloadDaySync(Date date) {
        ServiceRegistry.instance().getDataProvider().getEpg().forceDownloadDaySync(this.channelId, date);
    }

    public Epg.EpgProgram programAtIndex(int index) {
        if (this.programs != null && index > -1 && index < this.programs.size()) {
            return (Epg.EpgProgram)this.programs.elementAt(index);
        }
        return null;
    }

    public int indexOfCurrrentShow() {
        if (this.programs != null) {
            Epg.EpgProgram current = ServiceRegistry.instance().getDataProvider().getEpg().getCurrentProgramForChannelWithId(this.channelId);
            if (this.programs.contains(current)) {
                return this.programs.indexOf(current);
            }
            return 0;
        }
        return -1;
    }

    public void update(ObservableData data) {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Vector temp = this.day != null ? this.day.getPrograms() : new Vector();
        Vector vector = this.programs;
        synchronized (vector) {
            this.programs = null;
            this.programs = temp;
            temp = null;
        }
        NotificationCenter.defaultCenter().postNotification(new Notification(EPG_UPDATED, null));
    }
}

