/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.guide;

import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Epg;
import se.tactel.tvclient.gui.common.ButtonBar;
import se.tactel.tvclient.gui.common.FadeView;
import se.tactel.tvclient.gui.common.ScrollableListView;
import se.tactel.tvclient.gui.common.SimpleMultiTextView;
import se.tactel.tvclient.gui.common.TextView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Fonts;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.gui.windowing.WindowDelegate;
import se.tactel.tvclient.util.Utils;

public class GuideInformationController {
    private Window informationWindow;
    private TextView channeltext;
    private TextView channeltime;
    private SimpleMultiTextView informationtext;
    private ScrollableListView scroll;

    public GuideInformationController() {
        this.createInformationWindow();
    }

    private void createInformationWindow() {
        this.informationWindow = new Window();
        FadeView view = new FadeView();
        view.setFrame(new Rect(Skin.MAIN_FRAME));
        View border = new View();
        border.setFrame(new Rect(Skin.GUIDE_INFORMATION_BORDER_FRAME));
        border.setDrawsBackground(true);
        border.setBackgroundColor(-16777216);
        view.addSubview(border);
        View background = new View();
        background.setFrame(new Rect(Skin.GUIDE_INFORMATION_FRAME));
        background.setDrawsBackground(true);
        background.setBackgroundColor(-1);
        border.addSubview(background);
        this.channeltime = new TextView();
        this.channeltime.setFrame(new Rect(Skin.GUIDE_INFORMATION_PROGRAM_TIME_FRAME));
        this.channeltime.setText("00:00");
        this.channeltime.setFont(Fonts.NORMAL_BOLD);
        this.channeltime.setTextColor(-16777216);
        background.addSubview(this.channeltime);
        this.channeltext = new TextView();
        this.channeltext.setFrame(new Rect(Skin.GUIDE_INFORMATION_PROGRAM_NAME_FRAME));
        this.channeltext.setText("No channel");
        this.channeltext.setFont(Fonts.NORMAL_BOLD);
        this.channeltext.setTextColor(-16777216);
        background.addSubview(this.channeltext);
        this.scroll = new ScrollableListView(false);
        this.scroll.setFrame(new Rect(Skin.GUIDE_INFORMATION_PROGRAM_SCROLL_FRAME));
        this.scroll.setOpaque(false);
        background.addSubview(this.scroll);
        this.informationtext = new SimpleMultiTextView();
        this.informationtext.setText("No information");
        this.informationtext.setFrame(new Rect(Skin.GUIDE_INFORMATION_PROGRAM_INFORMATION_FRAME));
        this.informationtext.setFont(Fonts.NORMAL);
        this.informationtext.setTextColor(-16777216);
        this.informationtext.setVerticallyAlignment(false);
        this.informationtext.setOpaque(false);
        this.scroll.addSubview(this.informationtext);
        this.informationWindow.setInitialFirstResponder(this.scroll);
        this.informationWindow.setContentView(view);
        ButtonBar closeBar = ButtonBar.createButtonBar();
        closeBar.setLeftSoftKeyTextAndAction(4, new Action(){

            public synchronized void clicked(View sender) {
                GuideInformationController.this.informationWindow.goBack();
                GuideInformationController.this.informationWindow.close();
            }
        });
        this.informationWindow.setDelegate(new WindowDelegate(){

            public boolean eventForWindow(Event event, Window window) {
                if (event.type() == 1 && (event.keyCode() == -11 || event.keyCode() == -5)) {
                    GuideInformationController.this.informationWindow.goBack();
                    GuideInformationController.this.informationWindow.close();
                    return true;
                }
                return false;
            }

            public void windowDidBecomeTopWindow(Window window) {
            }

            public void windowDidLoseTopWindow(Window window) {
            }
        });
        this.informationWindow.setButtonBar(closeBar);
    }

    public synchronized void showInformationForProgram(Epg.EpgProgram program) {
        if (program != null) {
            this.channeltime.setText(Utils.getFormatedTime(program.startTime));
            this.channeltext.setText(program.programName);
            if (program.programDescription != null) {
                this.informationtext.setText(program.programDescription);
                this.informationtext.sizeToFit();
                this.scroll.updateScrollSize();
            } else {
                this.informationtext.setText(ServiceRegistry.instance().getLocalization().getString(3026));
                this.informationtext.sizeToFit();
                this.scroll.updateScrollSize();
            }
        } else {
            this.channeltext.setText("");
            this.informationtext.setText(ServiceRegistry.instance().getLocalization().getString(3026));
            this.informationtext.sizeToFit();
            this.scroll.updateScrollSize();
        }
        this.informationWindow.makeKeyAndOrderFront();
    }
}

