/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.tab.channels;

import java.util.Enumeration;
import java.util.Vector;
import se.tactel.tvclient.Controller;
import se.tactel.tvclient.RichMediaMIDlet;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.ChannelList;
import se.tactel.tvclient.data.Content;
import se.tactel.tvclient.data.Epg;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.Observer;
import se.tactel.tvclient.gui.channellist.ChannelListItemView;
import se.tactel.tvclient.gui.channellist.ChannelListView;
import se.tactel.tvclient.gui.common.ButtonBar;
import se.tactel.tvclient.gui.common.ImageView;
import se.tactel.tvclient.gui.common.SpinnerView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Images;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.screen.option.OptionsMenuItem;
import se.tactel.tvclient.gui.screen.tab.TabWindow;
import se.tactel.tvclient.gui.screen.tooltip.TooltipWindow;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Utils;

public class ChannelsWindow
extends TabWindow
implements Observer,
ChannelListView.ChannelFocusObserver {
    private final Controller controller;
    private ChannelListView allChannelsListView;
    private ButtonBar defaultButtonBar;
    private SpinnerView spinner;
    private OptionsMenuItem goToWapOptionsMenuItem;
    private OptionsMenuItem watchOptionsMenuItem;
    private OptionsMenuItem guideOptionsMenuItem;
    private OptionsMenuItem moveOptionsMenuItem;
    private OptionsMenuItem hideOptionsMenuItem;

    public void windowDidBecomeTopWindow(Window window) {
        super.windowDidBecomeTopWindow(window);
        if (this.contentView() != null) {
            this.contentView().didBecomeTop();
        }
        try {
            if (this.spinner != null) {
                this.spinner.start();
            }
            if (this.allChannelsListView.getCurrentlySelectedChannel() != null) {
                this.scrollToChannel(this.allChannelsListView.getCurrentlySelectedChannel());
            }
        }
        catch (Throwable e) {
            Log.exception(this, e);
        }
    }

    public void willBecomeTopWindow() {
        try {
            Content c = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().getCurrentContent();
            if (c instanceof Channel) {
                this.allChannelsListView.scrollToChannelWithId(c.getId());
            }
        }
        catch (Throwable e) {
            Log.exception(this, e);
        }
    }

    public void windowDidLoseTopWindow(Window window) {
        super.windowDidLoseTopWindow(window);
        if (this.contentView() != null) {
            this.contentView().didLoseTop();
        }
    }

    protected Window getTabToTheLeft() {
        return this.controller.getTvScreenWindow();
    }

    protected Window getTabToTheRight() {
        return this.controller.getStoreController().getStartWindow();
    }

    public ChannelsWindow(Controller controller) {
        this.controller = controller;
        this.setOptionMenuItems(this.createOptionsMenuItems());
        this.defaultButtonBar = ButtonBar.createDefaultButtonBar(this);
        this.setButtonBar(this.defaultButtonBar);
        this.setContentView(this.createUI());
    }

    public boolean eventForWindow(Event event, Window window) {
        if (this.allChannelsListView.isInMoveMode() && event.type() == 1 && (event.keyCode() == -3 || event.keyCode() == -4 || event.keyCode() == -11)) {
            return true;
        }
        int numberKeyPressed = Utils.getNumberKey(event.keyCode());
        if (numberKeyPressed > 0) {
            Channel c = ServiceRegistry.instance().getDataProvider().getChannelConfiguration().getFavoriteChannelData(numberKeyPressed);
            String channelID = null;
            if (c != null) {
                channelID = c.getId();
            }
            Channel shortcutContent = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(channelID);
            if (!channelID.equals("-1")) {
                this.activateChannel(shortcutContent);
            }
            return true;
        }
        return super.eventForWindow(event, window);
    }

    private OptionsMenuItem[] createOptionsMenuItems() {
        OptionsMenuItem[] menuItems = new OptionsMenuItem[8];
        menuItems[0] = OptionsMenuItem.createButtonMenuItem();
        menuItems[0].setText(102);
        menuItems[0].setAction(new Action(){

            public void clicked(View sender) {
                ChannelsWindow.this.controller.closeOptionMenuWindow();
                ChannelsWindow.this.activateChannel(ChannelsWindow.this.allChannelsListView.getCurrentlySelectedChannel());
            }
        });
        this.watchOptionsMenuItem = menuItems[0];
        menuItems[1] = OptionsMenuItem.createButtonMenuItem();
        menuItems[1].setText(104);
        menuItems[1].setAction(new Action(){

            public void clicked(View sender) {
                ChannelsWindow.this.controller.closeOptionMenuWindow();
                Channel channel = ChannelsWindow.this.allChannelsListView.getCurrentlySelectedChannel();
                if (channel != null) {
                    ChannelsWindow.this.controller.getGuideScreenController().showEpgForChannel(channel);
                }
            }
        });
        this.guideOptionsMenuItem = menuItems[1];
        menuItems[2] = OptionsMenuItem.createButtonMenuItem();
        menuItems[2].setText(110);
        menuItems[2].setAction(new Action(){

            public void clicked(View sender) {
                ChannelsWindow.this.controller.closeOptionMenuWindow();
                ChannelsWindow.this.startChannelMoveSession();
            }
        });
        this.moveOptionsMenuItem = menuItems[2];
        menuItems[3] = OptionsMenuItem.createButtonMenuItem();
        menuItems[3].setText(111);
        menuItems[3].setAction(new Action(){

            public void clicked(View sender) {
                ChannelsWindow.this.controller.closeOptionMenuWindow();
                Channel nextChannel = ChannelsWindow.this.allChannelsListView.getNextChannel();
                if (nextChannel == ChannelsWindow.this.allChannelsListView.getCurrentlySelectedChannel()) {
                    nextChannel = null;
                }
                ChannelsWindow.this.allChannelsListView.getCurrentlySelectedItem().deactivateTickers();
                ChannelsWindow.this.allChannelsListView.getCurrentlySelectedChannel().setUserVisible(false);
                ChannelsWindow.this.refreshChannelsInList();
                if (nextChannel != null) {
                    ChannelsWindow.this.allChannelsListView.scrollToChannel(nextChannel);
                }
                ChannelsWindow.this.contentView().setNeedsDisplay();
            }
        });
        this.hideOptionsMenuItem = menuItems[3];
        menuItems[4] = OptionsMenuItem.createButtonMenuItem();
        menuItems[4].setText(112);
        menuItems[4].setAction(new Action(){

            public void clicked(View sender) {
                ChannelsWindow.this.controller.closeOptionMenuWindow();
                ServiceRegistry.instance().getDataProvider().getChannelConfiguration().unHideAllChannels();
                Channel c = ChannelsWindow.this.allChannelsListView.getCurrentlySelectedChannel();
                ChannelsWindow.this.refreshChannelsInList();
                if (c != null) {
                    ChannelsWindow.this.allChannelsListView.scrollToChannel(c);
                } else if (ChannelsWindow.this.allChannelsListView.subviews().size() > 0) {
                    ChannelsWindow.this.allChannelsListView.scrollToItem((View)ChannelsWindow.this.allChannelsListView.subviews().elementAt(0));
                }
            }
        });
        menuItems[5] = OptionsMenuItem.createButtonMenuItem();
        menuItems[5].setText(103);
        menuItems[5].setAction(new Action(){

            public void clicked(View sender) {
                ChannelsWindow.this.controller.closeOptionMenuWindow();
                Channel channel = ChannelsWindow.this.allChannelsListView.getCurrentlySelectedChannel();
                if (channel != null) {
                    try {
                        RichMediaMIDlet.instance().platformRequest(channel.getInformationUrl());
                        ServiceRegistry.instance().getWindowServer().redraw();
                    }
                    catch (Exception e) {
                        Log.exception(this, e);
                    }
                }
            }
        });
        this.goToWapOptionsMenuItem = menuItems[5];
        menuItems[6] = OptionsMenuItem.HELP_CHANNELS_BUTTON;
        menuItems[7] = OptionsMenuItem.EXIT_BUTTON;
        return menuItems;
    }

    private View createUI() {
        View topLevelView = new View(){

            public boolean event(Event event) {
                if (ChannelsWindow.this.allChannelsListView.isInMoveMode() && event.type() == 1 && event.keyCode() == -5) {
                    ChannelsWindow.this.stopChannelMoveSession(true);
                    return true;
                }
                if (ChannelsWindow.this.allChannelsListView.isInMoveMode() && event.type() == 1 && event.keyCode() == -11) {
                    ChannelsWindow.this.stopChannelMoveSession(false);
                    return true;
                }
                return super.event(event);
            }
        };
        topLevelView.setFrame(new Rect(Skin.MAIN_FRAME_EXCLUDING_INTERACTIVITY_VIEW));
        topLevelView.setOpaque(true);
        topLevelView.setBackgroundColor(-1972760);
        topLevelView.setDrawsBackground(true);
        ImageView sntImg = new ImageView(new Rect(Skin.SNT_TAB_IMAGE_FRAME), Images.getSNTImage(3));
        topLevelView.addSubview(sntImg);
        this.allChannelsListView = new ChannelListView();
        String[] paths = new String[16];
        this.spinner = new SpinnerView();
        paths[0] = "/hourglass/load_1.png";
        paths[1] = "/hourglass/load_2.png";
        paths[2] = "/hourglass/load_3.png";
        paths[3] = "/hourglass/load_4.png";
        paths[4] = "/hourglass/load_5.png";
        paths[5] = "/hourglass/load_6.png";
        paths[6] = "/hourglass/load_7.png";
        paths[7] = "/hourglass/load_8.png";
        paths[8] = "/hourglass/load_9.png";
        paths[9] = "/hourglass/load_10.png";
        paths[10] = "/hourglass/load_11.png";
        paths[11] = "/hourglass/load_12.png";
        paths[12] = "/hourglass/load_13.png";
        paths[13] = "/hourglass/load_14.png";
        paths[14] = "/hourglass/load_15.png";
        paths[15] = "/hourglass/load_16.png";
        this.spinner.setFrame(new Rect((Skin.USABLE_TAB_AREA_RECT.width - 43) / 2, Skin.USABLE_TAB_AREA_RECT.height / 2, 43, 40));
        this.spinner.setOpaque(false);
        this.spinner.useImagesWithPaths(paths);
        topLevelView.addSubview(this.spinner);
        new Thread(new LoadList(this, topLevelView)).start();
        return topLevelView;
    }

    private void setupObservers() {
        ServiceRegistry.instance().getDataProvider().getEpg().addObserver(this);
        ServiceRegistry.instance().getDataProvider().getChannelList().addObserver(this);
    }

    public void update(ObservableData data) {
        if (data instanceof Epg) {
            Log.log(0x10000000000L, "EPG triggered update in channels list");
            this.allChannelsListView.updateChannelsInList();
        } else if (data instanceof ChannelList) {
            if (this.checkIfChannelOrderorNumberHasChanged()) {
                Log.log(0x10000000000L, "Channel list triggered update in channels list => REFRESH");
                this.refreshChannelsInList();
            } else {
                Log.log(0x10000000000L, "Channel list triggered update in channels list => UPDATE");
                this.allChannelsListView.updateChannelsInList();
            }
            this.contentView().setNeedsDisplay();
        }
        this.setFocusedChannel(this.allChannelsListView.getCurrentlySelectedChannel());
    }

    private boolean checkIfChannelOrderorNumberHasChanged() {
        Vector allChannelsVector = ServiceRegistry.instance().getDataProvider().getChannelList().getSortedVisibleChannels();
        if (allChannelsVector.size() != this.allChannelsListView.subviews().size()) {
            return true;
        }
        Enumeration channelsEnum = allChannelsVector.elements();
        Enumeration listviewEnum = this.allChannelsListView.subviews().elements();
        while (channelsEnum.hasMoreElements()) {
            Channel c = (Channel)channelsEnum.nextElement();
            Channel listviewChannel = ((ChannelListItemView)listviewEnum.nextElement()).channel;
            if (c.getId().equals(listviewChannel.getId())) continue;
            return true;
        }
        return false;
    }

    public void setFocusedChannel(Channel focusedChannel) {
        this.watchOptionsMenuItem.setEnabled(focusedChannel != null && this.allChannelsListView.getCurrentlySelectedChannel() != null && !this.allChannelsListView.getCurrentlySelectedChannel().isNotAvailable());
        this.guideOptionsMenuItem.setEnabled(focusedChannel != null);
        this.moveOptionsMenuItem.setEnabled(this.allChannelsListView.subviews() != null && this.allChannelsListView.subviews().size() > 1);
        this.hideOptionsMenuItem.setEnabled(focusedChannel != null);
        this.goToWapOptionsMenuItem.setEnabled(focusedChannel != null && focusedChannel.getInformationUrl() != null && !"".equals(focusedChannel.getInformationUrl()));
    }

    private void startChannelMoveSession() {
        this.blockAd(true);
        this.allChannelsListView.setInMoveMode(true);
        this.setMoveChannelsSoftkey();
        TooltipWindow tooltipWindow = Controller.getTooltipWindow(350);
        Rect r = new Rect(tooltipWindow.frame());
        Rect currentItemRect = this.allChannelsListView.getCurrentlySelectedItem().frame();
        r.setOrgin(new Point(0, Math.max(0, currentItemRect.y - r.height + 20)));
        tooltipWindow.setFrame(r);
        tooltipWindow.makeKeyAndOrderFront();
    }

    private void stopChannelMoveSession(boolean saveNewPositionOfMovedChannel) {
        this.blockAd(false);
        this.allChannelsListView.setInMoveMode(false);
        if (saveNewPositionOfMovedChannel) {
            int orderOfMovedChannel = 1 + this.allChannelsListView.subviews().indexOf(this.allChannelsListView.getCurrentlySelectedItem());
            Log.log(0x10000000000L, this.allChannelsListView.getCurrentlySelectedChannel().getName() + " (" + this.allChannelsListView.getCurrentlySelectedChannel().getId() + ") moved to " + orderOfMovedChannel);
            ServiceRegistry.instance().getDataProvider().getChannelConfiguration().insertContentAt(this.allChannelsListView.getCurrentlySelectedChannel(), orderOfMovedChannel);
            ServiceRegistry.instance().getDataProvider().getChannelList().notifyObservers();
        } else {
            Channel channelToScrollTo = this.allChannelsListView.getCurrentlySelectedChannel();
            this.refreshChannelsInList();
            this.allChannelsListView.scrollToChannel(channelToScrollTo);
        }
        this.setDefaultSoftkeys();
    }

    private void setDefaultSoftkeys() {
        this.defaultButtonBar.setLeftSoftKeyTextAndAction(1, new Action(){

            public void clicked(View sender) {
                ChannelsWindow.this.showOptionsMenuWindow();
            }
        });
        this.defaultButtonBar.setRightSoftKeyTextAndAction("", null);
    }

    private void setMoveChannelsSoftkey() {
        this.defaultButtonBar.setLeftSoftKeyTextAndAction(4, new Action(){

            public void clicked(View sender) {
                ChannelsWindow.this.stopChannelMoveSession(true);
            }
        });
        this.defaultButtonBar.setRightSoftKeyTextAndAction(2, new Action(){

            public void clicked(View sender) {
                ChannelsWindow.this.stopChannelMoveSession(false);
            }
        });
    }

    void refreshChannelsInList() {
        this.allChannelsListView.flushItems();
        Vector allChannelsVector = ServiceRegistry.instance().getDataProvider().getChannelList().getSortedVisibleChannels();
        Enumeration allChannelsEnumeration = allChannelsVector.elements();
        while (allChannelsEnumeration.hasMoreElements()) {
            Channel channel;
            Content content = (Content)allChannelsEnumeration.nextElement();
            if (!(content instanceof Channel) || !(channel = (Channel)content).isVisible() || !channel.isUserVisible()) continue;
            Log.log(0x10000000000L, "Adding: " + channel);
            ChannelListItemView channelListItemView = new ChannelListItemView(this.allChannelsListView, channel);
            channelListItemView.setAction(new ChannelSwitchAction(this, channel));
        }
        this.setFocusedChannel(this.allChannelsListView.getCurrentlySelectedChannel());
    }

    private void activateChannel(Channel channel) {
        if (channel != null && !channel.isNotAvailable() && channel.isSubscribed() && (channel.getAdultUrl() == null || "".equals(channel.getAdultUrl()))) {
            this.controller.getTvScreenWindow().makeKeyAndOrderFront();
        }
        int resultCode = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().requestContentSwitch(channel);
        switch (resultCode) {
            case 5: 
            case 6: 
            case 7: {
                this.close();
                break;
            }
        }
    }

    public void scrollToChannel(Channel c) {
        this.allChannelsListView.scrollToChannel(c);
    }

    public void deactivateTickersForCurrentlySelectedItem() {
        if (this.allChannelsListView != null && this.allChannelsListView.getCurrentlySelectedItem() != null) {
            this.allChannelsListView.getCurrentlySelectedItem().deactivateTickers();
        }
    }

    public void activateTickersForCurrentlySelectedItem() {
        if (this.allChannelsListView != null && this.allChannelsListView.getCurrentlySelectedItem() != null) {
            this.allChannelsListView.getCurrentlySelectedItem().activateTickers();
        }
    }

    static class ChannelSwitchAction
    extends Action {
        ChannelsWindow channelsWindow;
        Channel channel;

        public ChannelSwitchAction(ChannelsWindow channelsWindow, Channel channel) {
            this.channel = channel;
            this.channelsWindow = channelsWindow;
        }

        public void clicked(View sender) {
            this.channelsWindow.activateChannel(this.channel);
        }
    }

    static class LoadList
    implements Runnable {
        ChannelsWindow window;
        View topLevelView;

        public LoadList(ChannelsWindow window, View topLevelView) {
            this.window = window;
            this.topLevelView = topLevelView;
        }

        public void run() {
            this.window.spinner.start();
            this.window.refreshChannelsInList();
            this.window.allChannelsListView.setChannelFocusObserver(this.window);
            this.window.allChannelsListView.setHighlight(true);
            this.window.allChannelsListView.setFrame(new Rect(Skin.USABLE_TAB_AREA_RECT));
            Content c = ServiceRegistry.instance().getDataProvider().getConfig().getCurrentContent().getCurrentContent();
            if (c != null && c instanceof Channel) {
                this.window.allChannelsListView.scrollToChannelWithId(c.getId());
            }
            this.window.setupObservers();
            this.topLevelView.removeSubview(this.window.spinner);
            this.window.spinner.stop();
            this.window.spinner = null;
            this.topLevelView.addSubview(this.window.allChannelsListView);
            this.window.allChannelsListView.setNeedsDisplay();
        }
    }
}

