/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.tab.news;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import se.tactel.tvclient.gui.userdialog.UserDialogView;
import se.tactel.tvclient.network.protocols.Protocol;
import se.tactel.tvclient.network.protocols.UserDialogProtocol;
import se.tactel.tvclient.util.Log;

public class SVGProtocol
extends Protocol {
    UserDialogView userDialogView;

    public void parse(XmlPullParser parser) {
        try {
            boolean finished = false;
            int eventType = parser.getEventType();
            do {
                switch (eventType) {
                    case 2: {
                        String tagName = parser.getName();
                        if ("userDialog".equals(tagName)) {
                            UserDialogProtocol p = new UserDialogProtocol();
                            ((Protocol)p).parse(parser);
                            this.userDialogView = p.getUserDialog();
                            finished = true;
                            break;
                        }
                        if ("app_server_mtv".equals(tagName) || "interactivity".equals(tagName) || "event".equals(tagName)) break;
                        Log.log(0x100000800L, "Unknown tag: " + tagName);
                        this.skipTag(parser, tagName);
                        break;
                    }
                    case 3: {
                        String name = parser.getName();
                        if (!name.equals("app_server_mtv")) break;
                        finished = true;
                        break;
                    }
                }
                if (finished) continue;
                eventType = parser.next();
            } while (eventType != 1 && !finished);
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }

    private void skipTag(XmlPullParser parser, String tagName) {
        String tag = "";
        boolean done = false;
        int depth = 0;
        do {
            try {
                parser.next();
                int eventType = parser.getEventType();
                tag = parser.getName();
                if (tag == null) continue;
                if (eventType == 1) {
                    return;
                }
                if (eventType == 2) {
                    ++depth;
                } else if (eventType == 3) {
                    --depth;
                }
                if (!tag.equals(tagName) || depth != -1) continue;
                done = true;
            }
            catch (XmlPullParserException e) {
                Log.exception(this, e);
            }
            catch (Exception e) {
                Log.exception(this, e);
            }
        } while (!done);
    }
}

