/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.screen.tab.store.availablein;

import se.tactel.tvclient.Controller;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.Content;
import se.tactel.tvclient.data.Folder;
import se.tactel.tvclient.data.ObservableData;
import se.tactel.tvclient.data.Observer;
import se.tactel.tvclient.gui.channellist.ChannelIconView;
import se.tactel.tvclient.gui.common.ButtonBar;
import se.tactel.tvclient.gui.common.ImageView;
import se.tactel.tvclient.gui.common.SimpleMultiTextView;
import se.tactel.tvclient.gui.common.TextView;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Fonts;
import se.tactel.tvclient.gui.constants.Images;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.list.ListDelegate;
import se.tactel.tvclient.gui.list.ListView;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.screen.option.OptionsMenuItem;
import se.tactel.tvclient.gui.screen.tab.store.StoreWindow;
import se.tactel.tvclient.gui.screen.tab.store.availablein.PurchaseOptionsDatasource;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Utils;

public class AvailableInStoreWindow
extends StoreWindow
implements ListDelegate,
Observer {
    private ChannelIconView channelIconView;
    private Channel channel;
    private ListView list;
    private TextView title;
    PurchaseOptionsDatasource datasource;
    static /* synthetic */ Class class$se$tactel$tvclient$gui$screen$tab$store$start$PackItem;

    public AvailableInStoreWindow(Controller controller) {
        super(controller);
        this.setButtonBar(ButtonBar.createDefaultButtonBar(this));
        this.setInitialFirstResponder(this.list);
        OptionsMenuItem[] menuItems = new OptionsMenuItem[]{this.OPEN, this.GOTO_START_WINDOW, OptionsMenuItem.HELP_SHOP_BUTTON, OptionsMenuItem.EXIT_BUTTON};
        this.setOptionMenuItems(menuItems);
        this.setContentView(this.createUI());
        ServiceRegistry.instance().getDataProvider().getChannelList().addObserver(this);
    }

    protected void didLoseTopWindow() {
        this.list.didLoseTop();
        super.didLoseTopWindow();
    }

    private View createUI() {
        View content = new View();
        content.setFrame(new Rect(Skin.MAIN_FRAME_EXCLUDING_INTERACTIVITY_VIEW));
        content.setBackgroundColor(-1972760);
        content.setDrawsBackground(true);
        View shade = new View();
        shade.setFrame(new Rect(Skin.SHADE_FRAME));
        shade.setDrawsBackground(true);
        shade.setBackgroundImage(Images.getShade());
        content.addSubview(shade);
        ImageView tabImage = new ImageView();
        tabImage.setFrame(new Rect(Skin.SNT_TAB_IMAGE_FRAME));
        tabImage.setImage(Images.getSNTImage(4));
        content.addSubview(tabImage);
        this.channelIconView = new ChannelIconView();
        this.channelIconView.setFrame(this.channelIconView.frame().setOrgin(Skin.STORE_AVAILABLE_IN_ICON_POSITION));
        content.addSubview(this.channelIconView);
        this.title = new TextView();
        this.title.setFrame(new Rect(Skin.STORE_AVAILABLE_IN_TITLE));
        this.title.setFont(Fonts.LARGER_BOLD);
        this.title.setTextColor(-16777216);
        this.title.setText("");
        content.addSubview(this.title);
        SimpleMultiTextView text = new SimpleMultiTextView();
        text.setFrame(new Rect(Skin.STORE_AVAILABLE_IN_TEXT));
        text.setFont(Fonts.NORMAL_BOLD);
        text.setTextColor(-16777216);
        text.setAlignment(1);
        text.setText(302);
        content.addSubview(text);
        this.list = new ListView();
        this.datasource = new PurchaseOptionsDatasource();
        this.list = new ListView();
        this.list.setFrame(new Rect(Skin.STORE_AVAILABLE_IN_LIST));
        this.list.setListItemClass(class$se$tactel$tvclient$gui$screen$tab$store$start$PackItem == null ? (class$se$tactel$tvclient$gui$screen$tab$store$start$PackItem = AvailableInStoreWindow.class$("se.tactel.tvclient.gui.screen.tab.store.start.PackItem")) : class$se$tactel$tvclient$gui$screen$tab$store$start$PackItem);
        this.list.setItemOffset(8);
        this.list.setItemSpacing(7);
        this.list.setBackgroundColor(-1);
        this.list.setDrawsBackground(true);
        this.list.setDataSource(this.datasource);
        this.list.setDelegate(this);
        this.list.setHighlight(false);
        content.addSubview(this.list);
        this.setInitialFirstResponder(this.list);
        return content;
    }

    public void showWhichPacksThisChannelIsIn(Channel c) {
        this.channel = c;
        this.channelIconView.updateChannelToDisplay(c);
        String channelName = c.getName() != null ? c.getName() : "";
        this.title.setText(channelName);
        this.datasource.useContent(c);
        this.list.reloadData();
    }

    public void listViewDidClickRowIndex(ListView l, int rowIndex) {
        Content content = this.datasource.contentAtIndex(rowIndex);
        if (content != null && content.isPaymentAllowed()) {
            if (content instanceof Folder) {
                Folder f = (Folder)content;
                this.controller.getStoreController().getPackWindowWithChannelContext(f, this.channel).makeKeyAndOrderFront();
                this.close();
            } else if (content instanceof Channel) {
                String url = ServiceRegistry.instance().getDataProvider().getConfig().getContentOfferingUrl(content);
                Log.log(0x4000000000L, "Initiating purchase for channel: " + url);
                Controller.popUpWaitWindowAndLoadUrl(url);
                Utils.sleep(300L);
            }
        }
    }

    public String getChannelIdScreenIsShowedFor() {
        return this.channel.getId();
    }

    public void update(ObservableData data) {
        String channelId = this.channel.getId();
        Channel c = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel(channelId);
        if (c != null) {
            this.showWhichPacksThisChannelIsIn(c);
            this.list.setNeedsDisplay();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

