/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.userdialog;

import java.util.Vector;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;

public class PolylineView
extends View {
    protected Vector polylinePoints = null;
    int strokeColor = -1;

    public void drawInRect(TactelGraphics g, Rect rect) {
        Rect clip = g.getClipRect();
        g.setClipRect(rect);
        if (this.strokeColor != -1 && this.polylinePoints != null && this.polylinePoints.size() > 0) {
            g.setColor(this.strokeColor);
            Point start = null;
            Point end = null;
            for (int a = 0; a < this.polylinePoints.size() - 1; ++a) {
                start = (Point)this.polylinePoints.elementAt(a);
                end = (Point)this.polylinePoints.elementAt(a + 1);
                g.graphics().drawLine(this.frame.x + start.x, this.frame.y + start.y, this.frame.x + end.x, this.frame.y + end.y);
            }
        }
        g.setClipRect(clip);
    }

    public void setPolylineFrame(Vector vPoints, Rect ref) {
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        Point p = null;
        if (vPoints != null && vPoints.size() > 1) {
            int a;
            if (vPoints.size() % 2 != 0) {
                vPoints.removeElementAt(vPoints.size() - 1);
            }
            for (a = 0; a < vPoints.size(); ++a) {
                p = (Point)vPoints.elementAt(a);
                if (a == 0) {
                    minX = maxX = p.x;
                    minY = maxY = p.y;
                    continue;
                }
                if (p.x < minX) {
                    minX = p.x;
                }
                if (p.x > maxX) {
                    maxX = p.x;
                }
                if (p.y < minY) {
                    minY = p.y;
                }
                if (p.y <= maxY) continue;
                maxY = p.y;
            }
            this.polylinePoints = vPoints;
            for (a = 0; a < this.polylinePoints.size(); ++a) {
                ((Point)this.polylinePoints.elementAt((int)a)).x -= minX;
                ((Point)this.polylinePoints.elementAt((int)a)).y -= minY;
            }
        }
        this.setFrame(new Rect(minX - ref.x, minY - ref.y, maxX - (minX - 1), maxY - (minY - 1)));
    }

    public void setStrokeColor(int i) {
        this.strokeColor = i;
    }

    public void scale(double sfX, double sfY) {
        super.scale(sfX, sfY);
        if (this.polylinePoints != null) {
            for (int a = 0; a < this.polylinePoints.size(); ++a) {
                int x = ((Point)this.polylinePoints.elementAt((int)a)).x;
                x = (int)((double)x * sfX);
                int y = ((Point)this.polylinePoints.elementAt((int)a)).y;
                y = (int)((double)y * sfY);
                ((Point)this.polylinePoints.elementAt((int)a)).x = x;
                ((Point)this.polylinePoints.elementAt((int)a)).y = y;
            }
        }
    }
}

