/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.userdialog;

import java.util.Hashtable;
import java.util.Vector;
import se.tactel.tvclient.gui.InputBoxView;
import se.tactel.tvclient.gui.common.core.Action;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.HighlightContainerView;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.list.ScrollbarView;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.position.Size;

public class UserDialogView
extends HighlightContainerView {
    private Hashtable textAreaMap = new Hashtable();
    private Rect svgViewBox = new Rect(0, 0, 0, 0);
    private Vector rootCommands = null;
    private boolean avoidScaling = false;
    private boolean mtvRootUserDialog = false;
    private String leftKeyText = null;
    private String rightKeyText = null;
    private Action leftKeyAction = null;
    private Action rightKeyAction = null;
    private boolean scalingDone = false;
    private String headerText;
    private String url;
    private boolean scrollingUserdialog = false;
    private int yMaxForAllSvgElements = 0;
    private static final int SCROLLBAR_WIDTH = 10;
    private ScrollbarView scrollbar = null;
    private boolean scrollVertically = false;
    private int viewportBottomY = 0;
    private int viewportBottomYstart = 0;
    private static final int scrollFactor = 10;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public UserDialogView() {
        this.opaque = false;
    }

    private void scrollVerticalBy(int dy) {
        for (int i = 0; i < this.subviews.size(); ++i) {
            View v = (View)this.subviews.elementAt(i);
            v.getRelativeOrgin().y += dy;
            this.setAbsolutePosition(v);
        }
    }

    public void setScrollVertically(boolean scrollVertically) {
        this.scrollVertically = scrollVertically;
        if (scrollVertically && this.scrollbar == null) {
            this.scrollbar = new ScrollbarView();
            Point o = new Point(this.frame.width - 10, 0);
            Size s = new Size(10, this.frame.height);
            this.scrollbar.setFrame(new Rect(o.x, o.y, s.width, s.height));
            this.scrollbar.setMarkerSize((int)((float)this.viewportBottomY / (float)this.yMaxForAllSvgElements * (float)this.frame().height));
            this.scrollbar.scrollToPosition(0);
        }
    }

    public void drawInRect(TactelGraphics g, Rect rect) {
        super.drawInRect(g, rect);
        if (this.scrollVertically) {
            this.setAbsolutePosition(this.scrollbar);
            this.scrollbar.drawInRect(g, rect.rectByIntersectingRect(this.scrollbar.frame()));
        }
    }

    private boolean hasAnInputBoxView(View v) {
        if (v instanceof InputBoxView) {
            return true;
        }
        if (v != null && v.subviews().size() > 0) {
            for (int i = 0; i < v.subviews().size(); ++i) {
                if (!this.hasAnInputBoxView((View)v.subviews().elementAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean event(Event event) {
        if (!this.hasAnInputBoxView(this.getCurrentKeyView())) {
            if (event.type() == 1 && event.keyCode() == -4) {
                event.setKeyCode(-2);
            } else if (event.type() == 1 && event.keyCode() == -3) {
                event.setKeyCode(-1);
            }
        }
        if (event.type() == 1 && event.keyCode() == -2) {
            boolean isAtBottom = this.viewportBottomY >= this.yMaxForAllSvgElements;
            View nextKeyviewView = null;
            if (this.currentKeyView != -1 && this.currentKeyView + 1 <= this.getKeyViews().size() - 1) {
                nextKeyviewView = (View)this.getKeyViews().elementAt(this.currentKeyView + 1);
            }
            if (nextKeyviewView != null && nextKeyviewView.frame().isSubrectOfRectVertically(this.frame)) {
                return super.event(event);
            }
            if (nextKeyviewView == null) {
                if (!isAtBottom) {
                    if (this.scrollbar != null) {
                        if (this.viewportBottomY + 10 > this.yMaxForAllSvgElements) {
                            int lastScrollFactor = 10 - (this.viewportBottomY + 10 - this.yMaxForAllSvgElements);
                            this.scrollVerticalBy(-lastScrollFactor);
                            this.viewportBottomY += lastScrollFactor;
                        } else {
                            this.scrollVerticalBy(-10);
                            this.viewportBottomY += 10;
                        }
                        this.scrollbar.scrollToPosition((int)((float)(this.viewportBottomY - this.viewportBottomYstart) / (float)this.yMaxForAllSvgElements * (float)this.scrollbar.frame().height));
                        this.setNeedsDisplay();
                    }
                    return false;
                }
                return true;
            }
            if (nextKeyviewView != null && !nextKeyviewView.frame().isSubrectOfRectVertically(this.frame)) {
                if (this.scrollbar != null) {
                    if (this.viewportBottomY + 10 > this.yMaxForAllSvgElements) {
                        int lastScrollFactor = 10 - (this.viewportBottomY + 10 - this.yMaxForAllSvgElements);
                        this.scrollVerticalBy(-lastScrollFactor);
                        this.viewportBottomY += lastScrollFactor;
                    } else {
                        this.scrollVerticalBy(-10);
                        this.viewportBottomY += 10;
                    }
                    this.scrollbar.scrollToPosition((int)((float)(this.viewportBottomY - this.viewportBottomYstart) / (float)this.yMaxForAllSvgElements * (float)this.scrollbar.frame().height));
                    this.setNeedsDisplay();
                }
                return false;
            }
        } else if (event.type() == 1 && event.keyCode() == -1) {
            boolean isAtTop = this.viewportBottomY <= this.viewportBottomYstart;
            View nextKeyviewView = null;
            if (this.currentKeyView != -1 && this.currentKeyView > 0) {
                nextKeyviewView = (View)this.getKeyViews().elementAt(this.currentKeyView - 1);
            }
            if (nextKeyviewView != null && nextKeyviewView.frame().isSubrectOfRectVertically(this.frame)) {
                return super.event(event);
            }
            if (nextKeyviewView == null) {
                if (!isAtTop) {
                    if (this.scrollbar != null) {
                        if (this.viewportBottomY - 10 < this.viewportBottomYstart) {
                            int lastScrollFactor = 10 - (this.viewportBottomYstart - (this.viewportBottomY - 10));
                            this.scrollVerticalBy(lastScrollFactor);
                            this.viewportBottomY -= lastScrollFactor;
                        } else {
                            this.scrollVerticalBy(10);
                            this.viewportBottomY -= 10;
                        }
                        this.scrollbar.scrollToPosition((int)((float)(this.viewportBottomY - this.viewportBottomYstart) / (float)this.yMaxForAllSvgElements * (float)this.scrollbar.frame().height));
                        this.setNeedsDisplay();
                    }
                    return false;
                }
                return true;
            }
            if (nextKeyviewView != null && !nextKeyviewView.frame().isSubrectOfRectVertically(this.frame)) {
                if (this.scrollbar != null) {
                    if (this.viewportBottomY - 10 < this.viewportBottomYstart) {
                        int lastScrollFactor = 10 - (this.viewportBottomYstart - (this.viewportBottomY - 10));
                        this.scrollVerticalBy(lastScrollFactor);
                        this.viewportBottomY -= lastScrollFactor;
                    } else {
                        this.scrollVerticalBy(10);
                        this.viewportBottomY -= 10;
                    }
                    this.scrollbar.scrollToPosition((int)((float)(this.viewportBottomY - this.viewportBottomYstart) / (float)this.yMaxForAllSvgElements * (float)this.scrollbar.frame().height));
                    this.setNeedsDisplay();
                }
                return false;
            }
        }
        return super.event(event);
    }

    public String getLeftKeyText() {
        return this.leftKeyText;
    }

    public void setLeftKeyText(String leftKeyText) {
        this.leftKeyText = leftKeyText;
    }

    public String getRightKeyText() {
        return this.rightKeyText;
    }

    public void setRightKeyText(String rightKeyText) {
        this.rightKeyText = rightKeyText;
    }

    public boolean isMtvRootUserDialog() {
        return this.mtvRootUserDialog;
    }

    public void setMtvRootUserDialog(boolean mtvRootUserDialog) {
        this.mtvRootUserDialog = mtvRootUserDialog;
    }

    public boolean getAvoidScaling() {
        return this.avoidScaling;
    }

    public void setAvoidScaling(boolean avoidScaling) {
        this.avoidScaling = avoidScaling;
    }

    public boolean getScalingDone() {
        return this.scalingDone;
    }

    public void setScalingDone(boolean scalingDone) {
        this.scalingDone = scalingDone;
    }

    public Hashtable getTextAreaMap() {
        return this.textAreaMap;
    }

    public void setSvgViewBox(Rect svgViewBox) {
        this.svgViewBox = svgViewBox;
    }

    public Rect getSvgViewBox() {
        return this.svgViewBox;
    }

    public Vector getSubviews() {
        return this.subviews();
    }

    public Vector getRootCommands() {
        return this.rootCommands;
    }

    public void setRootCommands(Vector rootCommands) {
        this.rootCommands = rootCommands;
    }

    public Action getLeftKeyAction() {
        return this.leftKeyAction;
    }

    public void setLeftKeyAction(Action leftKeyAction) {
        this.leftKeyAction = leftKeyAction;
    }

    public Action getRightKeyAction() {
        return this.rightKeyAction;
    }

    public void setRightKeyAction(Action rightKeyAction) {
        this.rightKeyAction = rightKeyAction;
    }

    public int getYMaxForAllSvgElements() {
        return this.yMaxForAllSvgElements;
    }

    public void setYMaxForAllSvgElements(int yMaxForAllSvgElements) {
        this.yMaxForAllSvgElements = yMaxForAllSvgElements;
    }

    public void initViewportBottomY(int viewportBottomY) {
        this.viewportBottomY = viewportBottomY;
        this.viewportBottomYstart = viewportBottomY;
    }

    public boolean isScrollingUserdialog() {
        return this.scrollingUserdialog;
    }

    public void setScrollingUserdialog(boolean scrollingUserdialog) {
        this.scrollingUserdialog = scrollingUserdialog;
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }
}

