/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.windowing;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.gui.common.core.Event;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.graphics.GraphicUtils;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.screen.Animator;
import se.tactel.tvclient.gui.windowing.ApplicationDelegate;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.gui.windowing.WindowServer;
import se.tactel.tvclient.notificationcenter.Notification;
import se.tactel.tvclient.notificationcenter.NotificationCenter;
import se.tactel.tvclient.player.TVPlayer;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Screenshot;

public class ApplicationCanvas
extends Canvas {
    public static final String SHOW_APPLICATION = "ShowNotify";
    public static final String HIDE_APPLICATION = "HideNotify";
    private WindowServer server = null;
    protected ApplicationDelegate delegate;
    private TactelGraphics tactelGraphics;
    boolean keyHeldDown = false;
    boolean ignoreRepeatMode = false;
    public boolean scroll = false;

    public ApplicationCanvas(WindowServer server) {
        this.server = server;
        this.setFullScreenMode(true);
        this.tactelGraphics = GraphicUtils.getTactelGraphics();
    }

    public void setApplicationDelegate(ApplicationDelegate aDelegate) {
        this.delegate = aDelegate;
    }

    protected void keyReleased(int keyValue) {
        if (!this.keyHeldDown) {
            this.postEvent(Event.keyEvent(1, keyValue));
        } else {
            this.keyHeldDown = false;
        }
    }

    protected void keyRepeated(int keyValue) {
        if (!this.keyHeldDown) {
            this.keyHeldDown = true;
            this.ignoreRepeatMode = this.postEvent(Event.keyEvent(2, keyValue));
        } else if (!this.ignoreRepeatMode) {
            this.postEvent(Event.keyEvent(1, keyValue));
        }
    }

    public boolean postEvent(Event event) {
        boolean res = false;
        if (this.server.startupfinished || event.keyCode() == -7) {
            System.out.println("post event thread " + Thread.currentThread());
            try {
                Window kw;
                if (this.delegate != null) {
                    res |= this.delegate.eventForApplication(event, this);
                }
                if ((kw = this.server.keyWindow()) != null) {
                    res |= kw.event(event);
                }
                this.server.redraw();
            }
            catch (Throwable t) {
                Log.exception((Object)this, t);
            }
        }
        return res;
    }

    public void takeScreenshot() {
        Screenshot.setSize(240, 320);
        Graphics graphics = Screenshot.getGraphics();
        TactelGraphics tactelGraphics = GraphicUtils.getTactelGraphics();
        tactelGraphics.useGraphics(graphics);
        this.server.background.drawInRect(tactelGraphics, new Rect(0, 0, tactelGraphics.getClipRect().width, tactelGraphics.getClipRect().height));
        Screenshot.saveBMP();
    }

    protected void hideNotify() {
        NotificationCenter.defaultCenter().postNotification(new Notification(HIDE_APPLICATION, null, null));
        if (this.delegate != null) {
            this.delegate.hideNotify();
        }
    }

    protected void showNotify() {
        NotificationCenter.defaultCenter().postNotification(new Notification(SHOW_APPLICATION, null, null));
        if (this.delegate != null) {
            this.delegate.showNotify();
        }
        this.server.display();
    }

    public void paint(Graphics g) {
        if (!this.scroll) {
            this.doNormalRedraw(g);
        } else {
            this.doScroll(g);
        }
    }

    private void doScroll(Graphics g) {
        g.drawRegion(Animator.animationBufferImage, 0, 39, Skin.SCREEN_RECT.width, 224, 0, 0, 39, 20);
    }

    protected void pointerDragged(int x, int y) {
        this.postEvent(Event.pointerDraggedEvent(new Point(x, y)));
    }

    protected void pointerPressed(int x, int y) {
        this.postEvent(Event.pointerPressedEvent(new Point(x, y)));
    }

    protected void pointerReleased(int x, int y) {
        this.postEvent(Event.pointerRelesedEvent(new Point(x, y)));
    }

    protected void sizeChanged(int y, int x) {
        if (this.delegate != null) {
            this.delegate.sizeChanged(new Point(x, y));
        } else {
            super.sizeChanged(x, y);
        }
    }

    private void doNormalRedraw(Graphics g) {
        Vector vork = this.server.background.getInvalidViews();
        Rect playerFrame = null;
        TVPlayer player = ServiceRegistry.instance().getPlayer();
        if (player != null) {
            playerFrame = ServiceRegistry.instance().getPlayer().getPlayerFrame();
        }
        if (vork == null) {
            return;
        }
        Log.log(0x100000L, "DoRedraw with views: " + (vork == null ? "null" : Integer.toString(vork.size())));
        this.tactelGraphics.useGraphics(g);
        for (int i = 0; i < vork.size(); ++i) {
            try {
                View view = (View)vork.elementAt(i);
                Rect rect = view.frame();
                if (!view.isActive()) continue;
                View ancestor = view.opaqueAncestor();
                rect = rect.rectByIntersectingRect(ancestor.frame());
                Log.log(0x100000L, ">Canvas redraw: " + rect);
                if (!rect.isNullRect() && ancestor.isActive()) {
                    if (playerFrame != null && ServiceRegistry.instance().getPlayer().isPlayerVisible() && rect.intersectsRect(playerFrame)) {
                        this.drawRectInViewOutsideRect(this.tactelGraphics, rect, ancestor, playerFrame);
                    } else {
                        ancestor.drawInRect(this.tactelGraphics, rect);
                    }
                }
                Vector v = this.server.background.subviews();
                View content = this.getContentViewForView(ancestor);
                if (content == null) continue;
                Enumeration en = v.elements();
                while (en.hasMoreElements() && en.nextElement() != content) {
                }
                while (en.hasMoreElements()) {
                    View windowView = (View)en.nextElement();
                    if (!windowView.frame().intersectsRect(rect)) continue;
                    if (playerFrame != null && ServiceRegistry.instance().getPlayer().isPlayerVisible() && rect.intersectsRect(playerFrame)) {
                        this.drawRectInViewOutsideRect(this.tactelGraphics, rect, windowView, playerFrame);
                        continue;
                    }
                    windowView.drawInRect(this.tactelGraphics, rect.rectByIntersectingRect(windowView.frame()));
                }
                continue;
            }
            catch (Exception e) {
                Log.exception((Object)this, e);
            }
        }
        vork.removeAllElements();
        vork = null;
    }

    private void drawRectInViewOutsideRect(TactelGraphics g, Rect rect, View view, Rect avoid) {
        Rect[] rects = rect.rectsBySubtractingRect(avoid);
        for (int i = 0; i < rects.length; ++i) {
            view.drawInRect(g, rects[i]);
        }
    }

    private View getContentViewForView(View v) {
        View res;
        View back = this.server.background;
        for (res = v; res != null && res.parent() != back; res = res.parent()) {
        }
        return res;
    }
}

