/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.gui.windowing;

import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;
import se.tactel.tvclient.gui.common.core.View;
import se.tactel.tvclient.gui.constants.Skin;
import se.tactel.tvclient.gui.graphics.GraphicUtils;
import se.tactel.tvclient.gui.graphics.TactelGraphics;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.gui.position.Size;
import se.tactel.tvclient.gui.screen.tab.tv.TVWindow;
import se.tactel.tvclient.gui.userdialog.UserDialogView;
import se.tactel.tvclient.gui.windowing.ApplicationCanvas;
import se.tactel.tvclient.gui.windowing.NotPossibleToGoBackWindow;
import se.tactel.tvclient.gui.windowing.Window;
import se.tactel.tvclient.util.Log;
import se.tactel.tvclient.util.Screenshot;

public class WindowServer
implements Runnable {
    public Object lock = new Object();
    private boolean animating = false;
    private boolean run = false;
    private MIDlet midlet;
    private Size screenSize;
    Window keyWindow = null;
    View background = null;
    protected Stack windowstack = null;
    private Stack gotoBackWindowStack = new Stack();
    Window modalWindow = null;
    ApplicationCanvas appCanvas = null;
    protected boolean startupfinished;

    public WindowServer() {
        this.background = new View();
        this.background.setFrame(new Rect(0, 0, 0, 0));
        this.background.setBackgroundColor(-1);
        this.background.setDrawsBackground(true);
        this.background.setActive(true);
        this.windowstack = new Stack();
    }

    private void orderFrontSubviews(Window window) {
        Vector subviews = this.background.subviews();
        View content = window.contentView();
        View buttons = window.buttonBar();
        if (content != null) {
            if (subviews.contains(content)) {
                subviews.removeElement(content);
            }
            subviews.addElement(content);
        }
        if (buttons != null) {
            if (subviews.contains(buttons)) {
                subviews.removeElement(buttons);
            }
            subviews.addElement(buttons);
        }
    }

    private void orderBackSubviews(Window window) {
        Vector subviews = this.background.subviews();
        View content = window.contentView();
        View buttons = window.buttonBar();
        if (content != null) {
            if (subviews.contains(content)) {
                subviews.removeElement(content);
            }
            subviews.insertElementAt(content, 0);
        }
        if (buttons != null) {
            if (subviews.contains(buttons)) {
                subviews.removeElement(buttons);
            }
            subviews.insertElementAt(buttons, 0);
        }
    }

    private void orderOutSubviews(Window window) {
        Vector subviews = this.background.subviews();
        View content = window.contentView();
        View buttons = window.buttonBar();
        if (content != null && subviews.contains(content)) {
            subviews.removeElement(content);
        }
        if (buttons != null && subviews.contains(buttons)) {
            subviews.removeElement(buttons);
        }
    }

    private Window lastKeyWindow() {
        for (int i = this.windowstack.size() - 1; i >= 0; --i) {
            Window w = (Window)this.windowstack.elementAt(i);
            if (!w.canBecomeKeyWindow()) continue;
            return w;
        }
        return null;
    }

    public synchronized void orderBack(Window window) {
        if (window != this.modalWindow) {
            boolean wasOnTop = false;
            if (this.windowstack.size() > 0 && window == this.windowstack.lastElement()) {
                wasOnTop = true;
            }
            if (this.windowstack.contains(window)) {
                this.windowstack.removeElement(window);
            }
            this.windowstack.insertElementAt(window, 0);
            this.orderBackSubviews(window);
            window.display();
            if (this.windowstack.size() > 1 && wasOnTop) {
                window.didLoseTopWindow();
                Window newTopWindow = (Window)this.windowstack.lastElement();
                newTopWindow.didBecomeTopWindow();
            }
        }
    }

    public synchronized void orderFront(Window window) {
        boolean isOnTop = false;
        if (this.windowstack.size() > 0 && window == this.windowstack.lastElement()) {
            isOnTop = true;
        }
        if (window != null && this.windowstack.contains(window)) {
            this.windowstack.removeElement(window);
        }
        Window previousTopWindow = null;
        if (this.windowstack.size() > 0) {
            previousTopWindow = (Window)this.windowstack.lastElement();
        }
        this.windowstack.addElement(window);
        this.orderFrontSubviews(window);
        window.display();
        if (this.modalWindow != null && window != this.modalWindow && !window.isModal()) {
            this.orderFront(this.modalWindow);
        } else if (!isOnTop) {
            if (previousTopWindow != null) {
                previousTopWindow.didLoseTopWindow();
            }
            window.didBecomeTopWindow();
        }
    }

    public synchronized void orderOut(Window window) {
        if (window == this.modalWindow) {
            this.modalWindow = null;
        }
        boolean isOnTop = false;
        if (this.windowstack.contains(window)) {
            if (this.windowstack.size() > 0) {
                boolean bl = isOnTop = window == (Window)this.windowstack.lastElement();
                if (isOnTop) {
                    window.didLoseTopWindow();
                }
            }
            this.windowstack.removeElement(window);
        }
        if (this.windowstack.size() > 0) {
            if (window == this.keyWindow) {
                this.updateKeyWindow(this.lastKeyWindow());
            }
            if (isOnTop) {
                ((Window)this.windowstack.lastElement()).didBecomeTopWindow();
            }
        }
        this.orderOutSubviews(window);
    }

    public synchronized void closeWindow(Window window) {
        this.orderOut(window);
        if (window.frame() != null) {
            this.background.setNeedsDisplay();
            this.redraw();
        }
    }

    public synchronized void showPrevious() {
        if (this.gotoBackWindowStack.size() < 2) {
            Log.log(0x500000000L, "Attempting to go back to previous window but there's none.");
            return;
        }
        Window currentWindow = (Window)this.gotoBackWindowStack.pop();
        if (this.gotoBackWindowStack.peek() instanceof NotPossibleToGoBackWindow && this.gotoBackWindowStack.size() > 1) {
            while ((this.gotoBackWindowStack.peek() instanceof NotPossibleToGoBackWindow || this.gotoBackWindowStack.peek() == currentWindow) && this.gotoBackWindowStack.size() > 1) {
                this.gotoBackWindowStack.pop();
            }
        }
        if (!(this.gotoBackWindowStack.peek() instanceof NotPossibleToGoBackWindow)) {
            Window windowToGoBackTo = (Window)this.gotoBackWindowStack.peek();
            Log.log(0x600000000L, "Showing previous windows: " + windowToGoBackTo);
            boolean isOnTop = false;
            if (this.windowstack.size() > 0 && windowToGoBackTo == this.windowstack.lastElement()) {
                isOnTop = true;
            }
            if (windowToGoBackTo != null && this.windowstack.contains(windowToGoBackTo)) {
                this.windowstack.removeElement(windowToGoBackTo);
            }
            if (windowToGoBackTo.canBecomeKeyWindow()) {
                this.updateKeyWindow(windowToGoBackTo);
            }
            windowToGoBackTo.setVisible(true);
            windowToGoBackTo.setActive(true);
            Window previousTopWindow = null;
            if (this.windowstack.size() > 0) {
                previousTopWindow = (Window)this.windowstack.lastElement();
            }
            this.windowstack.addElement(windowToGoBackTo);
            this.orderFrontSubviews(windowToGoBackTo);
            windowToGoBackTo.display();
            if (this.modalWindow != null && windowToGoBackTo != this.modalWindow) {
                this.orderFront(this.modalWindow);
            } else if (!isOnTop) {
                if (previousTopWindow != null) {
                    previousTopWindow.didLoseTopWindow();
                }
                windowToGoBackTo.didBecomeTopWindow();
            }
        } else {
            Log.log(0x500000000L, "Attempting to go back to previous window but there's none.");
        }
    }

    public Window keyWindow() {
        return this.keyWindow;
    }

    public Window getTopmostWindow() {
        if (this.windowstack.size() > 0) {
            return (Window)this.windowstack.lastElement();
        }
        return null;
    }

    public synchronized void makeKeyWindow(Window window) {
        if (this.modalWindow == null || window.isModal()) {
            this.updateKeyWindow(window);
        }
    }

    private void updateKeyWindow(Window w) {
        this.keyWindow = w;
        Log.log(0x600000000L, "Set key window: " + this.keyWindow);
        Log.log(0x600000000L, "Top of go back stack: " + (this.gotoBackWindowStack.size() > 0 ? this.gotoBackWindowStack.peek() : "EMPTY"));
        if (!(this.keyWindow == null || this.keyWindow.contentView() instanceof UserDialogView || this.gotoBackWindowStack.size() > 0 && this.gotoBackWindowStack.peek() == w)) {
            this.gotoBackWindowStack.push(w);
            Log.log(0x400000000L, "Pushed window " + w + " (containing " + w.contentView() + ") on goto back stack.");
        }
    }

    public void display() {
        this.background.setNeedsDisplay();
        this.redraw();
    }

    public synchronized void init() {
        if (!this.run) {
            this.run = true;
            new Thread(this).start();
            this.display();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (this.run) {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait(200L);
                        if (this.animating) continue;
                    }
                    this.appCanvas.repaint();
                    this.appCanvas.serviceRepaints();
                }
                catch (Exception e) {
                    Log.exception(this, e);
                }
            }
            return;
        }
        catch (Exception e) {
            Log.exception(this, e);
        }
    }

    public void stop() {
        this.run = false;
        this.redraw();
    }

    public void redraw() {
        this.appCanvas.repaint();
        this.appCanvas.serviceRepaints();
    }

    public void useDefaultCanvas() {
        this.setCanvas(new ApplicationCanvas(this));
    }

    public void setCanvas(ApplicationCanvas applicationCanvas) {
        this.appCanvas = applicationCanvas;
        this.setScreenSize(new Size(Skin.SCREEN_RECT.width, Skin.SCREEN_RECT.height));
        this.displayCanvas();
    }

    public Canvas canvas() {
        return this.appCanvas;
    }

    public View background() {
        return this.background;
    }

    public synchronized boolean runModalForWindow(Window window) {
        if (this.modalWindow == null) {
            this.keyWindow = window;
            Log.log(0x600000000L, "runModalForWindow, setting keywindow to " + this.keyWindow);
            this.modalWindow = window;
            this.orderFront(window);
            return true;
        }
        return false;
    }

    public void setMidlet(MIDlet client) {
        this.midlet = client;
        this.displayCanvas();
    }

    public void setScreenSize(Size size) {
        this.screenSize = size;
        this.background.frame().setSize(this.screenSize);
    }

    public Size getScreenSize() {
        return new Size(this.screenSize);
    }

    private void displayCanvas() {
        if (this.appCanvas != null && this.midlet != null) {
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.appCanvas);
        }
    }

    public void orderOutAllWindows() {
        Enumeration en = this.windowstack.elements();
        while (en.hasMoreElements()) {
            Window temp = (Window)en.nextElement();
            temp.orderOut();
        }
    }

    public synchronized void setLockDrawing(boolean animating) {
        this.animating = animating;
    }

    public synchronized boolean getLockDrawing() {
        return this.animating;
    }

    public void takeScreenshot() {
        Screenshot.setSize(this.background.frame().width, this.background.frame().height);
        Graphics graphics = Screenshot.getGraphics();
        TactelGraphics tactelGraphics = GraphicUtils.getTactelGraphics();
        tactelGraphics.useGraphics(graphics);
        this.background.drawInRect(tactelGraphics, new Rect(0, 0, tactelGraphics.getClipRect().width, tactelGraphics.getClipRect().height));
        Screenshot.saveBMP();
    }

    public boolean isTVWindowInStack() {
        for (int i = 0; i < this.windowstack.size(); ++i) {
            Window w = (Window)this.windowstack.elementAt(i);
            if (!(w instanceof TVWindow)) continue;
            return true;
        }
        return false;
    }

    public void setStartupFinished() {
        this.startupfinished = true;
    }
}

