/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.network.protocols;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.data.Channel;
import se.tactel.tvclient.data.ChannelList;
import se.tactel.tvclient.data.CurrentError;
import se.tactel.tvclient.network.protocols.Protocol;
import se.tactel.tvclient.util.Log;

public class NinProtocolVersion1_0
extends Protocol {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(XmlPullParser parser) throws Protocol.ParseException {
        boolean updated = false;
        boolean channelsChanged = false;
        ServiceRegistry.instance().getDataProvider().getChannelConfiguration();
        Enumeration ee = ServiceRegistry.instance().getDataProvider().getChannelList().getAll().elements();
        Vector<String> knownChannels = new Vector<String>();
        while (ee.hasMoreElements()) {
            knownChannels.addElement(((Channel)ee.nextElement()).getId());
        }
        try {
            int eventType = parser.getEventType();
            ChannelList channelList = ServiceRegistry.instance().getDataProvider().getChannelList();
            ServiceRegistry.instance().getPlayer().setNINRespond(true);
            String menu = "";
            block13: do {
                String name = parser.getName();
                switch (eventType) {
                    case 2: {
                        if (name.equals("menu")) {
                            menu = parser.getAttributeValue(null, "id");
                            channelsChanged = true;
                            break;
                        }
                        if (name.equals("content")) {
                            String channelInformationUri;
                            String channelInformation;
                            String channelIconURL;
                            String channelName;
                            String channelId = parser.getAttributeValue(null, "key");
                            Channel currentChannel = null;
                            currentChannel = channelList.contains(channelId) ? channelList.getChannel(channelId) : new Channel(channelId);
                            Channel oldChannel = new Channel(currentChannel);
                            channelList.updateChannel(currentChannel);
                            currentChannel.setMenu(menu);
                            knownChannels.removeElement(currentChannel.getId());
                            currentChannel.setAvailableOnNin(true);
                            if (ServiceRegistry.instance().getDataProvider().getChannelList().getAllChannels().size() > 0 && !ServiceRegistry.instance().getDataProvider().getChannelList().contains(currentChannel.getId())) {
                                ServiceRegistry.instance().getDataProvider().getChannelConfiguration().setChannelVisible(currentChannel.getId(), false);
                            }
                            if ((channelName = parser.getAttributeValue(null, "name")) != null) {
                                currentChannel.setName(channelName);
                            }
                            if ((channelIconURL = parser.getAttributeValue(null, "icon")) != null) {
                                currentChannel.setIconUrl(channelIconURL);
                            }
                            if ((channelInformation = parser.getAttributeValue(null, "information")) != null) {
                                currentChannel.setDescription(channelInformation);
                            }
                            if ((channelInformationUri = parser.getAttributeValue(null, "informationUrl")) == null) {
                                channelInformationUri = parser.getAttributeValue(null, "informationUri");
                            }
                            if (channelInformationUri != null) {
                                currentChannel.setInformationUrl(channelInformationUri);
                            }
                            Log.log(0x200000200L, "Updating content: " + currentChannel.toString());
                            updated |= !currentChannel.equals(oldChannel);
                            break;
                        }
                        if (name.equals("rtsp")) {
                            String rtspurl = parser.getAttributeValue(null, "uri");
                            if (rtspurl == null) continue block13;
                            ServiceRegistry.instance().getDataProvider().getConfig().setStreamingUrl(rtspurl);
                            int i = rtspurl.indexOf("UID=");
                            if (i != -1) {
                                ServiceRegistry.instance().getDataProvider().getConfig().setUid(rtspurl.substring(i + "UID=".length()));
                            }
                            Log.log(0x200000200L, "Saved stream URL: " + rtspurl);
                            break;
                        }
                        if (name.equals("ECDSTV")) {
                            String ecdsVersion = parser.getAttributeValue(null, "version");
                            if (ecdsVersion == null) continue block13;
                            if (ecdsVersion.equals("1.0")) {
                                Log.log(0x200000200L, "Response from ECDS version 1.0");
                                break;
                            }
                            Log.log(0x40000200L, "Response from unsupported ECDS version " + ecdsVersion);
                            break;
                        }
                        if (name.equals("error") || name.equals("response")) {
                            Log.log(0x100000200L, "Error tag encountered");
                            String code = parser.getAttributeValue(null, "statusCode");
                            String description = parser.getAttributeValue(null, "information");
                            if (!"200".equals(code)) {
                                Log.log(0x40000200L, "\"" + name + "\" tag encountered with code=\"" + code + "\" description=\"" + description + "\"");
                                CurrentError ce = new CurrentError();
                                if (code != null && !"".equals(code)) {
                                    ce.setCode(code);
                                }
                                if (description != null && !"".equals(description)) {
                                    ce.setDescription(description);
                                }
                                ServiceRegistry.instance().getPlayer().setNINRespond(false);
                                ServiceRegistry.instance().getDataProvider().setCurrentNiNError(ce);
                                break;
                            }
                            Log.log(0x200000200L, "Error/Response tag encountered code=\"" + code + "\" description=\"" + description + "\"");
                            break;
                        }
                        if (name.equals("clientInformation") || name.equals("startContent") || name.equals("menu") || name.equals("command") || name.equals("keyNum") || name.equals("clientOptional") || name.equals("startChannel")) {
                            Log.log(0x200000200L, "Ignoring expected tag: " + name);
                            break;
                        }
                        Log.log(0x100000200L, "Ignoring not expected tag: " + name);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
            } while ((eventType = parser.next()) != 1);
        }
        catch (XmlPullParserException e) {
            Log.exception(this, e);
        }
        catch (IOException e) {
            Log.exception(this, e);
        }
        finally {
            if (channelsChanged) {
                for (int i = 0; i < knownChannels.size(); ++i) {
                    Channel c = ServiceRegistry.instance().getDataProvider().getChannelList().getChannel((String)knownChannels.elementAt(i));
                    c.setAvailableOnNin(false);
                    Log.log(0x200000200L, "The following channel (id=" + c.getId() + ") has been removed from the server and is marked as not available on NIN");
                    updated = true;
                }
            }
            if (updated) {
                ServiceRegistry.instance().getDataProvider().getChannelConfiguration().compressOrder();
                Log.log(0x200000200L, "Notification of subscribed status listeners!");
                ServiceRegistry.instance().getDataProvider().getChannelList().notifyObservers();
            } else {
                Log.log(0x200000200L, "No notification needed. No update!");
            }
        }
    }
}

