/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.network.protocols;

import java.util.Vector;
import org.xmlpull.v1.XmlPullParser;
import se.tactel.tvclient.gui.position.Point;
import se.tactel.tvclient.gui.position.Rect;
import se.tactel.tvclient.util.Log;

public class UserDialogParser {
    public static Rect parseSvgViewBox(String list) {
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        try {
            Vector v = UserDialogParser.splitString(list);
            x1 = Integer.parseInt((String)v.elementAt(0));
            y1 = Integer.parseInt((String)v.elementAt(1));
            x2 = Integer.parseInt((String)v.elementAt(2));
            y2 = Integer.parseInt((String)v.elementAt(3));
        }
        catch (NumberFormatException e) {
            Log.log(0x80000000L, "Svg viewbox parse exception: " + e.getMessage());
        }
        return new Rect(x1, y1, x2 - x1, y2 - y1);
    }

    public static Vector getButtonIdParameters(String id) {
        String p;
        Vector<String> v = new Vector<String>();
        int where = 0;
        while (true) {
            int stop;
            if ((stop = id.indexOf(46, where)) == -1) break;
            p = id.substring(where, stop);
            v.addElement(p);
            where = stop + 1;
        }
        p = id.substring(where);
        v.addElement(p);
        if (v.size() > 0) {
            String lastString = (String)v.elementAt(v.size() - 1);
            int dashPosition = lastString.indexOf("-");
            if (dashPosition != -1) {
                String lastParameter = lastString.substring(0, dashPosition);
                v.removeElementAt(v.size() - 1);
                v.addElement(lastParameter);
            }
            v.removeElementAt(0);
        }
        return v;
    }

    public static Vector splitString(String list) {
        String p;
        Vector<String> v = new Vector<String>();
        int where = 0;
        while (true) {
            int stop;
            if ((stop = list.indexOf(32, where)) == -1) break;
            p = list.substring(where, stop);
            v.addElement(p);
            where = stop + 1;
        }
        p = list.substring(where);
        v.addElement(p);
        return v;
    }

    public static Vector splitStringToPoints(Vector stringVector, Rect referenceFrame) {
        Vector<Point> pointVector = new Vector<Point>();
        String strPoint = null;
        int stop = 0;
        int x = 0;
        int y = 0;
        if (stringVector != null) {
            for (int a = 0; a < stringVector.size(); ++a) {
                strPoint = (String)stringVector.elementAt(a);
                stop = 0;
                x = 0;
                y = 0;
                if (strPoint != null) {
                    stop = strPoint.indexOf(44, 0);
                }
                if (stop == -1) continue;
                String strX = strPoint.substring(0, stop);
                String strY = strPoint.substring(stop + 1);
                if (strX == null || strY == null) continue;
                try {
                    if (strX.length() > 0) {
                        x = !Character.isDigit(strX.charAt(strX.length() - 1)) ? UserDialogParser.parseNumberWithUnit(strX, referenceFrame.width) : Integer.parseInt(strX);
                    }
                    if (strY.length() > 0) {
                        y = !Character.isDigit(strY.charAt(strY.length() - 1)) ? UserDialogParser.parseNumberWithUnit(strY, referenceFrame.height) : Integer.parseInt(strY);
                    }
                    Point p = new Point(x, y);
                    pointVector.addElement(p);
                    continue;
                }
                catch (NumberFormatException e) {
                    Log.log(0x80000000L, "oops... bad format: " + e.getMessage());
                }
            }
        }
        return pointVector;
    }

    public static int parseNumberWithUnit(String stringToParse, int referenceNumber) {
        int parsedValue = 0;
        if (stringToParse.endsWith("%")) {
            try {
                stringToParse = stringToParse.substring(0, stringToParse.length() - 1);
                parsedValue = Integer.parseInt(stringToParse);
                parsedValue = (int)((double)referenceNumber * (double)parsedValue / 100.0);
                return parsedValue;
            }
            catch (Exception e) {
                return 0;
            }
        }
        if (stringToParse.endsWith("px")) {
            try {
                stringToParse = stringToParse.substring(0, stringToParse.length() - 2);
                parsedValue = Integer.parseInt(stringToParse);
                return parsedValue;
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }

    public static Rect parseFrame(XmlPullParser parser, Rect referenceFrame) {
        Rect rect = null;
        String tx = parser.getAttributeValue(null, "x");
        String ty = parser.getAttributeValue(null, "y");
        String tw = parser.getAttributeValue(null, "width");
        String th = parser.getAttributeValue(null, "height");
        if (tx != null && tx.indexOf(".") != -1) {
            Log.log(0x200000L, "x value probably contains a float: " + tx);
            tx = tx.substring(0, tx.indexOf("."));
            Log.log(0x200000L, "x truncated to: " + tx);
        }
        if (ty != null && ty.indexOf(".") != -1) {
            Log.log(0x200000L, "y value probably contains a float: " + ty);
            ty = ty.substring(0, ty.indexOf("."));
            Log.log(0x200000L, "y truncated to: " + ty);
        }
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        if (tx != null && tx.length() > 0) {
            x = !Character.isDigit(tx.charAt(tx.length() - 1)) ? UserDialogParser.parseNumberWithUnit(tx, referenceFrame.width) : Integer.parseInt(tx);
        }
        x -= referenceFrame.x;
        if (ty != null && ty.length() > 0) {
            y = !Character.isDigit(ty.charAt(ty.length() - 1)) ? UserDialogParser.parseNumberWithUnit(ty, referenceFrame.height) : Integer.parseInt(ty);
        }
        y -= referenceFrame.y;
        try {
            if (tw != null && tw.length() > 0) {
                w = !Character.isDigit(tw.charAt(tw.length() - 1)) ? UserDialogParser.parseNumberWithUnit(tw, referenceFrame.width) : Integer.parseInt(tw);
            }
            if (th != null && th.length() > 0) {
                h = !Character.isDigit(th.charAt(th.length() - 1)) ? UserDialogParser.parseNumberWithUnit(th, referenceFrame.height) : Integer.parseInt(th);
            }
        }
        catch (NumberFormatException e) {
            Log.log(0x80000000L, "Formatting exeption: " + e.getMessage());
        }
        rect = new Rect(x, y, w, h);
        return rect;
    }

    public static Rect parseEllipse(XmlPullParser parser, Rect referenceFrame, String name) {
        String strR = parser.getAttributeValue(null, "r");
        String strX = parser.getAttributeValue(null, "cx");
        String strY = parser.getAttributeValue(null, "cy");
        String strRx = parser.getAttributeValue(null, "rx");
        String strRy = parser.getAttributeValue(null, "ry");
        Rect frame = new Rect();
        try {
            int r = 0;
            int cx = 0;
            int cy = 0;
            int rx = 0;
            int ry = 0;
            if (strR != null && strR.length() > 0) {
                r = !Character.isDigit(strR.charAt(strR.length() - 1)) ? UserDialogParser.parseNumberWithUnit(strR, referenceFrame.width) : Integer.parseInt(strR);
            }
            if (strX != null) {
                cx = !Character.isDigit(strX.charAt(strX.length() - 1)) ? UserDialogParser.parseNumberWithUnit(strX, referenceFrame.width) : Integer.parseInt(strX);
            }
            cx -= referenceFrame.x;
            if (strY != null) {
                cy = !Character.isDigit(strY.charAt(strY.length() - 1)) ? UserDialogParser.parseNumberWithUnit(strY, referenceFrame.height) : Integer.parseInt(strY);
            }
            cy -= referenceFrame.y;
            if (strRx != null) {
                rx = !Character.isDigit(strRx.charAt(strRx.length() - 1)) ? UserDialogParser.parseNumberWithUnit(strRx, referenceFrame.width) : Integer.parseInt(strRx);
            }
            if (strRy != null) {
                ry = !Character.isDigit(strRy.charAt(strRy.length() - 1)) ? UserDialogParser.parseNumberWithUnit(strRy, referenceFrame.height) : Integer.parseInt(strRy);
            }
            if (name.equals("circle")) {
                frame.width = frame.height = 2 * r;
                frame.x = cx - (r - 1);
                frame.y = cy - (r - 1);
            } else if (name.equals("ellipse")) {
                frame.width = 2 * rx;
                frame.height = 2 * ry;
                frame.x = cx - (rx - 1);
                frame.y = cy - (ry - 1);
            }
        }
        catch (NumberFormatException e) {
            Log.log(0x80000000L, "oops... bad format: " + e.getMessage());
        }
        return frame;
    }

    public static Vector parseLine(XmlPullParser parser, Rect referenceFrame) {
        String strX1 = parser.getAttributeValue(null, "x1");
        String strY1 = parser.getAttributeValue(null, "y1");
        String strX2 = parser.getAttributeValue(null, "x2");
        String strY2 = parser.getAttributeValue(null, "y2");
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        try {
            if (strX1 != null && strX1.length() > 0) {
                x1 = !Character.isDigit(strX1.charAt(strX1.length() - 1)) ? UserDialogParser.parseNumberWithUnit(strX1, referenceFrame.width) : Integer.parseInt(strX1);
                x1 -= referenceFrame.x;
            }
            if (strY1 != null && strY1.length() > 0) {
                y1 = !Character.isDigit(strY1.charAt(strY1.length() - 1)) ? UserDialogParser.parseNumberWithUnit(strY1, referenceFrame.height) : Integer.parseInt(strY1);
                y1 -= referenceFrame.y;
            }
            if (strX2 != null && strX2.length() > 0) {
                x2 = !Character.isDigit(strX2.charAt(strX2.length() - 1)) ? UserDialogParser.parseNumberWithUnit(strX2, referenceFrame.width) : Integer.parseInt(strX2);
                x2 -= referenceFrame.x;
            }
            if (strY2 != null && strY2.length() > 0) {
                y2 = !Character.isDigit(strY2.charAt(strY2.length() - 1)) ? UserDialogParser.parseNumberWithUnit(strY2, referenceFrame.height) : Integer.parseInt(strY2);
                y2 -= referenceFrame.y;
            }
        }
        catch (NumberFormatException e) {
            Log.log(0x80000000L, "oops... line percentage: " + e.getMessage());
        }
        Vector<Point> v = new Vector<Point>();
        v.addElement(new Point(x1, y1));
        v.addElement(new Point(x2, y2));
        return v;
    }
}

