/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.resource;

import se.tactel.tvclient.ServiceRegistry;
import se.tactel.tvclient.resource.Resource;
import se.tactel.tvclient.resource.ResourceCache;
import se.tactel.tvclient.resource.ResourceImpl;
import se.tactel.tvclient.util.Log;

public class ResourceManager {
    ResourceCache defaultCache;
    ResourceCache slide1Cache;
    ResourceCache slide2Cache;
    static final String DEFAULT_CACHE_RECORDSTORE_NAME = "defaultcache";
    static final String SLIDE1_CACHE_RECORDSTORE_NAME = "slide1cache";
    static final String SLIDE2_CACHE_RECORDSTORE_NAME = "slide2cache";
    private static ResourceManager instance = null;

    public Resource getResource(String id) {
        return this.getResource(this.defaultCache, id);
    }

    public Resource getSlideResource(int cacheNumber, String id) {
        if (cacheNumber == 1) {
            return this.getResource(this.slide1Cache, id);
        }
        if (cacheNumber == 2) {
            return this.getResource(this.slide2Cache, id);
        }
        return null;
    }

    public boolean isSlideResourceCached(int cacheNumber, Resource slideResource) {
        if (cacheNumber == 1) {
            return this.slide1Cache.isResourceCached(slideResource);
        }
        if (cacheNumber == 2) {
            return this.slide2Cache.isResourceCached(slideResource);
        }
        return false;
    }

    private Resource getResource(ResourceCache cache, String id) {
        if (id != null) {
            try {
                byte[] downloadedData;
                ResourceImpl resourceToReturn = cache.getResourceFromCache(id);
                if (resourceToReturn == null && (downloadedData = ServiceRegistry.instance().getComm().getByteArray(id)) != null) {
                    resourceToReturn = new ResourceImpl(id, downloadedData);
                    cache.updateResourceInCache(resourceToReturn);
                }
                return resourceToReturn;
            }
            catch (OutOfMemoryError e) {
                System.gc();
                Log.log(0x40000100L, e.toString());
                return null;
            }
        }
        return null;
    }

    public Resource getResourceOnlyFromCache(String id) {
        ResourceImpl res = null;
        if (id != null) {
            res = this.defaultCache.getResourceFromCache(id);
            if (res == null) {
                res = this.slide1Cache.getResourceFromCache(id);
            }
            if (res == null) {
                res = this.slide2Cache.getResourceFromCache(id);
            }
        }
        return res;
    }

    public void releaseData(Resource resource) {
        if (this.defaultCache.releaseDataForResource(resource) && this.slide1Cache.releaseDataForResource(resource) && this.slide2Cache.releaseDataForResource(resource)) {
            Log.log(0x100000100L, "Couldn't release resource: " + resource);
        }
    }

    public void clearSlideCache(int id) {
        Log.log(256L, "Cleaning slide cache " + id);
        if (id == 1) {
            this.slide1Cache.clearCache();
        } else if (id == 2) {
            this.slide2Cache.clearCache();
        }
    }

    private ResourceManager() {
        Log.log(0x200000100L, "Constructing ResourceManager instance.");
        this.defaultCache = new ResourceCache(DEFAULT_CACHE_RECORDSTORE_NAME, 0, 0);
        this.slide1Cache = new ResourceCache(SLIDE1_CACHE_RECORDSTORE_NAME, 0, 0);
        this.slide2Cache = new ResourceCache(SLIDE2_CACHE_RECORDSTORE_NAME, 0, 0);
    }

    public static synchronized ResourceManager instance() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }
}

