/*
 * Decompiled with CFR 0.152.
 */
package se.tactel.tvclient.util;

import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import se.tactel.tvclient.util.LogInterface;

public class LocalFileLog
implements LogInterface {
    private static String FILE_NAME_PREFIX = "c:/other/MTV_log_";
    OutputStream os = null;
    FileConnection fc = null;
    boolean running = false;

    public LocalFileLog() {
        try {
            this.fc = this.getFileConnection(FILE_NAME_PREFIX + System.currentTimeMillis() % 100000000L + ".txt");
            if (this.fc != null) {
                this.fc.create();
                this.os = this.fc.openOutputStream();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void log(String message) {
        if (this.os != null) {
            try {
                String timeStr = Long.toString(System.currentTimeMillis()) + ":";
                this.os.write(timeStr.getBytes());
                this.os.write((message + "\r\n").getBytes());
                this.os.flush();
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }

    public void close() {
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.os = null;
        }
        if (this.fc != null) {
            try {
                this.fc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fc = null;
        }
    }

    private FileConnection getFileConnection(String filename) {
        String FILE_URL_PREFIX = "file:///";
        if (filename.charAt(0) != '/') {
            filename = "/" + filename;
        }
        try {
            return (FileConnection)Connector.open((String)("file:///" + filename), (int)3);
        }
        catch (IOException e) {
            return null;
        }
    }
}

