/*
 * Decompiled with CFR 0.152.
 */
package com.beeweeb.globallauncher.net;

import com.beeweeb.globallauncher.Launcher;
import com.beeweeb.globallauncher.model.InstantLauncherData;
import com.beeweeb.globallauncher.net.LauncherService;
import com.beeweeb.globallauncher.util.BufferedReader;
import com.beeweeb.globallauncher.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class TaskHeartBeat
implements Runnable {
    private LauncherService service;
    private HttpConnection connection;
    private InputStream input;
    private OutputStream output;
    private InstantLauncherData instantLauncherData;
    private String url;
    int attempt = 1;
    private boolean redirected;

    public TaskHeartBeat(LauncherService launcherService, InstantLauncherData instantLauncherData) {
        this(launcherService, instantLauncherData, null);
    }

    public TaskHeartBeat(LauncherService launcherService, InstantLauncherData instantLauncherData, String string) {
        this.service = launcherService;
        this.instantLauncherData = instantLauncherData;
        this.url = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            Object object;
            if (this.url == null) {
                object = this.instantLauncherData.getConfiguration().getHeartbeatURL();
                if (!((String)object).endsWith("/")) {
                    object = (String)object + "/";
                }
                this.connection = (HttpConnection)Connector.open((String)((String)object + this.instantLauncherData.getConfiguration().getHandsetType() + "/" + Launcher.VERSION + "/" + this.instantLauncherData.getShortcutsListVersion()));
            } else {
                this.connection = (HttpConnection)Connector.open((String)this.url);
            }
            this.connection.setRequestProperty("User-Agent", "bwb/IL/" + this.instantLauncherData.getConfiguration().getHandsetType() + "/" + Launcher.VERSION);
            this.connection.setRequestMethod("POST");
            this.connection.setRequestProperty("Content-Type", "text/xml");
            object = this.instantLauncherData.toPostData().getBytes();
            this.output = this.connection.openOutputStream();
            this.output.write((byte[])object);
            int n = this.connection.getResponseCode();
            if (n == 200) {
                int n2;
                this.input = this.connection.openInputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[4096];
                while ((n2 = this.input.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                this.closeAll();
                if (byteArrayOutputStream.size() == 0) return;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
                String string = new String(byteArrayOutputStream.toByteArray());
                if (string.startsWith("http://")) {
                    string = bufferedReader.readLine();
                    this.service.fireHeartbeatSent(string);
                    return;
                } else {
                    this.service.fireHeartbeatSent();
                }
                return;
            } else if (n == 301 || n == 302 || n == 303 || n == 307) {
                String string = this.connection.getHeaderField("Location");
                if (string == null) throw new Exception("Error in redirect");
                TaskHeartBeat taskHeartBeat = new TaskHeartBeat(this.service, this.instantLauncherData, string);
                this.service.enqueueTask(taskHeartBeat);
                return;
            } else if (n == 404) {
                return;
            } else {
                if (this.retry()) return;
                this.service.fireHeartbeatFailedForServiceError();
            }
            return;
        }
        catch (Exception exception) {
            Log.log(exception);
            if (this.retry()) return;
            this.service.fireHeartbeatFailed(exception);
            return;
        }
        finally {
            this.closeAll();
        }
    }

    private boolean retry() {
        if (this.instantLauncherData.getConfiguration() != null && this.attempt < this.instantLauncherData.getConfiguration().getNumRetries()) {
            TaskHeartBeat taskHeartBeat = new TaskHeartBeat(this.service, this.instantLauncherData);
            taskHeartBeat.attempt = this.attempt + 1;
            this.service.enqueueTaskAfter(taskHeartBeat, this.instantLauncherData.getConfiguration().getRetryInterval() * 1000);
            return true;
        }
        return false;
    }

    private void closeAll() {
        if (this.input != null) {
            try {
                this.input.close();
                this.input = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.output != null) {
            try {
                this.output.close();
                this.output = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Runtime.getRuntime().gc();
    }

    public boolean isRedirected() {
        return this.redirected;
    }

    public void setRedirected(boolean bl) {
        this.redirected = bl;
    }
}

