/*
 * Decompiled with CFR 0.152.
 */
package com.beeweeb.globallauncher;

import com.beeweeb.globallauncher.Launcher;
import com.beeweeb.globallauncher.device.JavaApplicationManager;
import com.beeweeb.globallauncher.device.JavaApplicationManagerFactory;
import com.beeweeb.globallauncher.model.AppMidlet;
import com.beeweeb.globallauncher.model.Configuration;
import com.beeweeb.globallauncher.model.InstantLauncherData;
import com.beeweeb.globallauncher.model.Item;
import com.beeweeb.globallauncher.model.Midlet;
import com.beeweeb.globallauncher.model.Network;
import com.beeweeb.globallauncher.model.Shortcut;
import com.beeweeb.globallauncher.model.Strip;
import com.beeweeb.globallauncher.model.Teaser;
import com.beeweeb.globallauncher.model.Upgrade;
import com.beeweeb.globallauncher.net.LauncherService;
import com.beeweeb.globallauncher.net.LauncherServiceListener;
import com.beeweeb.globallauncher.storage.Storage;
import com.beeweeb.globallauncher.ui.ConfigurationForm;
import com.beeweeb.globallauncher.ui.EscapeScreen;
import com.beeweeb.globallauncher.ui.MainView;
import com.beeweeb.globallauncher.util.Log;
import com.beeweeb.globallauncher.util.LogForm;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class Controller
implements LauncherServiceListener,
CommandListener {
    private static final String KEY_IL_S40SELECTLABEL = "IL-S40SelectLabel";
    private static final String KEY_EXIT_COMMAND_LABEL = "IL-ExitCommandLabel";
    private static final int TIMER_LAST_HEARTBEAT = 0;
    private static final int MAX_SHORTCUTS = 25;
    public static Command COMMAND_BACK;
    public static Command COMMAND_SELECT;
    public static final Command COMMAND_HEARTBEAT;
    public static final Command COMMAND_RESET_TEASER;
    public static final Command COMMAND_RESET_ALL;
    public static final Command COMMAND_DEBUG_CONSOLE;
    public static final Command COMMAND_STATUS;
    public static final Command COMMAND_CONFIGURATION;
    public static final Command COMMAND_ALERT;
    public static final Command COMMAND_LOAD_CURRENT;
    public static final Command COMMAND_OK;
    public static final Command COMMAND_SAVE;
    public static final Command COMMAND_RUN_GC;
    public static final Command COMMAND_DETACH;
    public static final Command COMMAND_ATTACH;
    public static final Command COMMAND_MARK_VERSION;
    public static final Command COMMAND_SHOW_LOADING;
    public static final Command COMMAND_HIDE_LOADING;
    public static String STRING_ALERT_DELETE_SHORTCUT;
    public static String STRING_ALERT_ROAMING;
    public static final int COUNT_LAUNCHER_EXECUTED = 0;
    private Launcher midlet;
    private Display display;
    private Timer timer;
    private LiveEngine liveEngine;
    private long[] timers;
    private static int[] counters;
    private long now;
    private boolean initializing = true;
    private boolean loading;
    private Image stubImage = Image.createImage((int)240, (int)25);
    private Vector updatingEvents = new Vector();
    private Shortcut shortcutToBeInserted;
    private MainView ui;
    private EscapeScreen escapeScreen;
    private List statusList;
    private ConfigurationForm configurationForm;
    private LauncherService service;
    private InstantLauncherData liveData;
    private InstantLauncherData newData;
    private Hashtable imagesInProgress = new Hashtable();
    private int imagesCounter;
    private boolean loadingDataResources;
    private JavaApplicationManager applicationManager;
    private long teaserAppeared;

    public Controller(Launcher launcher) {
        this.midlet = launcher;
        this.display = Display.getDisplay((MIDlet)launcher);
        this.init();
        this.initCommonUI();
        this.initUI();
    }

    private void init() {
        Log.log("init():IN");
        LogForm.setMIDet(this.midlet);
        Log.log("init():1");
        this.checkLauncherVersion();
        Log.log("init():2");
        this.liveData = new InstantLauncherData();
        try {
            Log.log("init():3");
            this.newData = Storage.loadInstantLauncherData();
        }
        catch (Exception exception) {
            Log.log("init():4");
            Storage.clearAll();
            try {
                Log.log("init():5");
                this.newData = Storage.loadInstantLauncherData();
            }
            catch (Exception exception2) {
                Log.log(exception);
            }
        }
        Log.log("init():6");
        this.service = new LauncherService(this);
        Log.log("init():7");
        this.applicationManager = JavaApplicationManagerFactory.getJavaApplicationManager();
        Log.log("init():8");
        this.loadDataResources();
        try {
            Log.log("init():9");
            String string = new String(Storage.loadLocalResource("/delete.txt"));
            if (string != null) {
                STRING_ALERT_DELETE_SHORTCUT = string;
            }
        }
        catch (Exception exception) {
            Log.log(exception);
        }
        Log.log("init():OUT");
    }

    private void initNokiaUI() {
    }

    private void initCommonUI() {
        COMMAND_BACK = this.midlet.getAppProperty(KEY_EXIT_COMMAND_LABEL) != null ? new Command(this.midlet.getAppProperty(KEY_EXIT_COMMAND_LABEL), 2, 2) : new Command("Back", 2, 2);
    }

    private void initUI() {
        this.ui = new MainView(this);
        this.ui.addCommand(COMMAND_BACK);
        this.ui.setCommandListener(this);
    }

    private void initMaintenanceUI() {
        this.escapeScreen = new EscapeScreen();
        this.escapeScreen.addCommand(COMMAND_BACK);
        this.escapeScreen.addCommand(COMMAND_HEARTBEAT);
        this.escapeScreen.addCommand(COMMAND_RESET_TEASER);
        this.escapeScreen.addCommand(COMMAND_RESET_ALL);
        this.escapeScreen.addCommand(COMMAND_DEBUG_CONSOLE);
        this.escapeScreen.addCommand(COMMAND_STATUS);
        this.escapeScreen.addCommand(COMMAND_CONFIGURATION);
        this.escapeScreen.addCommand(COMMAND_MARK_VERSION);
        this.escapeScreen.addCommand(COMMAND_SHOW_LOADING);
        this.escapeScreen.addCommand(COMMAND_HIDE_LOADING);
        this.escapeScreen.setCommandListener(this);
        this.statusList = new List("Status", 3);
        this.statusList.addCommand(COMMAND_RUN_GC);
        this.statusList.addCommand(COMMAND_DETACH);
        this.statusList.addCommand(COMMAND_ATTACH);
        this.statusList.addCommand(COMMAND_BACK);
        this.statusList.setCommandListener((CommandListener)this);
        this.configurationForm = new ConfigurationForm();
        this.configurationForm.addCommand(COMMAND_SAVE);
        this.configurationForm.addCommand(COMMAND_LOAD_CURRENT);
        this.configurationForm.addCommand(COMMAND_BACK);
        this.configurationForm.setCommandListener(this);
    }

    private void disposeUI() {
        if (this.ui != null) {
            this.ui.dispose();
            this.ui = null;
            this.escapeScreen = null;
            this.statusList = null;
            this.configurationForm = null;
            Runtime.getRuntime().gc();
        }
    }

    public void start() {
        this.fireLiveDataChanged();
        this.show();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.ui) {
            if (command == COMMAND_BACK) {
                if (this.ui.getMode() == 0 || this.ui.getMode() == 3) {
                    this.display.setCurrent(null);
                } else if (this.ui.getMode() == 2) {
                    if (this.liveData.getTeaser() != null && this.liveData.getTeaser().getStrip() != null && this.liveData.getTeaser().getStrip().getShortcut() != null) {
                        this.deleteItemImages(this.liveData.getTeaser().getStrip().getShortcut());
                        this.liveData.getTeaser().getStrip().setShortcut(null);
                    }
                    this.ui.setMode(0);
                    this.saveLiveData();
                    this.fireLiveDataChanged();
                }
            } else if (command == COMMAND_SELECT) {
                this.selectApplication(this.ui.getSelectedItem());
            }
        } else if (displayable == this.escapeScreen) {
            if (command == List.SELECT_COMMAND) {
                this.service.getNewConfiguration(EscapeScreen.URL[this.escapeScreen.getSelectedIndex()], this.liveData);
                this.display.setCurrent((Displayable)this.ui);
            } else if (command == COMMAND_RESET_ALL) {
                this.performMasterReset();
            } else if (command == COMMAND_RESET_TEASER) {
                this.resetTeaser();
            } else if (command == COMMAND_HEARTBEAT) {
                this.timers[0] = 0L;
                this.display.setCurrent((Displayable)this.ui);
            } else if (command == COMMAND_STATUS) {
                this.fillStatusList();
                this.display.setCurrent((Displayable)this.statusList);
            } else if (command == COMMAND_ALERT) {
                this.ui.showAlert("Vediamo se funziona quest'alert che contiene una stringa piuttosto lunga di testo, che occupa sicuramente molto piu' di una singola riga ed e' necessario che il testo venga suddiviso in un vettore di array", 0);
                this.display.setCurrent((Displayable)this.ui);
            } else if (command == COMMAND_BACK) {
                this.display.setCurrent((Displayable)this.ui);
            } else if (command == COMMAND_CONFIGURATION) {
                this.display.setCurrent((Displayable)this.configurationForm);
            } else if (command == COMMAND_MARK_VERSION) {
                try {
                    Storage.saveVersion("2.6");
                }
                catch (Exception exception) {}
            } else if (command == COMMAND_SHOW_LOADING) {
                this.ui.setMode(3);
            } else if (command == COMMAND_HIDE_LOADING) {
                this.ui.setMode(0);
            } else if (command == COMMAND_DEBUG_CONSOLE) {
                // empty if block
            }
        } else if (displayable == this.statusList) {
            if (command == COMMAND_BACK) {
                this.display.setCurrent((Displayable)this.escapeScreen);
            } else if (command == COMMAND_RUN_GC) {
                Runtime.getRuntime().gc();
                this.statusList.set(1, "Free: " + Long.toString(Runtime.getRuntime().freeMemory()), null);
            } else if (command == COMMAND_DETACH) {
                this.detachImages();
                this.statusList.set(1, "Free: " + Long.toString(Runtime.getRuntime().freeMemory()), null);
            } else if (command == COMMAND_ATTACH) {
                this.asyncAttachImages();
                this.statusList.set(1, "Free: " + Long.toString(Runtime.getRuntime().freeMemory()), null);
            }
        } else if (displayable == this.configurationForm) {
            if (command == COMMAND_BACK) {
                this.display.setCurrent((Displayable)this.escapeScreen);
            } else if (command == COMMAND_LOAD_CURRENT) {
                this.configurationForm.setHeartbeatURL(this.liveData.getConfiguration().getHeartbeatURL());
                this.configurationForm.setHeartbeatInterval(this.liveData.getConfiguration().getHeartbeatInterval());
            } else if (command == COMMAND_SAVE) {
                this.liveData.getConfiguration().setHeartbeatURL(this.configurationForm.getHeartbeatURL());
                this.liveData.getConfiguration().setHeartbeatInterval(Integer.parseInt(this.configurationForm.getHeartbeatInterval()));
            }
        }
    }

    public void heartbeatSent() {
        this.saveTimers();
        this.clearClickCounts();
    }

    public void heartbeatSent(String string) {
        this.saveTimers();
        this.clearClickCounts();
        this.service.getNewConfiguration(string, this.liveData);
    }

    public void heartbeatFailedForServiceError() {
    }

    public void heartbeatFailed(Exception exception) {
    }

    public void gotNewConfiguration(InstantLauncherData instantLauncherData) {
        this.newData = instantLauncherData;
        this.processNewData();
    }

    public void getNewConfigurationFailedForServiceError() {
    }

    public void getNewConfigurationFailed(Exception exception) {
    }

    public void clockChanged() {
    }

    private void processNewData() {
        if (this.newData.getUpgrade() != null) {
            this.verifyUpgrade(this.newData.getUpgrade());
        } else {
            if (this.newData.getConfiguration() != null && this.newData.getConfiguration().getDisable() != null && this.newData.getConfiguration().getDisable().booleanValue()) {
                this.newData.setTeaser(null);
                this.removeCurrentTeaser();
            } else if (this.newData.getTeaser() == null || this.getLiveData().getTeaser() == null || this.getLiveData().getTeaser().getID().equalsIgnoreCase(this.newData.getTeaser().getID())) {
                // empty if block
            }
            if (this.newData.getShortcutCount() != 0) {
                Storage.clearImages();
            }
            this.loadDataResources();
        }
    }

    public InstantLauncherData getLiveData() {
        return this.liveData;
    }

    public void mainViewShowNotify() {
        this.checkDeletableShortcuts();
        this.checkInstalledApplications();
    }

    private void checkTeaserAppeared() {
        if (this.liveData.getTeaser() != null) {
            Shortcut shortcut;
            Teaser teaser = this.liveData.getTeaser();
            if (teaser.getLOCAL_teaser_appeared() == 0L) {
                teaser.setLOCAL_teaser_appeared(System.currentTimeMillis());
            }
            if (teaser.getStrip().getHrefType() == 1 && (shortcut = teaser.getStrip().getShortcut()).getAlwaysDisplay() && this.applicationManager.isInstalled((Midlet)shortcut.getApplication())) {
                this.liveData.insertShortcut(shortcut);
                shortcut.setFromTeaser(true);
                this.liveData.setTeaser(null);
            }
        }
    }

    private void checkInstalledApplications() {
        Shortcut shortcut;
        boolean bl = false;
        if (this.liveData.getShortcuts() != null && this.liveData.getShortcutCount() > 0) {
            for (int i = 0; i < this.liveData.getShortcutCount(); ++i) {
                shortcut = this.liveData.getShortcut(i);
                if (shortcut.getApplication() == null) continue;
                Midlet midlet = (Midlet)shortcut.getApplication();
                if (this.applicationManager.isInstalled(midlet.getVendor(), midlet.getName(), midlet.getRealName())) {
                    if (midlet.isInstalled()) {
                        midlet.setPreviouslyInstalled(true);
                    } else {
                        midlet.setInstalled(true);
                    }
                    String string = this.applicationManager.getVersion(midlet);
                    if (string == null) continue;
                    midlet.setVersion(string);
                    continue;
                }
                if (midlet.isInstalled()) {
                    midlet.setPreviouslyInstalled(true);
                }
                midlet.setInstalled(false);
            }
        }
        if (this.liveData.getTeaser() != null && this.liveData.getTeaser().getStrip() != null && this.liveData.getTeaser().getStrip().getHrefType() == 1 && this.liveData.getTeaser().getStrip().getShortcut() != null && (shortcut = this.liveData.getTeaser().getStrip().getShortcut()).getApplication() != null && this.applicationManager.isInstalled((Midlet)shortcut.getApplication())) {
            if (!shortcut.getAlwaysDisplay()) {
                int n = this.liveData.containsApplicationShortcut(shortcut);
                if (n == -1) {
                    if (this.liveData.getShortcutCount() + this.liveData.getNotDeletableCount() == 25) {
                        this.shortcutToBeInserted = shortcut;
                        this.askForItemDeletion();
                    } else {
                        this.insertShortcutTeaser();
                    }
                } else {
                    this.liveData.setShortcut(shortcut, n);
                }
                bl = true;
            }
            if (this.liveData.getTeaser().getLOCAL_click_count() != 0) {
                this.liveData.setTeaser(null);
                bl = true;
            } else if (!shortcut.getApplication().isPreviouslyInstalled()) {
                this.liveData.setTeaser(null);
                bl = true;
            }
        }
        if (bl) {
            this.ui.update();
        }
        try {
            Storage.saveInstantLauncherData(this.liveData);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void loadDataResources() {
        int n;
        this.loadingDataResources = true;
        if (this.newData.getTeaser() != null && this.newData.getTeaser().getStrip() != null) {
            this.loadImages(this.newData.getTeaser().getStrip());
            if (this.newData.getTeaser().getStrip().getShortcut() != null) {
                this.loadImages(this.newData.getTeaser().getStrip().getShortcut());
            }
        }
        for (n = 0; n < this.newData.getShortcutCount(); ++n) {
            this.loadImages(this.newData.getShortcut(n));
        }
        for (n = 0; n < this.newData.getNotDeletableCount(); ++n) {
            this.loadImages(this.newData.getNotDeletable(n));
        }
        this.loadingDataResources = false;
        if (this.imagesCounter == 0) {
            this.mergeData();
        }
    }

    private void loadDataResourcesForNokia() {
        int n;
        this.loadingDataResources = true;
        if (this.newData.getTeaser() != null && this.newData.getTeaser().getStrip() != null) {
            this.loadImagesForNokia(this.newData.getTeaser().getStrip());
            if (this.newData.getTeaser().getStrip().getShortcut() != null) {
                this.loadImagesForNokia(this.newData.getTeaser().getStrip().getShortcut());
            }
        }
        for (n = 0; n < this.newData.getShortcutCount(); ++n) {
            this.loadImagesForNokia(this.newData.getShortcut(n));
        }
        for (n = 0; n < this.newData.getNotDeletableCount(); ++n) {
            this.loadImagesForNokia(this.newData.getNotDeletable(n));
        }
        this.loadingDataResources = false;
        if (this.imagesCounter == 0) {
            this.mergeData();
        }
    }

    private void loadImages(Item item) {
        byte[] byArray;
        if (item.getImgSrc() != null && item.getImg() == null) {
            if (item.getImgSrc().startsWith("http://") || item.getImgSrc().startsWith("jar://")) {
                byArray = null;
                try {
                    Log.log("loadImages() imgSrc");
                    byArray = Storage.loadImage(item.getImgSrc());
                }
                catch (IOException iOException) {
                }
                catch (RecordStoreException recordStoreException) {
                    // empty catch block
                }
                if (byArray == null) {
                    this.service.loadImage(this.liveData, item, item.getImgSrc());
                    this.incrementImageCounter();
                } else {
                    item.setImg(Image.createImage((byte[])byArray, (int)0, (int)byArray.length));
                }
            } else {
                try {
                    byArray = Storage.copyFromJARToRMS(item.getImgSrc(), "jar://" + item.getImgSrc());
                    item.setImgSrc("jar://" + item.getImgSrc());
                    item.setImg(Image.createImage((byte[])byArray, (int)0, (int)byArray.length));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (item.getImgSrcDwl() != null && item.getImgDwl() == null) {
            if (item.getImgSrcDwl().startsWith("http://") || item.getImgSrcDwl().startsWith("jar://")) {
                byArray = null;
                try {
                    Log.log("loadImages() imgSrcDwl");
                    byArray = Storage.loadImage(item.getImgSrcDwl());
                }
                catch (IOException iOException) {
                }
                catch (RecordStoreException recordStoreException) {
                    // empty catch block
                }
                if (byArray == null) {
                    this.service.loadImage(this.liveData, item, item.getImgSrcDwl());
                    this.incrementImageCounter();
                } else {
                    item.setImgDwl(Image.createImage((byte[])byArray, (int)0, (int)byArray.length));
                }
            } else {
                try {
                    byArray = Storage.copyFromJARToRMS(item.getImgSrcDwl(), "jar://" + item.getImgSrcDwl());
                    item.setImgSrcDwl("jar://" + item.getImgSrcDwl());
                    item.setImgDwl(Image.createImage((byte[])byArray, (int)0, (int)byArray.length));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void loadImagesForNokia(Item item) {
        block19: {
            byte[] byArray;
            block18: {
                if (item.getImgSrc() != null && item.getImg() == null) {
                    if (item.getImgSrc().startsWith("http://") || item.getImgSrc().startsWith("jar://")) {
                        try {
                            if (!Storage.containsImage(item.getImgSrc()) && !item.getImgSrc().startsWith("jar://")) {
                                this.service.loadImage(this.liveData, item, item.getImgSrc());
                                this.incrementImageCounter();
                                break block18;
                            }
                            item.setImg(this.stubImage);
                        }
                        catch (RecordStoreException recordStoreException) {
                            recordStoreException.printStackTrace();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    } else {
                        try {
                            byArray = Storage.copyFromJARToRMS(item.getImgSrc(), "jar://" + item.getImgSrc());
                            item.setImgSrc("jar://" + item.getImgSrc());
                            item.setImg(this.stubImage);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if (item.getImgSrcDwl() != null && item.getImgDwl() == null) {
                if (item.getImgSrcDwl().startsWith("http://") || item.getImgSrcDwl().startsWith("jar://")) {
                    try {
                        if (!Storage.containsImage(item.getImgSrcDwl()) && !item.getImgSrcDwl().startsWith("jar://")) {
                            this.service.loadImage(this.liveData, item, item.getImgSrcDwl());
                            this.incrementImageCounter();
                            break block19;
                        }
                        item.setImgDwl(this.stubImage);
                    }
                    catch (IOException iOException) {
                        Log.log(iOException);
                    }
                    catch (RecordStoreException recordStoreException) {
                        Log.log(recordStoreException);
                    }
                } else {
                    try {
                        byArray = Storage.copyFromJARToRMS(item.getImgSrcDwl(), "jar://" + item.getImgSrcDwl());
                        item.setImgSrcDwl("jar://" + item.getImgSrcDwl());
                        item.setImgDwl(this.stubImage);
                    }
                    catch (Exception exception) {
                        Log.log(exception);
                    }
                }
            }
        }
    }

    private synchronized void incrementImageCounter() {
        ++this.imagesCounter;
    }

    private synchronized void decrementImageCounter() {
        --this.imagesCounter;
    }

    public void imageDownloaded(Item item, String string, byte[] byArray) {
        if (item.getImgSrc() != null && item.getImgSrc().equals(string)) {
            item.setImg(Image.createImage((byte[])byArray, (int)0, (int)byArray.length));
        } else if (item.getImgSrcDwl() != null && item.getImgSrcDwl().equals(string)) {
            item.setImgDwl(Image.createImage((byte[])byArray, (int)0, (int)byArray.length));
        }
        try {
            Storage.saveImage(string, byArray);
        }
        catch (RecordStoreException recordStoreException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.decrementImageCounter();
        if (this.imagesCounter == 0 && !this.loadingDataResources) {
            this.mergeData();
        }
    }

    public void downloadImageFailed(Item item, String string, Exception exception) {
        this.decrementImageCounter();
    }

    public void selectApplication(int n) {
        this.selectApplication(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectApplication(int n, boolean bl) {
        block44: {
            Shortcut shortcut;
            if (this.ui.getMode() == 0) {
                if (n == -1 && this.liveData.getTeaser() != null) {
                    this.liveData.getTeaser().updateLOCAL_click_count();
                    Strip strip = this.liveData.getTeaser().getStrip();
                    Shortcut shortcut2 = strip.getShortcut();
                    if (strip.getHrefType() == 0 || strip.getHrefType() == 2) {
                        try {
                            this.midlet.platformRequest(this.liveData.getTeaser().getStrip().getHref());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (shortcut2 != null && !shortcut2.getAlwaysDisplay()) {
                            int n2 = this.liveData.containsWebShortcut(shortcut2);
                            if (n2 == -1) {
                                if (this.liveData.getShortcutCount() + this.liveData.getNotDeletableCount() == 25) {
                                    this.shortcutToBeInserted = shortcut2;
                                    this.askForItemDeletion();
                                } else {
                                    this.insertShortcutTeaser();
                                }
                            } else {
                                this.liveData.setShortcut(shortcut2, n2);
                            }
                            this.fireLiveDataChanged();
                        }
                    } else if (strip.getHrefType() == 1) {
                        try {
                            this.midlet.platformRequest(this.liveData.getTeaser().getStrip().getHref());
                        }
                        catch (Exception exception) {}
                    }
                } else if (n >= 0) {
                    Shortcut shortcut3 = this.liveData.getShortcut(n);
                    if (shortcut3.getWebURL() != null) {
                        if (bl && !this.isInRoamingWhitelist() && !shortcut3.isRoamingNotificationDisable() && shortcut3.getRoamingText() != null && shortcut3.getRoamingText().length() > 0) {
                            this.ui.showAlert(shortcut3.getRoamingText(), 0);
                        } else {
                            try {
                                shortcut3.updateLOCAL_click_count();
                                this.midlet.platformRequest(shortcut3.getWebURL());
                            }
                            catch (ConnectionNotFoundException connectionNotFoundException) {}
                        }
                    } else {
                        Midlet midlet = (Midlet)shortcut3.getApplication();
                        if (this.applicationManager.isInstalled(midlet.getVendor(), midlet.getName(), midlet.getRealName())) {
                            if (midlet.getLOCAL_updateURL() != null) {
                                if (bl && !this.isInRoamingWhitelist() && !shortcut3.isRoamingNotificationDisable() && shortcut3.getRoamingText() != null && shortcut3.getRoamingText().length() > 0) {
                                    this.ui.showAlert(shortcut3.getRoamingText(), 0);
                                } else {
                                    try {
                                        shortcut3.updateLOCAL_click_count();
                                        this.midlet.platformRequest(midlet.getLOCAL_updateURL());
                                    }
                                    catch (ConnectionNotFoundException connectionNotFoundException) {
                                    }
                                    finally {
                                        midlet.setLOCAL_updateURL(null);
                                    }
                                }
                            } else {
                                try {
                                    shortcut3.updateLOCAL_click_count();
                                    this.applicationManager.run(midlet.getVendor(), midlet.getName(), midlet.getRealName());
                                }
                                catch (Exception exception) {
                                    if (midlet.getSubstituteURL() == null) break block44;
                                    if (bl && !this.isInRoamingWhitelist() && !shortcut3.isRoamingNotificationDisable() && shortcut3.getRoamingText() != null && shortcut3.getRoamingText().length() > 0) {
                                        this.ui.showAlert(shortcut3.getRoamingText(), 0);
                                        break block44;
                                    }
                                    try {
                                        shortcut3.updateLOCAL_click_count();
                                        this.midlet.platformRequest(midlet.getSubstituteURL());
                                    }
                                    catch (Exception exception2) {}
                                }
                            }
                        } else if (bl && !shortcut3.isRoamingNotificationDisable() && shortcut3.getRoamingText() != null) {
                            this.ui.showAlert(shortcut3.getRoamingText(), 0);
                        } else {
                            try {
                                shortcut3.updateLOCAL_click_count();
                                this.midlet.platformRequest(midlet.getSubstituteURL());
                            }
                            catch (ConnectionNotFoundException connectionNotFoundException) {}
                        }
                    }
                }
            } else if (this.ui.getMode() == 2 && n >= 0 && !(shortcut = this.liveData.getShortcut(n)).isLOCAL_flexed()) {
                this.ui.setMode(0);
                this.liveData.deleteShortcut(n);
                this.insertShortcutTeaser();
                this.fireLiveDataChanged();
            }
        }
        this.saveLiveData();
    }

    private void fireLiveDataChanged() {
        if (this.ui != null) {
            this.ui.update();
            if (this.ui.isShown()) {
                this.ui.repaint();
            }
        }
    }

    public void showEscapeScreen() {
        if (this.escapeScreen == null) {
            this.initMaintenanceUI();
        }
        this.display.setCurrent((Displayable)this.escapeScreen);
    }

    public void showResetAlert() {
    }

    public void clearStorage() {
        try {
            Storage.clearAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void mergeData() {
        boolean bl = false;
        if (this.newData != null) {
            int n;
            this.validateNewData();
            if (this.newData.getShortcutCount() != 0) {
                this.liveData.clearShortcuts();
                this.liveData.setShortcuts(this.newData.getShortcuts());
                this.liveData.setShortcutsListVersion(this.newData.getShortcutsListVersion());
                bl = true;
            }
            if (this.newData.getAppUpgradeCount() != 0) {
                for (n = 0; n < this.newData.getAppUpgradeCount(); ++n) {
                    AppMidlet appMidlet = this.newData.getAppMidlet(n);
                    for (int i = 0; i < this.liveData.getShortcutCount(); ++i) {
                        Midlet midlet;
                        if (this.liveData.getShortcut(i).getApplication() == null || !(midlet = (Midlet)this.liveData.getShortcut(i).getApplication()).equals(appMidlet)) continue;
                        midlet.setLOCAL_updateURL(appMidlet.getUpdateURL());
                    }
                }
            }
            if (this.newData.getTeaser() != null && this.newData.getTeaser().getPosn() == 0 && this.newData.getTeaser().getTTS() == 0 && (this.getLiveData().getTeaser() == null || this.getLiveData().getTeaser().getID().equalsIgnoreCase(this.newData.getTeaser().getID()))) {
                if (this.newData.getTeaser().getTTL() > 0) {
                    this.getLiveData().setTeaser(this.newData.getTeaser());
                    if (this.liveData.getTeaser().getStrip() != null && this.liveData.getTeaser().getStrip().getShortcut() != null && this.liveData.getTeaser().getStrip().getShortcut().getApplication() != null && this.liveData.getTeaser().getStrip().getHrefType() == 1) {
                        Shortcut shortcut = this.liveData.getTeaser().getStrip().getShortcut();
                        if (this.applicationManager.isInstalled((Midlet)shortcut.getApplication())) {
                            shortcut.getApplication().setPreviouslyInstalled(true);
                            shortcut.getApplication().setInstalled(true);
                        }
                        int n2 = this.liveData.containsApplicationShortcut(shortcut);
                        if (this.liveData.getTeaser().getStrip().getShortcut().getAlwaysDisplay() || shortcut.getApplication().isInstalled()) {
                            if (n2 != -1) {
                                this.liveData.setShortcut(shortcut, n2);
                            } else if (this.liveData.getShortcutCount() + this.liveData.getNotDeletableCount() == 25) {
                                this.shortcutToBeInserted = shortcut;
                                this.askForItemDeletion();
                            } else {
                                this.insertShortcutTeaser();
                            }
                        }
                    }
                    if (this.ui != null && this.ui.isShown() && this.getLiveData().getTeaser().getLOCAL_teaser_appeared() == 0L) {
                        this.getLiveData().getTeaser().setLOCAL_teaser_appeared(System.currentTimeMillis());
                    }
                    bl = true;
                } else if (this.liveData.getTeaser().getStrip() != null && this.liveData.getTeaser().getStrip().getShortcut() != null && (this.liveData.getTeaser().getStrip().getHrefType() == 0 || this.liveData.getTeaser().getStrip().getHrefType() == 2)) {
                    Shortcut shortcut = this.liveData.getTeaser().getStrip().getShortcut();
                    int n3 = this.liveData.containsWebShortcut(shortcut);
                    if (n3 != -1) {
                        this.liveData.setShortcut(shortcut, n3);
                    } else if (this.liveData.getTeaser().getStrip().getShortcut().getAlwaysDisplay()) {
                        if (this.liveData.getShortcutCount() + this.liveData.getNotDeletableCount() == 25) {
                            this.shortcutToBeInserted = shortcut;
                            this.askForItemDeletion();
                        } else {
                            this.insertShortcutTeaser();
                        }
                    }
                } else {
                    this.removeCurrentTeaser();
                }
            }
            if (this.newData.getConfiguration() != null) {
                n = 0;
                if (this.liveData.getConfiguration() != null) {
                    n = this.liveData.getConfiguration().getHeartbeatInterval();
                }
                this.liveData.setConfiguration(this.newData.getConfiguration());
                if (n > 0) {
                    this.liveData.getConfiguration().setLOCAL_previousHBinterval(n);
                }
                if (this.liveData.getConfiguration().getDisable() != null && this.liveData.getConfiguration().getDisable().booleanValue() && this.liveData.getConfiguration().getDisableURL() != null) {
                    this.service.disable(this.liveData);
                }
            }
            this.saveLiveData();
            this.newData = null;
            this.loading = false;
            if (bl) {
                this.fireLiveDataChanged();
            }
        }
        if (this.initializing) {
            this.completeInit();
            this.fireLiveDataChanged();
        }
    }

    private void sendHeartbeat() {
        this.service.sendHeartbeat(this.liveData);
    }

    private boolean isInRoaming() {
        if (this.liveData.getConfiguration() != null) {
            return this.liveData.getConfiguration().getHomeNetworkMCC() != this.applicationManager.getCurrentMCC() || this.liveData.getConfiguration().getHomeNetworkMNC() != this.applicationManager.getCurrentMNC();
        }
        return false;
    }

    private boolean isHeartbeatEnabledOnCurrentNetwork() {
        if (this.isInRoaming()) {
            int n = this.applicationManager.getCurrentMCC();
            int n2 = this.applicationManager.getCurrentMNC();
            if (this.liveData.getConfiguration().getRoaming3GHeartbeat() != null && this.liveData.getConfiguration().getRoaming3GHeartbeat().booleanValue() && this.applicationManager.getBearer() == 3) {
                return true;
            }
            if (this.liveData.getConfiguration().getRoamingGPRSHeartbeat() != null && this.liveData.getConfiguration().getRoamingGPRSHeartbeat().booleanValue() && this.applicationManager.getBearer() == 2) {
                return true;
            }
            Vector vector = this.liveData.getConfiguration().getNetworks();
            Network network = null;
            if (vector.size() != 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    network = (Network)vector.elementAt(i);
                    if (network.getMcc() != n || network.getMnc() != n2) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean isTeaserEnabledOnCurrentNetwork() {
        return true;
    }

    public boolean isTeaserPresent() {
        return this.liveData.getTeaser() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyUpgrade(Upgrade upgrade) {
        try {
            this.midlet.platformRequest(upgrade.getClientURL());
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
        }
        finally {
            this.midlet.notifyDestroyed();
        }
    }

    private void loadTimersAndCounters() {
        try {
            this.timers = Storage.loadTimers();
            if (this.timers == null) {
                this.timers = new long[1];
                this.timers[0] = 0L;
            }
        }
        catch (IOException iOException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        try {
            counters = Storage.loadCounters();
            if (counters != null) {
                // empty if block
            }
            if (counters == null) {
                counters = new int[1];
                Controller.counters[0] = 0;
            }
            counters[0] = counters[0] + 1;
            Storage.saveCounters(counters);
        }
        catch (IOException iOException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    private void saveTimers() {
        try {
            Storage.saveTimers(this.timers);
        }
        catch (IOException iOException) {
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.saveTimers();
        this.service.close();
        this.timer.cancel();
        this.midlet.notifyDestroyed();
    }

    private boolean exists(Shortcut shortcut) {
        if (this.liveData.getShortcutCount() != 0) {
            for (int i = 0; i < this.liveData.getShortcutCount(); ++i) {
                if (!shortcut.equals(this.liveData.getShortcut(i))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInRoamingWhitelist() {
        int n = this.applicationManager.getCurrentMCC();
        int n2 = this.applicationManager.getCurrentMNC();
        if (this.liveData.getConfiguration() != null) {
            Configuration configuration = this.liveData.getConfiguration();
            if (configuration.getHomeNetworkMCC() == n && configuration.getHomeNetworkMNC() == n2) {
                return true;
            }
            for (int i = 0; i < configuration.getNetworks().size(); ++i) {
                if (configuration.getNetwork(i).getMcc() != n || configuration.getNetwork(i).getMnc() != n2) continue;
                return true;
            }
        }
        return false;
    }

    private void validateNewData() {
        if (this.newData.getTeaser() != null) {
            if (!this.newData.getTeaser().getStrip().isValid()) {
                this.newData.setTeaser(null);
            } else if (this.newData.getTeaser().getStrip().getShortcut() != null && !this.newData.getTeaser().getStrip().getShortcut().isValid()) {
                this.newData.getTeaser().getStrip().setShortcut(null);
            }
        }
        if (this.newData.getShortcutCount() > 0) {
            for (int i = 0; i < this.newData.getShortcutCount(); ++i) {
                if (this.newData.getShortcut(i).isValid()) continue;
                this.newData.removeShortcut(i);
                --i;
            }
        }
    }

    public static int[] getCounters() {
        return counters;
    }

    private void completeInit() {
        this.loadTimersAndCounters();
        this.timer = new Timer();
        this.liveEngine = new LiveEngine();
        this.timer.scheduleAtFixedRate((TimerTask)this.liveEngine, 1000L, 30000L);
        this.initializing = false;
    }

    public void show() {
        this.display.setCurrent((Displayable)this.ui);
    }

    public void hide() {
        this.applicationManager.requestBackground(this.display);
    }

    private void fillStatusList() {
        this.statusList.deleteAll();
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        long l3 = l - l2;
        this.statusList.append("Memory: " + l, null);
        this.statusList.append("Free: " + l2, null);
        this.statusList.append("Used: " + l3, null);
        this.statusList.append("---", null);
        this.statusList.append("HB interval: " + Integer.toString(this.liveData.getConfiguration().getHeartbeatInterval()), null);
        this.statusList.append("HB retries: " + Integer.toString(this.liveData.getConfiguration().getNumRetries()), null);
        this.statusList.append("HB ret-inter: " + Integer.toString(this.liveData.getConfiguration().getRetryInterval()), null);
        this.statusList.append("---", null);
        this.statusList.append("Home MNC: " + Integer.toString(this.liveData.getConfiguration().getHomeNetworkMNC()), null);
        this.statusList.append("Home MCC: " + Integer.toString(this.liveData.getConfiguration().getHomeNetworkMCC()), null);
        this.statusList.append("MNC: " + Integer.toString(this.applicationManager.getCurrentMNC()), null);
        this.statusList.append("MCC: " + Integer.toString(this.applicationManager.getCurrentMCC()), null);
        this.statusList.append("Roaming: " + this.isInRoaming(), null);
        this.statusList.append("HeartBeat: " + this.isHeartbeatEnabledOnCurrentNetwork(), null);
        this.statusList.append("In whitelist: " + this.isInRoamingWhitelist(), null);
        this.statusList.append("---", null);
        this.statusList.append("Teaser: " + (this.liveData.getTeaser() != null), null);
        this.statusList.append("Shortcuts: " + this.liveData.getShortcutCount(), null);
    }

    private void resetTeaser() {
        this.liveData.setTeaser(null);
        this.fireLiveDataChanged();
    }

    private void removeCurrentTeaser() {
        if (this.liveData.getTeaser() != null) {
            this.liveData.setTeaser(null);
            this.checkDeletableShortcuts();
            this.saveLiveData();
            this.fireLiveDataChanged();
        }
    }

    private void deleteItemImages(Item item) {
        try {
            if (item.getImgSrc() != null && item.getImgSrc().startsWith("http://")) {
                this.service.deleteImage(item.getImgSrc());
            }
        }
        catch (Exception exception) {
            Log.log(exception);
        }
        try {
            if (item.getImgSrcDwl() != null && item.getImgSrcDwl().startsWith("http://")) {
                this.service.deleteImage(item.getImgSrcDwl());
            }
        }
        catch (Exception exception) {
            Log.log(exception);
        }
    }

    private void saveLiveData() {
        try {
            Storage.saveInstantLauncherData(this.liveData);
            this.cleanImages();
        }
        catch (RecordStoreException recordStoreException) {
            Log.log(recordStoreException);
        }
    }

    private void checkDeletableShortcuts() {
        Shortcut shortcut;
        int n;
        boolean bl = false;
        if (this.liveData.getShortcutCount() > 0) {
            for (n = 0; n < this.liveData.getShortcuts().size(); ++n) {
                shortcut = this.liveData.getShortcut(n);
                if (!shortcut.isFromTeaser() || shortcut.getApplication() == null) continue;
                if (shortcut.getAlwaysDisplay()) {
                    if (!shortcut.isDeletable() || this.applicationManager.isInstalled((Midlet)shortcut.getApplication()) || this.belongsToCurrentTeaser(shortcut)) continue;
                    this.liveData.removeShortcut(n);
                    --n;
                    bl = true;
                    continue;
                }
                if (shortcut.isDeletable()) {
                    if (shortcut.getApplication().getSubstituteURL() == null) {
                        if (this.applicationManager.isInstalled((Midlet)shortcut.getApplication()) || this.belongsToCurrentTeaser(shortcut)) continue;
                        this.liveData.removeShortcut(n);
                        --n;
                        bl = true;
                        continue;
                    }
                    if (shortcut.getApplication().isPreviouslyInstalled() || this.applicationManager.isInstalled((Midlet)shortcut.getApplication()) || this.belongsToCurrentTeaser(shortcut)) continue;
                    this.liveData.removeShortcut(n);
                    --n;
                    bl = true;
                    continue;
                }
                if (this.applicationManager.isInstalled((Midlet)shortcut.getApplication())) continue;
                this.liveData.addNotDeletable(shortcut);
                this.liveData.removeShortcut(n);
                --n;
                bl = true;
            }
        }
        if (this.liveData.getNotDeletableCount() > 0) {
            shortcut = null;
            for (n = 0; n < this.liveData.getNotDeletableCount(); ++n) {
                shortcut = this.liveData.getNotDeletable(n);
                if (shortcut.getApplication() == null || !this.applicationManager.isInstalled((Midlet)shortcut.getApplication())) continue;
                this.liveData.insertShortcut(shortcut);
                this.liveData.removeNotDeletable(n);
                --n;
                bl = true;
            }
        }
        if (bl) {
            this.saveLiveData();
            this.fireLiveDataChanged();
        }
    }

    private boolean belongsToCurrentTeaser(Shortcut shortcut) {
        Teaser teaser;
        if (this.liveData.getTeaser() != null && (teaser = this.liveData.getTeaser()).getStrip() != null && teaser.getStrip().getShortcut() != null) {
            if (teaser.getStrip().getShortcut() == shortcut) {
                return true;
            }
            if (teaser.getStrip().getShortcut().getApplication() != null && shortcut.getApplication() != null && ((Midlet)shortcut.getApplication()).getSubstituteURL().equals(((Midlet)teaser.getStrip().getShortcut().getApplication()).getSubstituteURL())) {
                return true;
            }
        }
        return false;
    }

    public void fireOnAlert() {
        this.ui.closeAlert();
        if (this.ui.getAlertType() == 0) {
            this.selectApplication(this.ui.getSelectedItem(), false);
        } else if (this.ui.getAlertType() == 1) {
            this.ui.setMode(2);
        }
    }

    private void clearClickCounts() {
        if (this.liveData.getTeaser() != null) {
            this.liveData.getTeaser().setLOCAL_click_count(0);
        }
        if (this.liveData.getShortcutCount() != 0) {
            for (int i = 0; i < this.liveData.getShortcutCount(); ++i) {
                this.liveData.getShortcut(i).setLOCAL_click_count(0);
            }
        }
    }

    public void disabled() {
    }

    public void disableFailed(Exception exception) {
    }

    private void askForItemDeletion() {
        this.ui.showAlert(STRING_ALERT_DELETE_SHORTCUT, 1);
    }

    private void insertShortcutTeaser() {
        if (this.shortcutToBeInserted != null) {
            this.shortcutToBeInserted.setFromTeaser(true);
            this.liveData.insertShortcut(this.shortcutToBeInserted);
            this.shortcutToBeInserted = null;
        } else {
            this.liveData.getTeaser().getStrip().getShortcut().setFromTeaser(true);
            this.liveData.insertShortcut(this.liveData.getTeaser().getStrip().getShortcut());
        }
    }

    public void performMasterReset() {
        this.clearStorage();
        try {
            this.service.close();
            this.timer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.midlet.notifyDestroyed();
    }

    private void cleanImages() {
        String[] stringArray = Storage.listImages();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.liveData.isImageInUse(stringArray[i])) continue;
                try {
                    Storage.deleteImage(stringArray[i]);
                    continue;
                }
                catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                    recordStoreNotOpenException.printStackTrace();
                    continue;
                }
                catch (RecordStoreException recordStoreException) {
                    recordStoreException.printStackTrace();
                }
            }
        }
        Runtime.getRuntime().gc();
    }

    private void checkLauncherVersion() {
        String string = Storage.loadVersion();
        if (string != null) {
            try {
                int n = Integer.parseInt(string.substring(0, string.indexOf(".")));
                int n2 = Integer.parseInt(string.substring(string.indexOf(".") + 1));
                int n3 = Integer.parseInt(Launcher.VERSION.substring(0, Launcher.VERSION.indexOf(".")));
                int n4 = Integer.parseInt(Launcher.VERSION.substring(Launcher.VERSION.indexOf(".") + 1));
                if (n < n3 || n == n3 && n2 < n4) {
                    this.clearStorage();
                }
            }
            catch (Exception exception) {}
        } else {
            this.clearStorage();
        }
        try {
            Storage.saveVersion(Launcher.VERSION);
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void detachImages() {
        if (this.liveData != null) {
            try {
                Object object;
                if (this.liveData.getShortcutCount() > 0) {
                    for (int i = 0; i < this.liveData.getShortcutCount(); ++i) {
                        object = this.liveData.getShortcut(i);
                        ((Item)object).setImg(this.stubImage);
                        ((Item)object).setImgDwl(this.stubImage);
                    }
                }
                if (this.liveData.getTeaser() != null && ((Teaser)(object = this.liveData.getTeaser())).getStrip() != null) {
                    ((Teaser)object).getStrip().setImg(this.stubImage);
                    ((Teaser)object).getStrip().setImgDwl(this.stubImage);
                    if (((Teaser)object).getStrip().getShortcut() != null) {
                        ((Teaser)object).getStrip().getShortcut().setImg(this.stubImage);
                        ((Teaser)object).getStrip().getShortcut().setImgDwl(this.stubImage);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Runtime.getRuntime().gc();
            this.liveData.setAttached(false);
        }
    }

    private void asyncAttachImages() {
        Thread thread = new Thread(){

            public void run() {
                Controller.this.attachImages();
                Controller.this.ui.setMode(0);
                Controller.this.ui.update();
            }
        };
        thread.start();
    }

    private void attachImages() {
        if (this.liveData != null) {
            try {
                Item item;
                if (this.liveData.getShortcutCount() > 0) {
                    for (int i = 0; i < this.liveData.getShortcutCount(); ++i) {
                        item = this.liveData.getShortcut(i);
                        if (item.getImgSrc() == null || item.getImg() != null && item.getImg() != this.stubImage) continue;
                        item.setImg(Storage.loadAndCreateImage(item.getImgSrc()));
                        if (item.getImgSrcDwl() != null && (item.getImgDwl() == null || item.getImgDwl() == this.stubImage)) {
                            item.setImgDwl(Storage.loadAndCreateImage(item.getImgSrcDwl()));
                            continue;
                        }
                        item.setImgDwl(null);
                    }
                }
                if (this.liveData.getTeaser() != null && (item = this.liveData.getTeaser().getStrip()) != null && item.getImgSrc() != null) {
                    item.setImg(Storage.loadAndCreateImage(item.getImgSrc()));
                    if (item.getImgSrcDwl() != null && (item.getImgDwl() == null || item.getImgDwl() == this.stubImage)) {
                        item.setImgDwl(Storage.loadAndCreateImage(item.getImgSrcDwl()));
                    } else {
                        item.setImgDwl(null);
                    }
                    if (((Strip)item).getShortcut() != null && ((Strip)item).getShortcut().getImgSrc() != null) {
                        ((Strip)item).getShortcut().setImg(Storage.loadAndCreateImage(((Strip)item).getShortcut().getImgSrc()));
                        if (((Strip)item).getShortcut().getImgSrcDwl() != null) {
                            ((Strip)item).getShortcut().setImgDwl(Storage.loadAndCreateImage(((Strip)item).getShortcut().getImgSrcDwl()));
                        } else {
                            ((Strip)item).getShortcut().setImgDwl(null);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.liveData.setAttached(true);
            Runtime.getRuntime().gc();
        }
    }

    private boolean useSecondaryStorage() {
        return false;
    }

    static {
        COMMAND_HEARTBEAT = new Command("Heartbeat", 1, 1);
        COMMAND_RESET_TEASER = new Command("Reset Teaser", 1, 1);
        COMMAND_RESET_ALL = new Command("Reset ALL", 1, 2);
        COMMAND_DEBUG_CONSOLE = new Command("Debug console", 1, 2);
        COMMAND_STATUS = new Command("Status", 1, 2);
        COMMAND_CONFIGURATION = new Command("Configuration", 1, 2);
        COMMAND_ALERT = new Command("Show alert", 1, 2);
        COMMAND_LOAD_CURRENT = new Command("Load current", 1, 1);
        COMMAND_OK = new Command("OK", 4, 1);
        COMMAND_SAVE = new Command("Save", 1, 1);
        COMMAND_RUN_GC = new Command("Run GC", 1, 1);
        COMMAND_DETACH = new Command("Detach", 1, 2);
        COMMAND_ATTACH = new Command("Attach", 1, 2);
        COMMAND_MARK_VERSION = new Command("Mark Version 2.6", 1, 2);
        COMMAND_SHOW_LOADING = new Command("Show Loading", 1, 2);
        COMMAND_HIDE_LOADING = new Command("Hide Loading", 1, 2);
        STRING_ALERT_DELETE_SHORTCUT = "N/A";
        STRING_ALERT_ROAMING = "N/A";
    }

    private class LiveEngine
    extends TimerTask {
        private long lastTick = 0L;

        private LiveEngine() {
        }

        public void run() {
            try {
                if (Controller.this.liveData != null) {
                    Controller.this.now = System.currentTimeMillis();
                    if (Controller.this.liveData != null && Controller.this.liveData.getConfiguration() != null) {
                        if (Controller.this.liveData.getConfiguration().getDisable() == null || !Controller.this.liveData.getConfiguration().getDisable().booleanValue()) {
                            this.heartbeat();
                            this.checkTeaser();
                        } else {
                            Controller.this.removeCurrentTeaser();
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void heartbeat() {
            if (Controller.this.isHeartbeatEnabledOnCurrentNetwork() && Controller.this.liveData.getConfiguration() != null && Controller.this.liveData.getConfiguration().getHeartbeatInterval() > 0) {
                int n = Controller.this.liveData.getConfiguration().getHeartbeatInterval();
                if (Controller.this.liveData.getConfiguration().getLOCAL_previousHBinterval() > 0) {
                    n = Controller.this.liveData.getConfiguration().getLOCAL_previousHBinterval();
                }
                if (Controller.this.now - Controller.this.timers[0] > (long)(n * 1000)) {
                    Controller.this.checkInstalledApplications();
                    Controller.this.service.sendHeartbeat(Controller.this.liveData);
                    ((Controller)Controller.this).timers[0] = Controller.this.now;
                    if (Controller.this.liveData.getConfiguration().getLOCAL_previousHBinterval() > 0) {
                        Controller.this.liveData.getConfiguration().setLOCAL_previousHBinterval(0);
                        Controller.this.saveLiveData();
                    }
                }
            }
        }

        private void checkTeaser() {
            long l;
            if (Controller.this.liveData.getTeaser() != null && (l = Controller.this.liveData.getTeaser().getLOCAL_teaser_appeared()) != 0L && Controller.this.now - l > (long)(Controller.this.liveData.getTeaser().getTTL() * 1000)) {
                Controller.this.removeCurrentTeaser();
            }
        }
    }
}

