/*
 * Decompiled with CFR 0.152.
 */
package com.beeweeb.globallauncher.net;

import com.beeweeb.globallauncher.TaskManager;
import com.beeweeb.globallauncher.model.InstantLauncherData;
import com.beeweeb.globallauncher.model.Item;
import com.beeweeb.globallauncher.net.LauncherServiceListener;
import com.beeweeb.globallauncher.net.TaskDisable;
import com.beeweeb.globallauncher.net.TaskGetNewConfiguration;
import com.beeweeb.globallauncher.net.TaskHeartBeat;
import com.beeweeb.globallauncher.net.TaskLoadImage;
import com.beeweeb.globallauncher.storage.TaskDeleteImage;
import com.beeweeb.globallauncher.util.Log;
import java.util.Timer;
import java.util.TimerTask;

public class LauncherService {
    public static final String KEY_UAS = "User-Agent";
    public static final String HOST = "http://portale3.tre.it/activedesktop/il/register/";
    private LauncherServiceListener listener;
    private Timer timer;
    private TaskManager taskManager;

    public LauncherService(LauncherServiceListener launcherServiceListener) {
        this.listener = launcherServiceListener;
        this.taskManager = new TaskManager();
        this.timer = new Timer();
    }

    public void sendHeartbeat(InstantLauncherData instantLauncherData) {
        this.taskManager.runTask(new TaskHeartBeat(this, instantLauncherData));
    }

    public void getNewConfiguration(String string, InstantLauncherData instantLauncherData) {
        this.taskManager.runTask(new TaskGetNewConfiguration(this, string, instantLauncherData));
    }

    public void loadImage(InstantLauncherData instantLauncherData, Item item, String string) {
        this.taskManager.runTask(new TaskLoadImage(this, instantLauncherData, item, string));
    }

    public void disable(InstantLauncherData instantLauncherData) {
        this.taskManager.runTaskASAP(new TaskDisable(this, instantLauncherData));
    }

    public void enqueueTask(Runnable runnable) {
        this.taskManager.runTask(runnable);
    }

    public void enqueueTaskAfter(Runnable runnable, long l) {
        this.timer.schedule((TimerTask)new Enqueuer(runnable), l);
    }

    public void deleteImage(String string) {
        this.taskManager.runTask(new TaskDeleteImage(string));
    }

    public void close() {
        try {
            this.taskManager.close();
        }
        catch (Exception exception) {
            Log.log(exception);
        }
    }

    void fireHeartbeatSent() {
        this.listener.heartbeatSent();
    }

    void fireHeartbeatSent(String string) {
        this.listener.heartbeatSent(string);
    }

    void fireHeartbeatFailedForServiceError() {
        this.listener.heartbeatFailedForServiceError();
    }

    void fireHeartbeatFailed(Exception exception) {
        this.listener.heartbeatFailed(exception);
    }

    void fireImageDownloaded(Item item, String string, byte[] byArray) {
        this.listener.imageDownloaded(item, string, byArray);
    }

    void fireDownloadImageFailed(Item item, String string, Exception exception) {
        this.listener.downloadImageFailed(item, string, exception);
    }

    void fireGotNewConfiguration(InstantLauncherData instantLauncherData) {
        this.listener.gotNewConfiguration(instantLauncherData);
    }

    void fireGetNewConfigurationFailed(Exception exception) {
        this.listener.getNewConfigurationFailed(exception);
    }

    void fireGetNewConfigurationFailedForServiceError() {
        this.listener.getNewConfigurationFailedForServiceError();
    }

    void fireDisabled() {
        this.listener.disabled();
    }

    void fireDisableFailed(Exception exception) {
        this.listener.disableFailed(exception);
    }

    private class Enqueuer
    extends TimerTask {
        private Runnable nextTask;

        public Enqueuer(Runnable runnable) {
            this.nextTask = runnable;
        }

        public void run() {
            Log.log("Enqueuing new task");
            LauncherService.this.taskManager.runTask(this.nextTask);
        }
    }
}

