/*
 * Decompiled with CFR 0.152.
 */
package com.beeweeb.globallauncher.util;

import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    Reader in;
    char[] buffer;
    int pos;
    int limit;
    int markPos = -1;
    static final int DEFAULT_BUFFER_SIZE = 8192;
    private StringBuffer sbuf = null;

    public BufferedReader(Reader reader) {
        this(reader, 8192);
    }

    public BufferedReader(Reader reader, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal buffer size: " + n);
        }
        this.in = reader;
        this.buffer = new char[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in != null) {
                this.in.close();
            }
            this.in = null;
            this.buffer = null;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit is negative");
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkStatus();
            if (this.pos + n > this.limit) {
                char[] cArray = this.buffer;
                int n2 = 0;
                if (this.pos > this.limit) {
                    n2 = 1;
                }
                if (n + n2 > this.limit) {
                    this.buffer = new char[n + n2];
                }
                this.limit -= this.pos;
                if (this.limit >= 0) {
                    System.arraycopy(cArray, this.pos, this.buffer, 0, this.limit);
                    this.pos = 0;
                }
            }
            if (this.limit < 0) {
                this.pos = 1;
                this.markPos = 0;
                this.limit = 0;
            } else {
                this.markPos = this.pos;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkStatus();
            if (this.markPos < 0) {
                throw new IOException("mark never set or invalidated");
            }
            if (this.limit > 0) {
                this.pos = this.markPos;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkStatus();
            return this.pos < this.limit || this.in.ready();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (n < 0 || n + n2 > cArray.length || n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkStatus();
            boolean bl = false;
            int n3 = this.limit - this.pos;
            if (n2 > n3) {
                if (n3 > 0) {
                    n2 = n3;
                } else {
                    if (this.limit == this.buffer.length) {
                        this.markPos = -1;
                    }
                    if (this.pos > this.limit) {
                        bl = true;
                        --this.pos;
                    }
                    if (this.markPos < 0) {
                        if (n2 >= this.buffer.length && !bl) {
                            return this.in.read(cArray, n, n2);
                        }
                        this.limit = 0;
                        this.pos = 0;
                    }
                    n3 = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit);
                    if (bl && n3 > 0 && this.buffer[this.limit] == '\n') {
                        --n3;
                        ++this.limit;
                    }
                    if (n3 < n2) {
                        if (n3 <= 0) {
                            return n3;
                        }
                        n2 = n3;
                    }
                    this.limit += n3;
                }
            }
            System.arraycopy(this.buffer, this.pos, cArray, n, n2);
            this.pos += n2;
            return n2;
        }
    }

    private int fill() throws IOException {
        int n;
        this.checkStatus();
        boolean bl = false;
        if (this.pos > this.limit) {
            bl = true;
            --this.pos;
        }
        if (this.markPos >= 0 && this.limit == this.buffer.length) {
            this.markPos = -1;
        }
        if (this.markPos < 0) {
            this.limit = 0;
            this.pos = 0;
        }
        if ((n = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit)) > 0) {
            this.limit += n;
        }
        if (bl && this.buffer[this.pos] == '\n') {
            --n;
            if (this.markPos == this.pos) {
                ++this.markPos;
            }
            ++this.pos;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkStatus();
            if (this.pos >= this.limit && this.fill() <= 0) {
                return -1;
            }
            return this.buffer[this.pos++];
        }
    }

    private int lineEnd(int n) {
        char c;
        int n2;
        for (n2 = this.pos; n2 < n && (c = this.buffer[n2]) != '\n' && c != '\r'; ++n2) {
        }
        return n2;
    }

    public String readLine() throws IOException {
        int n;
        this.checkStatus();
        if (this.pos > this.limit) {
            n = this.read();
            if (n < 0) {
                return null;
            }
            if (n != 10) {
                --this.pos;
            }
        }
        if ((n = this.lineEnd(this.limit)) < this.limit) {
            String string = String.valueOf(this.buffer, this.pos, n - this.pos);
            this.pos = n + 1;
            if (this.buffer[n] == '\r' && (this.pos == this.limit || this.buffer[this.pos] == '\n')) {
                ++this.pos;
            }
            return string;
        }
        if (this.sbuf == null) {
            this.sbuf = new StringBuffer(200);
        } else {
            this.sbuf.setLength(0);
        }
        this.sbuf.append(this.buffer, this.pos, n - this.pos);
        this.pos = n;
        boolean bl = false;
        while (true) {
            int n2;
            if (this.pos >= this.limit) {
                n2 = this.fill();
                if (n2 >= 0) continue;
                bl = true;
                break;
            }
            if ((n2 = this.buffer[this.pos++]) == 10 || n2 == 13) {
                if (n2 != 13 || this.pos != this.limit && this.buffer[this.pos] != '\n') break;
                ++this.pos;
                break;
            }
            n = this.lineEnd(this.limit);
            this.sbuf.append(this.buffer, this.pos - 1, n - (this.pos - 1));
            this.pos = n;
        }
        return this.sbuf.length() == 0 && bl ? null : this.sbuf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n;
            this.checkStatus();
            if (l < 0L) {
                throw new IllegalArgumentException("skip value is negative");
            }
            if (l == 0L) {
                return 0L;
            }
            if (this.pos > this.limit) {
                if (this.read() < 0) {
                    return 0L;
                }
                --this.pos;
            }
            if (l < (long)(n = this.limit - this.pos)) {
                this.pos = (int)((long)this.pos + l);
                return l;
            }
            this.pos = this.limit;
            long l2 = l - (long)n;
            if (l2 > (long)this.buffer.length) {
                this.markPos = -1;
                l2 -= this.in.skip(l2);
            } else {
                while (l2 > 0L && (n = this.fill()) > 0) {
                    if ((long)n > l2) {
                        n = (int)l2;
                    }
                    this.pos += n;
                    l2 -= (long)n;
                }
            }
            return l - l2;
        }
    }

    private void checkStatus() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }
}

