/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.datastore;

import com.sonyericsson.fifa.data.Group;
import com.sonyericsson.fifa.data.Standing;
import com.sonyericsson.fifa.datastore.FifaDB;
import com.sonyericsson.fifa.datastore.storeobject.GroupObject;
import java.util.Enumeration;
import java.util.Vector;

public class TournamentDataDB
extends FifaDB {
    private static String STORE_NAME = "TOURNAMENT_TABLE";

    protected String getDBName() {
        return STORE_NAME;
    }

    public boolean saveGroups(Vector groups) {
        boolean result = false;
        if (groups != null) {
            result = this.saveAll(this.toGroupObjectVector(groups));
        }
        return result;
    }

    public Vector retrieveGroups() {
        Vector<GroupObject> groupObjects = new Vector<GroupObject>();
        Vector records = this.retrieveAll();
        int i = 0;
        while (i < records.size()) {
            byte[] data = (byte[])records.elementAt(i);
            GroupObject groupObject = new GroupObject();
            groupObject.loadFromByteArray(data);
            groupObjects.addElement(groupObject);
            ++i;
        }
        return this.toGroupsVector(groupObjects);
    }

    private Vector toGroupObjectVector(Vector groups) {
        Vector<GroupObject> groupObjectVector = null;
        if (groups != null) {
            groupObjectVector = new Vector<GroupObject>();
            int groupsSize = groups.size();
            int i = 0;
            while (i < groupsSize) {
                Group group = (Group)groups.elementAt(i);
                String groupName = group.getGroupName();
                Enumeration e = group.getTeams().keys();
                while (e.hasMoreElements()) {
                    String teamName = (String)e.nextElement();
                    Standing standing = group.getTeam(teamName);
                    GroupObject groupObject = new GroupObject();
                    groupObject.setGroupName(groupName);
                    groupObject.setTeamName(teamName);
                    groupObject.setStanding(standing);
                    groupObjectVector.addElement(groupObject);
                }
                ++i;
            }
        }
        return groupObjectVector;
    }

    private Vector toGroupsVector(Vector groupObjects) {
        Vector<Group> groupsVector = null;
        if (groupObjects != null) {
            groupsVector = new Vector<Group>();
            int size = groupObjects.size();
            String previousGroup = null;
            Group group = null;
            int i = 0;
            while (i < size) {
                GroupObject groupObject = (GroupObject)groupObjects.elementAt(i);
                if (previousGroup == null) {
                    previousGroup = groupObject.getGroupName();
                    group = new Group();
                    group.setGroupName(previousGroup);
                } else if (!previousGroup.equalsIgnoreCase(groupObject.getGroupName())) {
                    groupsVector.addElement(group);
                    group = new Group();
                    previousGroup = groupObject.getGroupName();
                    group.setGroupName(previousGroup);
                }
                group.addTeam(groupObject.getTeamName(), groupObject.getStanding());
                if (i == size - 1) {
                    groupsVector.addElement(group);
                }
                ++i;
            }
        }
        return groupsVector;
    }

    public boolean deleteAllRecords() {
        return this.deleteAll();
    }
}

