/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.services.parser.sax.handler;

import com.sonyericsson.fifa.data.Group;
import com.sonyericsson.fifa.data.Standing;
import com.sonyericsson.fifa.data.TeamCode;
import com.sonyericsson.fifa.data.TeamStatus;
import com.sonyericsson.fifa.services.parser.sax.contentprovider.TournamentContentProvider;
import com.sonyericsson.fifa.services.parser.sax.exceptions.RssInvalidFormatException;
import com.sonyericsson.fifa.utils.Logger;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TournamentHandler
extends DefaultHandler
implements TournamentContentProvider {
    private static final String TOURNAMENT_TAG = "TOURNAMENT";
    private static final String ITEM_TAG = "item";
    private static final String ITEM_GROUPID_ATTRIBUTE = "groupid";
    private static final String ITEM_COUNTRYCODE_ATTRIBUTE = "countrycode";
    private static final String ITEM_STATUS_ATTRIBUTE = "status";
    private static final String ITEM_GAMES_WON_ATTRIBUTE = "won";
    private static final String ITEM_GAMES_LOST_ATTRIBUTE = "lost";
    private static final String ITEM_GAMES_DRAWN_ATTRIBUTE = "dr";
    private static final String ITEM_GOALS_ATTRIBUTE = "goals";
    private static final String ITEM_TOTAL_POINTS_ATTRIBUTE = "pts";
    private boolean xmlStartedCorrectly;
    private String currentTeamCode;
    private String currentGroup;
    private Standing currentStanding;
    private Vector groups;
    private byte numberOfGroups = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String resourceId, String localName, String tagName, Attributes attributes) throws SAXException {
        if (this.xmlStartedCorrectly) {
            if (!this.xmlStartedCorrectly || !ITEM_TAG.equals(tagName) || this.currentTeamCode != null) throw new RssInvalidFormatException();
            if (attributes == null) return;
            this.parseItem(attributes);
            return;
        } else if (TOURNAMENT_TAG.equals(tagName)) {
            this.xmlStartedCorrectly = true;
            return;
        } else {
            Logger.logError(this.getClass(), "Error on parsing tournament tab XML - Not started correctly");
            throw new RssInvalidFormatException();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void endElement(String resourceId, String localName, String qName) throws SAXException {
        if (!this.xmlStartedCorrectly) throw new RssInvalidFormatException();
        if (ITEM_TAG.equals(qName) && this.currentTeamCode != null && this.currentGroup != null && this.currentStanding != null) {
            Group group = this.getGroupByName(this.currentGroup.trim());
            if (this.isValidTeam(this.currentTeamCode.trim())) {
                group.addTeam(this.currentTeamCode.trim(), this.currentStanding);
                this.currentTeamCode = null;
                this.currentGroup = null;
                this.currentStanding = null;
                return;
            }
            Logger.logError(this.getClass(), "Error on parsing tournament tab XML - The Team " + this.currentTeamCode + " was already added to other group");
            throw new RssInvalidFormatException();
        }
        if (TOURNAMENT_TAG.equals(qName)) {
            this.xmlStartedCorrectly = false;
            return;
        }
        this.currentTeamCode = null;
        this.currentGroup = null;
        this.currentStanding = null;
    }

    private void parseItem(Attributes attributes) throws SAXException {
        int numberOfAttributes = attributes.getLength();
        this.currentStanding = new Standing();
        int i = 0;
        while (i < numberOfAttributes) {
            String attributeName = attributes.getQName(i).trim();
            String attributeValue = attributes.getValue(i).trim();
            if (attributeValue != null && !"".equals(attributeValue.trim())) {
                if (ITEM_GROUPID_ATTRIBUTE.equals(attributeName)) {
                    this.currentGroup = attributeValue;
                } else if (ITEM_COUNTRYCODE_ATTRIBUTE.equals(attributeName)) {
                    if (TeamCode.isValidTeam(attributeValue)) {
                        this.currentTeamCode = attributeValue;
                    }
                } else if (ITEM_STATUS_ATTRIBUTE.equals(attributeName)) {
                    byte statusCode = TeamStatus.getStatus(attributeValue);
                    this.currentStanding.setTeamStatus(statusCode);
                    if (statusCode == 1) {
                        byte round = TeamStatus.getKnockOutRoundNumber(attributeValue);
                        this.currentStanding.setKnockOutRound(round);
                    }
                } else if (ITEM_GAMES_WON_ATTRIBUTE.equals(attributeName)) {
                    byte wonGames = 0;
                    try {
                        wonGames = Byte.parseByte(attributeValue);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.currentStanding.setGamesWon(wonGames);
                } else if (ITEM_GAMES_LOST_ATTRIBUTE.equals(attributeName)) {
                    byte lostGames = 0;
                    try {
                        lostGames = Byte.parseByte(attributeValue);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.currentStanding.setGamesLost(lostGames);
                } else if (ITEM_GAMES_DRAWN_ATTRIBUTE.equals(attributeName)) {
                    byte drawnGames = 0;
                    try {
                        drawnGames = Byte.parseByte(attributeValue);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.currentStanding.setGamesDrawn(drawnGames);
                } else if (ITEM_GOALS_ATTRIBUTE.equals(attributeName)) {
                    byte goalsGames = 0;
                    try {
                        goalsGames = Byte.parseByte(attributeValue);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.currentStanding.setGoalDifference(goalsGames);
                } else if (ITEM_TOTAL_POINTS_ATTRIBUTE.equals(attributeName)) {
                    byte totalPointsValue = 0;
                    try {
                        totalPointsValue = Byte.parseByte(attributeValue);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.currentStanding.setTotalPoints(totalPointsValue);
                }
            }
            ++i;
        }
        if (this.currentGroup == null || this.currentTeamCode == null) {
            Logger.logError(this.getClass(), "Error on parsing tournament tab XML - Item does not contain required attributes");
        }
    }

    public Vector getGroups() {
        if (this.groups == null) {
            this.groups = new Vector();
        }
        return this.groups;
    }

    private Group getGroupByName(String groupName) throws RssInvalidFormatException {
        Group group = null;
        if (groupName == null) {
            Logger.logError(this.getClass(), "Error on parsing tournament tab XML - invalid arguments on retrieving group name");
            throw new RssInvalidFormatException();
        }
        int indexElement = this.getGroups().indexOf(new Group(groupName));
        if (indexElement == -1) {
            group = new Group();
            group.setGroupName(groupName);
            this.getGroups().addElement(group);
            this.numberOfGroups = (byte)(this.numberOfGroups + 1);
        } else {
            group = (Group)this.groups.elementAt(indexElement);
        }
        return group;
    }

    private boolean isValidTeam(String teamCode) {
        boolean valid = true;
        if (teamCode == null) {
            valid = false;
        } else {
            int i = 0;
            while (i < this.getGroups().size()) {
                Group group = (Group)this.getGroups().elementAt(i);
                if (group.getTeam(teamCode) != null) {
                    valid = false;
                }
                ++i;
            }
        }
        return valid;
    }
}

