/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.exceptions.ComponentException;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.components.FifaTextArea;
import com.sonyericsson.fifa.view.components.forms.BaseForm;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.Style;
import java.io.IOException;

public class ArticleForm
extends BaseForm {
    private TextArea titleText = null;
    private FifaTextArea descriptionText = null;
    private Container headerContainer = null;
    private Container bodyContainer = null;
    private Label picture = null;
    private Label lineDivider = null;

    public ArticleForm() {
        this.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getHeight()));
        this.getStyle().setBgColor(0);
        this.getHeaderContainer().addComponent(this.getTitleTextArea());
        this.getHeaderContainer().addComponent(this.getPicture());
        this.getBodyContainer().addComponent(this.getHeaderContainer());
        this.getBodyContainer().addComponent(this.getLineDivider());
        this.getBodyContainer().addComponent(this.getDescriptionTextArea());
        this.addComponent(this.getBodyContainer());
        this.setSoftkeys();
        this.setScrollableY(true);
    }

    private void setSoftkeys() {
        try {
            this.addSoftkey();
            this.setSoftkeyBgImage();
            this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_BACK_TXT"));
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode != -5) {
            super.keyPressed(keyCode);
        }
    }

    private Container getHeaderContainer() {
        if (this.headerContainer == null) {
            this.headerContainer = new Container();
            this.headerContainer.setLayout(new BoxLayout(1));
            this.headerContainer.setPreferredSize(new Dimension(this.getAttributes().getWidth(), this.getAttributes().getSquadHeaderHeight()));
            this.headerContainer.getStyle().setMargin(0, 0, 0, 0);
            this.headerContainer.setFocusable(false);
        }
        return this.headerContainer;
    }

    private Container getBodyContainer() {
        if (this.bodyContainer == null) {
            this.bodyContainer = new Container();
            this.bodyContainer.setLayout(new BoxLayout(2));
            this.bodyContainer.setPreferredW(this.getAttributes().getWidth());
            this.bodyContainer.setPreferredH(this.getAttributes().getHeight());
            this.bodyContainer.getStyle().setBgImage(Images.getBackgroundImg());
        }
        return this.bodyContainer;
    }

    private Label getLineDivider() {
        if (this.lineDivider == null) {
            this.lineDivider = new Label();
            this.lineDivider.getStyle().setBgTransparency(0);
            this.lineDivider.setIcon(Images.getLitsDividerImg());
            this.lineDivider.getStyle().setMargin(0, 0, 0, 0);
            this.lineDivider.setFocusable(false);
        }
        return this.lineDivider;
    }

    private Label getPicture() {
        if (this.picture == null) {
            this.picture = new Label();
            this.picture.getStyle().setBgImage(Images.getArticlePhotoFrame());
            this.picture.setFocusable(false);
            this.picture.getStyle().setBgTransparency(0);
            this.picture.setPreferredW(this.getAttributes().getSquadPictureDimension());
            this.picture.setPreferredH(this.getAttributes().getSquadPictureDimension());
            this.picture.getStyle().setMargin(this.getAttributes().getSquadPictureMarginTop(), this.getAttributes().getSquadPictureMarginBottom(), 0, this.getAttributes().getSquadTitleMarginLeftRight());
            this.picture.getStyle().setPadding(0, 0, 2, 0);
        }
        return this.picture;
    }

    private TextArea getTitleTextArea() {
        if (this.titleText == null) {
            this.titleText = new TextArea();
            this.setTitleTextAreaMarginFont(this.titleText.getStyle());
            this.setTextAreaStyle(this.titleText.getStyle());
            this.titleText.setPreferredSize(new Dimension(this.getAttributes().getSquadTitleWidth(), this.getAttributes().getSquadTitleHeight()));
            this.titleText.setRows(4);
            this.titleText.setEditable(false);
            this.titleText.setFocusable(false);
            this.titleText.setGrowByContent(false);
            this.titleText.setText("Loading...");
        }
        return this.titleText;
    }

    private FifaTextArea getDescriptionTextArea() {
        if (this.descriptionText == null) {
            this.descriptionText = new FifaTextArea();
            this.setTextAreaStyle(this.descriptionText.getStyle());
            this.setDescriptionTextAreaMarginFont(this.descriptionText.getStyle());
            this.descriptionText.setEditable(false);
            this.descriptionText.setFocusable(true);
            this.descriptionText.setFocusPainted(false);
            this.descriptionText.setGrowByContent(true);
            this.descriptionText.setText("Loading...");
        }
        return this.descriptionText;
    }

    private void setTitleTextAreaMarginFont(Style style) {
        style.setMargin(this.getAttributes().getSquadTitleMarginTopBottom(), this.getAttributes().getSquadTitleMarginTopBottom(), this.getAttributes().getSquadTitleMarginLeftRight(), this.getAttributes().getSquadTitleMarginLeftRight());
        style.setFont(FifaResources.getFont("Font_SansSerif_Large_Regular"));
    }

    private void setDescriptionTextAreaMarginFont(Style style) {
        style.setMargin(this.getAttributes().getSquadTitleMarginLeftRight(), this.getAttributes().getSquadTitleMarginLeftRight(), this.getAttributes().getSquadTitleMarginLeftRight(), 0);
        style.setFont(FifaResources.getFont("Font_SansSerif_Medium_Regular"));
    }

    private void setTextAreaStyle(Style style) {
        style.setPadding(0, 0, 0, 7);
        style.setBgTransparency(0);
        style.setFgColor(0xFFFFFF);
        style.setBorder(Border.createEmpty());
    }

    public void setTitle(String text) {
        this.getTitleTextArea().setText(SystemProperties.escapeHTML(text));
    }

    public void setDescription(String text) {
        this.getDescriptionTextArea().setText(SystemProperties.escapeHTML(text));
    }

    public void setPicture(String picturePath) throws IOException {
        Image img = Image.createImage(IOUtility.openFileInputStream(picturePath));
        img = img.scaled(this.getAttributes().getSquadPictureDimension() - 4, this.getAttributes().getSquadPictureDimension() - 2);
        this.getPicture().setIcon(img);
    }

    public void setPicture(Image picture) {
        picture = picture.scaled(this.getAttributes().getSquadPictureDimension() - 4, this.getAttributes().getSquadPictureDimension() - 2);
        this.getPicture().setIcon(picture);
    }

    public void refreshAll() {
        try {
            this.setRightSoftkeyLabel(FifaResources.getMessage("FANAPP_SK_BACK_TXT"));
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }
}

