/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.forms;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.components.forms.ListItemsForm;
import com.sonyericsson.fifa.view.components.list.SquadItem;
import com.sun.lwuit.Image;
import java.io.IOException;
import java.util.Vector;

public class SquadForm
extends ListItemsForm {
    private static final String PLAYER_IMG_NAME = "player.png";
    private static final String MANAGER_IMG_NAME = "manager.png";
    private static final String GROUP = "Squad";

    public SquadForm() {
        this.addGroup();
        this.removeMiddleSoftkey();
    }

    private void addGroup() {
        this.addGroup(GROUP);
        this.listComponents.hideTitle(GROUP);
    }

    public void addItem(String title, String subTitle, int number) {
        this.addItem(GROUP, this.newListItem(title, subTitle, number));
    }

    public void removeAll() {
        super.removeAll(GROUP);
    }

    public void setHeadline(String[] imagesPath) {
        this.setHeadline(imagesPath, 2, this.attributes.getCrossfadePosX() + 1);
    }

    public void setHeadline(Vector images) {
        this.setHeadline(images, 2);
    }

    public void setCrossfadePosition() {
        this.setCrossfadePosition(this.attributes.getCrossfadePosX());
    }

    public void addCountryDataItem(String countryGroup) {
        this.addCountryDataItem(countryGroup, null);
    }

    public void showWaitIndicator() {
        this.showWaitIndicator(GROUP, this.attributes.getWaitIndicatorHeightSquad());
    }

    protected SquadItem newListItem(String title, String subTitle, int number) {
        SquadItem item = new SquadItem();
        item.setListItemDimension(this.getAttributes().getListItemWidth(), this.getAttributes().getListItemHeight());
        item.setTitleText(SystemProperties.escapeHTML(title));
        item.setTitlePadding(0, this.getAttributes().getListItemTop());
        item.setSubtitleText(SystemProperties.escapeHTML(FifaResources.getMessage(subTitle)));
        item.setFocusable(true);
        try {
            if (!subTitle.equalsIgnoreCase("FANAPP_SQUAD_MANAGER_TXT")) {
                Image img = Image.createImage(IOUtility.getImageFromRES(PLAYER_IMG_NAME));
                item.setPicture(img);
                item.setNumber(number);
            } else {
                item.setPicture(Image.createImage(IOUtility.getImageFromRES(MANAGER_IMG_NAME)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        item.revalidate();
        return item;
    }

    public void removeWaitIndicator() {
        this.removeWaitIndicator(GROUP);
    }

    public void refreshAll() {
        this.removeAll();
        this.listComponents.removeCountryDataItem();
        this.setSoftkeyLabel();
    }

    public void focusFirstItem() {
        this.focusFirstItem(GROUP);
    }

    public boolean isSquadItems() {
        return this.listComponents.isGroupEmpty();
    }
}

