/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.list;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.attributes.Attributes;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.components.FifaLookAndFeelManager;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.CoordinateLayout;
import java.io.IOException;

public class ListItemButton
extends Container {
    private Label changeTeamLabel;
    private Image imgHighlight;
    private Attributes attributes = VerifyScreenDimension.getAttributesInstance();
    private static Image change_team_img;
    private static Image change_team_selected_img;

    public ListItemButton(boolean isWelcomeView) {
        this.setLayout(new CoordinateLayout(new Dimension(this.attributes.getWidth(), this.attributes.getChangeTeamHeight() + 5)));
        this.setPreferredSize(new Dimension(new Dimension(this.attributes.getWidth(), this.attributes.getChangeTeamHeight() + 5)));
        this.setFocus(false);
        this.setFocusable(true);
        this.initChangeTeamLabel();
        if (isWelcomeView) {
            this.changeTeamLabel.setPreferredW(this.attributes.getChangeTeamWelcomeWidth());
        } else {
            this.imgHighlight = Images.getHighlightImg();
        }
        this.readImages();
        this.changeTeamLabel.getStyle().setBgImage(change_team_img);
        this.addComponent(this.changeTeamLabel);
    }

    private void readImages() {
        try {
            change_team_img = Image.createImage(IOUtility.getImageFromRES("change_team.png"));
            change_team_selected_img = Image.createImage(IOUtility.getImageFromRES("change_team_selected.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initChangeTeamLabel() {
        this.changeTeamLabel = new Label();
        this.changeTeamLabel.setPreferredSize(new Dimension(this.attributes.getChangeTeamWidth(), this.attributes.getChangeTeamHeight()));
        this.changeTeamLabel.setAlignment(4);
        this.changeTeamLabel.setX(this.attributes.getChangeTeamPosX());
        this.changeTeamLabel.setY(this.attributes.getChangeTeamPosY());
        FifaLookAndFeelManager.configToFirstLineStyle(this.changeTeamLabel);
    }

    protected void focusGained() {
        super.focusGained();
        this.getStyle().setBgImage(this.imgHighlight);
    }

    protected void focusLost() {
        this.changeTeamLabel.getStyle().setBgImage(change_team_img);
    }

    public void setText(String text) {
        if (this.changeTeamLabel != null) {
            this.changeTeamLabel.setText(text);
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -5) {
            this.switchBgImage(true);
        }
        super.keyPressed(keyCode);
    }

    public void keyReleased(int keyCode) {
        if (keyCode == -5) {
            this.switchBgImage(false);
        }
        super.keyReleased(keyCode);
    }

    public void pointerPressed(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            if (this.contains(x, y) || this.changeTeamLabel.contains(x, y)) {
                this.switchBgImage(true);
            } else {
                super.pointerPressed(x, y);
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            if (this.contains(x, y) || this.changeTeamLabel.contains(x, y)) {
                this.switchBgImage(false);
            } else {
                super.pointerReleased(x, y);
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            super.pointerDragged(x, y);
        }
    }

    private void switchBgImage(boolean isPressed) {
        if (this.hasFocus() && this.changeTeamLabel != null && isPressed) {
            this.changeTeamLabel.getStyle().setBgImage(change_team_selected_img);
        } else {
            this.changeTeamLabel.getStyle().setBgImage(change_team_img);
        }
        this.changeTeamLabel.repaint();
    }

    public void keyRepeated(int keyCode) {
        super.keyRepeated(keyCode);
    }
}

