/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.list;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.Images;
import com.sonyericsson.fifa.view.components.FifaLookAndFeelManager;
import com.sun.lwuit.Container;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BoxLayout;
import java.io.IOException;

public class ListItemMore
extends Container {
    private Label labelText;
    private Label labelIcon;

    public ListItemMore() {
        this.setFocus(false);
        this.setFocusable(true);
        this.setLayout(new BoxLayout(1));
        this.setPreferredSize(new Dimension(VerifyScreenDimension.getAttributesInstance().getListItemWidth(), VerifyScreenDimension.getAttributesInstance().getMoreSquadHeight()));
        this.initLabelText();
        this.initLabelIcon();
        this.addComponent(this.labelText);
        this.addComponent(this.labelIcon);
    }

    private void initLabelText() {
        this.labelText = new Label();
        this.labelText.setPreferredW(VerifyScreenDimension.getAttributesInstance().getListItemMoreTextWidth());
        FifaLookAndFeelManager.configToFirstLineStyle(this.labelText);
        FifaLookAndFeelManager.configToTransparencyStyle(this.labelText);
    }

    private void initLabelIcon() {
        this.labelIcon = new Label();
        this.labelIcon.getStyle().setBgTransparency(0);
        try {
            Image imgArrowRight = Image.createImage(IOUtility.getImageFromRES("arrow_right.png"));
            this.labelIcon.setIcon(imgArrowRight);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.labelIcon.setAlignment(3);
    }

    public void setText(String text) {
        if (this.labelText != null) {
            this.labelText.setText(text);
        }
    }

    public void setIcon(Image icon) {
        if (this.labelIcon != null) {
            this.labelIcon.setIcon(icon);
        }
    }

    protected void focusGained() {
        super.focusGained();
        this.getStyle().setBgImage(Images.getHighlightImg());
    }
}

