/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.controller;

import com.sonyericsson.fifa.controller.Controller;
import com.sonyericsson.fifa.controller.ControllerListener;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.view.View;
import com.sonyericsson.fifa.view.ViewActionListener;
import com.sonyericsson.fifa.view.action.Action;
import java.util.Vector;

public abstract class AbstractController
implements Controller,
ViewActionListener {
    protected Vector listeners = new Vector();
    protected Model model;
    protected View currentView;

    public void start() {
    }

    public void stop() {
    }

    public final void addControllerListener(ControllerListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public final void removeControllerListener(ControllerListener listener) {
        this.listeners.removeElement(listener);
    }

    protected final void fireControllerShutdown() {
        int i = 0;
        while (i < this.listeners.size()) {
            ControllerListener controllerListener = (ControllerListener)this.listeners.elementAt(i);
            controllerListener.shutdown();
            ++i;
        }
    }

    protected final void setCurrentView(View newView) throws ViewException {
        if (newView != null) {
            if (this.currentView != null) {
                this.currentView.removeViewActionListener(this);
                this.currentView.hide();
            }
            newView.addViewActionListener(this);
            newView.show();
            this.currentView = newView;
        }
    }

    public abstract void doViewActionPerformed(Action var1);

    public void viewActionPerformed(Action action) {
        this.doViewActionPerformed(action);
    }
}

