/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components.list;

import com.sonyericsson.fifa.utils.attributes.Attributes;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import com.sonyericsson.fifa.view.ViewFactory;
import com.sonyericsson.fifa.view.components.FifaLookAndFeelManager;
import com.sonyericsson.fifa.view.components.WaitIndicator;
import com.sonyericsson.fifa.view.components.list.CountryDataItem;
import com.sonyericsson.fifa.view.components.list.GroupContainer;
import com.sonyericsson.fifa.view.components.list.Headline;
import com.sonyericsson.fifa.view.components.list.ListItem;
import com.sonyericsson.fifa.view.components.list.ListItemButton;
import com.sonyericsson.fifa.view.components.list.ListItemFeedTicker;
import com.sonyericsson.fifa.view.components.list.ListItemMore;
import com.sonyericsson.fifa.view.components.listener.SelectableItemListener;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ListComponentsContainer
extends Container {
    private static final String FIRST_TITLE_LIST = "first_title_list.png";
    private static final String OTHER_TITLE_LIST = "other_title_list.png";
    private Hashtable subgroups = null;
    private Headline headline = null;
    private SelectableItemListener selectListener = null;
    private WaitIndicator waitIndicator = null;
    private String lastGroup = null;

    public ListComponentsContainer() {
        FifaLookAndFeelManager.changeContainerBehaviour(this);
        this.setScrollable(true);
        FifaLookAndFeelManager.configToTransparencyStyle(this);
        this.requestFocus();
    }

    public boolean containsItem(String subGroupName, Component component) {
        return ((GroupContainer)this.getSubgroupTable().get(subGroupName)).contains(component);
    }

    private Hashtable getSubgroupTable() {
        if (this.subgroups == null) {
            this.subgroups = new Hashtable();
        }
        return this.subgroups;
    }

    private GroupContainer newGroupContainer(String groupName) {
        GroupContainer subgroup = new GroupContainer();
        subgroup.setTitle(groupName);
        this.getSubgroupTable().put(groupName, subgroup);
        if (this.getSubgroupTable().size() == 1) {
            subgroup.setBackground(FIRST_TITLE_LIST);
        } else if (this.getSubgroupTable().size() > 1) {
            subgroup.setBackground(OTHER_TITLE_LIST);
        }
        return subgroup;
    }

    private GroupContainer newGroupContainer(boolean anotherBg, String groupName) {
        GroupContainer subgroup = new GroupContainer();
        subgroup.setTitle(groupName);
        this.getSubgroupTable().put(groupName, subgroup);
        if (anotherBg) {
            subgroup.setBackground(FIRST_TITLE_LIST);
        } else {
            subgroup.setBackground(OTHER_TITLE_LIST);
        }
        return subgroup;
    }

    public void fillEmptySpace() {
        ((GroupContainer)this.getSubgroupTable().get(this.lastGroup)).addComponent(this.newFakeListItem());
    }

    protected ListItem newFakeListItem() {
        ListItem item = new ListItem();
        int height = VerifyScreenDimension.getAttributesInstance().getHeight() - VerifyScreenDimension.getAttributesInstance().getHeadlineHeight() - VerifyScreenDimension.getAttributesInstance().getSoftkeyHeight() - this.getSubGroupsHeight();
        item.setListItemDimension(VerifyScreenDimension.getAttributesInstance().getWidth(), height);
        item.setTitleText(null);
        item.setSubtitleText(null);
        item.removePicture();
        item.setFocusable(false);
        return item;
    }

    private int getSubGroupsHeight() {
        int sum = 0;
        Enumeration e = this.getSubgroupTable().elements();
        while (e.hasMoreElements()) {
            sum += ((GroupContainer)e.nextElement()).getPreferredH();
        }
        return sum;
    }

    public void addGroup(String subgroupName) {
        if (!this.containsGroup(subgroupName)) {
            this.lastGroup = subgroupName;
            this.addComponent(this.newGroupContainer(subgroupName));
        }
    }

    public void addGroup(boolean anotherBg, String subgroupName) {
        if (!this.containsGroup(subgroupName)) {
            this.addComponent(this.newGroupContainer(anotherBg, subgroupName));
        }
    }

    public void addItem(String subgroupName, Component component) {
        this.showTitle(subgroupName);
        ((GroupContainer)this.getSubgroupTable().get(subgroupName)).addComponent(component);
    }

    public void addFakeItem(String subgroupName, Component component) {
        ((GroupContainer)this.getSubgroupTable().get(subgroupName)).addComponent(-1, component);
    }

    public void addItem(int cmpIndex, String subgroupName, Component component) {
        this.showTitle(subgroupName);
        ((GroupContainer)this.getSubgroupTable().get(subgroupName)).addComponent(cmpIndex, component);
    }

    public void removeItem(String subgroupName, Component component) {
        ((GroupContainer)this.getSubgroupTable().get(subgroupName)).removeComponent(component);
    }

    public void removeAll(String subgroupName) {
        if (this.getSubgroupTable() != null) {
            GroupContainer groupContainer = (GroupContainer)this.getSubgroupTable().get(subgroupName);
            if (groupContainer != null) {
                groupContainer.removeAll();
            }
            this.getHeadlineCmp().removeAll();
        }
    }

    public void removeWaitIndicator(String subgroupName) {
        GroupContainer groupContainer;
        if (this.getSubgroupTable() != null && (groupContainer = (GroupContainer)this.getSubgroupTable().get(subgroupName)) != null) {
            groupContainer.removeComponent(this.getWaitIndicator(0));
            this.waitIndicator = null;
        }
    }

    public void removeWaitIndicator() {
        if (this.getComponentIndex(this.getWaitIndicator()) != -1) {
            this.removeComponent(this.getWaitIndicator());
        }
    }

    public void showTitle(String subgroupName) {
        ((GroupContainer)this.getSubgroupTable().get(subgroupName)).showTitle();
    }

    public void hideTitle(String subgroupName) {
        ((GroupContainer)this.getSubgroupTable().get(subgroupName)).hideTitle();
    }

    public void setHeadline(String[] imagesPath, int borderType) {
        this.getHeadlineCmp().setImagesBackground(imagesPath);
        this.setHeadlineBorder(borderType);
    }

    public void setHeadline(Vector images, int borderType) {
        this.getHeadlineCmp().setImagesBackground(images);
        this.setHeadlineBorder(borderType);
        this.getHeadlineCmp().repaint();
    }

    public void addCountryDataItem(CountryDataItem countryData) {
        this.getHeadlineCmp().addListItem(countryData);
    }

    public void showWaitIndicator(String subGroup, int height) {
        ((GroupContainer)this.getSubgroupTable().get(subGroup)).addComponent(this.getWaitIndicator(height));
    }

    public void showWaitIndicator(int height) {
        this.addComponent(this.getWaitIndicator(height));
    }

    public void removeCountryDataItem() {
        this.getHeadlineCmp().removeCountryData();
    }

    private WaitIndicator getWaitIndicator(int height) {
        if (this.waitIndicator == null) {
            this.waitIndicator = ViewFactory.getWaitIndicator();
        }
        if (height > 0) {
            this.waitIndicator.setPreferredH(height);
        }
        return this.waitIndicator;
    }

    private void setHeadlineBorder(int borderType) {
        switch (borderType) {
            case 0: {
                this.getHeadlineCmp().drawImageBorder();
                break;
            }
            case 1: {
                this.getHeadlineCmp().drawWhiteBorder();
                break;
            }
            case 2: {
                this.getHeadlineCmp().withoutBorder();
            }
        }
        if (this.getComponentIndex(this.getHeadlineCmp()) == -1) {
            this.addComponent(0, (Component)this.getHeadlineCmp());
        }
    }

    public void setCrossfadePosition(int posX, int posY) {
        this.getHeadlineCmp().setCrossfadePosition(posX, posY);
    }

    public void startHeadlineCrossfade(Form componentForm) {
        this.getHeadlineCmp().startCrossFade(componentForm);
    }

    public void pauseHeadlineCrossfase(Form componentForm) {
        this.getHeadlineCmp().pauseCrossFade(componentForm);
    }

    private Headline getHeadlineCmp() {
        if (this.headline == null) {
            this.headline = new Headline();
        }
        return this.headline;
    }

    public int[] getSelectedItem() {
        int countSubgroupItem = 0;
        int i = 0;
        while (i < this.getComponentCount()) {
            Component groupContainer = this.getComponentAt(i);
            if (groupContainer instanceof GroupContainer) {
                GroupContainer itemGroup = (GroupContainer)groupContainer;
                int j = 0;
                while (j < itemGroup.getComponentCount()) {
                    Component itemSubGroup = itemGroup.getComponentAt(j);
                    if (itemSubGroup instanceof ListItemButton) {
                        return new int[]{-1, -1};
                    }
                    if (itemSubGroup instanceof ListItemMore) {
                        return new int[]{-2, -2};
                    }
                    if (itemSubGroup instanceof Container) {
                        Container c = (Container)itemSubGroup;
                        int selectable = 0;
                        while (selectable < c.getComponentCount()) {
                            Container item = (Container)c.getComponentAt(selectable);
                            if (item.hasFocus()) {
                                int[] itemSubgroup = new int[]{selectable, countSubgroupItem};
                                return itemSubgroup;
                            }
                            ++selectable;
                        }
                    }
                    ++j;
                }
                ++countSubgroupItem;
            }
            ++i;
        }
        return null;
    }

    public void setItemPicture(String subGroup, int itemIndex, String picturePath) {
        if (subGroup != null) {
            ((GroupContainer)this.getSubgroupTable().get(subGroup)).setItemPicture(itemIndex, picturePath);
        }
    }

    Component searchInstance(Component cmp) {
        while (!(cmp instanceof ListItem || cmp instanceof ListItemButton || cmp instanceof ListItemMore || cmp instanceof ListItemFeedTicker)) {
            if (cmp != null) {
                cmp = cmp.getParent();
            }
            if (cmp != null) continue;
            return null;
        }
        return cmp;
    }

    public void pointerPressed(int x, int y) {
        Attributes attributes;
        if (Display.getInstance().isTouchScreenDevice() && (y += (attributes = VerifyScreenDimension.getAttributesInstance()).getPointerPressedY()) > attributes.getTabsMenuHeight() && y < attributes.getHeight() - attributes.getSoftkeyHeight()) {
            Component c = this.searchInstance(this.getComponentAt(x, y));
            if (c != null) {
                if (c.hasFocus()) {
                    int[] t = this.getSelectedItem();
                    this.notifySelectedItem(t[0], t[1]);
                } else {
                    c.requestFocus();
                }
            }
            super.pointerPressed(x, y);
        }
    }

    public void pointerReleased(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            Component c = this.searchInstance(this.getComponentAt(x, y += VerifyScreenDimension.getAttributesInstance().getHeightConstant()));
            if (c != null) {
                c.requestFocus();
            }
            super.pointerReleased(x, y);
        }
    }

    public void pointerDragged(int x, int y) {
        if (Display.getInstance().isTouchScreenDevice()) {
            super.pointerDragged(x, y);
        }
    }

    public void setSelectedItemListener(SelectableItemListener selectListener) {
        this.selectListener = selectListener;
    }

    private void notifySelectedItem(int item, int subgroup) {
        if (this.selectListener != null) {
            this.selectListener.selectedItem(item, subgroup);
        }
    }

    public void removeAllComponents(boolean removeHeadline) {
        Enumeration e = this.subgroups.elements();
        e = this.subgroups.elements();
        while (e.hasMoreElements()) {
            GroupContainer groupContainer = (GroupContainer)e.nextElement();
            groupContainer.hideTitle();
            groupContainer.removeAll();
            this.removeComponent(groupContainer);
        }
        if (removeHeadline && this.getComponentIndex(this.getHeadlineCmp()) != -1) {
            this.removeComponent(this.getHeadlineCmp());
        }
        this.getSubgroupTable().clear();
    }

    private boolean containsGroup(String groupName) {
        if (this.subgroups != null) {
            Enumeration e = this.subgroups.elements();
            e = this.subgroups.elements();
            while (e.hasMoreElements()) {
                GroupContainer groupContainer = (GroupContainer)e.nextElement();
                if (!groupName.equals(groupContainer.getGroupName())) continue;
                return true;
            }
        }
        return false;
    }

    public void focusFirstItem(String subgroupName) {
        GroupContainer groupContainer;
        if (this.getSubgroupTable() != null && (groupContainer = (GroupContainer)this.getSubgroupTable().get(subgroupName)) != null) {
            groupContainer.focusFirstItem();
        }
    }

    public boolean isFirstItemFocused(String subgroupName) {
        GroupContainer groupContainer;
        if (this.getSubgroupTable() != null && (groupContainer = (GroupContainer)this.getSubgroupTable().get(subgroupName)) != null) {
            return groupContainer.isFirstItemFocused();
        }
        return false;
    }

    public Component getFirstComponent(String subgroupName, boolean scrollToHeadline) {
        GroupContainer groupContainer;
        if (scrollToHeadline) {
            return this.getHeadlineCmp();
        }
        if (this.getSubgroupTable() != null && (groupContainer = (GroupContainer)this.getSubgroupTable().get(subgroupName)) != null) {
            return groupContainer.getFirstComponent();
        }
        return null;
    }

    public void changeFirstItemToSecondItemBack(int cmpIndex, String subgroupName, boolean isFirstBack) {
        ((GroupContainer)this.getSubgroupTable().get(subgroupName)).setFirstItemBackground(cmpIndex, isFirstBack);
    }

    public WaitIndicator getWaitIndicator() {
        return this.waitIndicator;
    }

    public boolean isGroupEmpty() {
        Enumeration e = this.subgroups.elements();
        e = this.subgroups.elements();
        while (e.hasMoreElements()) {
            GroupContainer groupContainer = (GroupContainer)e.nextElement();
            if (groupContainer.getItemsCount() <= 0) continue;
            return false;
        }
        return true;
    }
}

