/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.controller;

import com.sonyericsson.fifa.controller.Controller;
import com.sonyericsson.fifa.controller.ControllerListener;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.utils.Configuration;
import com.sonyericsson.fifa.view.View;
import com.sonyericsson.fifa.view.ViewActionListener;
import com.sun.lwuit.Display;
import java.util.Stack;
import java.util.Vector;

public abstract class AbstractController
implements Controller {
    private Vector listeners = new Vector();
    static View currentView;
    private static ViewActionListener viewActionListener;
    private static Stack viewStack;

    static {
        viewStack = new Stack();
    }

    public final void addControllerListener(ControllerListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public final void removeControllerListener(ControllerListener listener) {
        this.listeners.removeElement(listener);
    }

    protected final void fireControllerShutdown() {
        int i = 0;
        while (i < this.listeners.size()) {
            ControllerListener controllerListener = (ControllerListener)this.listeners.elementAt(i);
            controllerListener.shutdown();
            ++i;
        }
    }

    protected static final void setViewActionListener(ViewActionListener viewListener) {
        viewActionListener = viewListener;
    }

    protected static final void setCurrentView(View newView) throws ViewException {
        if (newView != null) {
            if (currentView != null) {
                currentView.removeViewActionListener(viewActionListener);
                currentView.hide();
            }
            newView.addViewActionListener(viewActionListener);
            newView.show();
            currentView = newView;
        }
        if (Configuration.isBackgroundMode()) {
            Display.getInstance().minimizeApplication();
        }
    }

    protected static final void pushViewOnStack(View view) {
        if (!viewStack.contains(view)) {
            viewStack.push(view);
        }
    }

    protected static final View popViewFromStack() {
        return (View)viewStack.pop();
    }

    protected static final void cleanViewStack() {
        viewStack.removeAllElements();
    }

    protected static final void cleanViewStackAndHide() {
        int i = 0;
        while (i < viewStack.size()) {
            View view = (View)viewStack.pop();
            view.hide();
            ++i;
        }
    }

    protected static final View getViewFromStack(int index) {
        View view = null;
        if (!viewStack.isEmpty() && viewStack.size() > index) {
            view = (View)viewStack.elementAt(index);
        }
        return view;
    }

    protected static final boolean isViewStackEmpty() {
        return viewStack.isEmpty();
    }

    public void start() {
    }

    public void stop() {
    }
}

