/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.controller;

import com.sonyericsson.fifa.controller.AbstractController;
import com.sonyericsson.fifa.data.Team;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.services.chapiservice.ChapiListener;
import com.sonyericsson.fifa.services.chapiservice.ChapiService;
import com.sonyericsson.fifa.services.chapiservice.StartWidgetRequest;
import com.sonyericsson.fifa.services.chapiservice.StopWidgetRequest;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.View;
import com.sonyericsson.fifa.view.ViewFactory;
import com.sonyericsson.fifa.view.dialogs.DialogsManager;
import com.sonyericsson.fifa.view.exceptions.VideoPlayerException;
import com.sonyericsson.fifa.view.language.UpdateLanguageListener;
import com.sonyericsson.fifa.view.player.VideoPlayerView;
import com.sonyericsson.fifa.view.player.VideoPlayerViewHB209;
import com.sonyericsson.fifa.view.tabs.ArticleView;
import com.sonyericsson.fifa.view.tabs.TeamView;
import com.sun.lwuit.Display;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.content.ContentHandlerException;
import javax.microedition.content.ContentHandlerServer;
import javax.microedition.content.Invocation;
import javax.microedition.content.Registry;
import javax.microedition.content.RequestListener;
import javax.microedition.content.ResponseListener;

public class ChapiHandler
extends AbstractController
implements RequestListener,
ResponseListener,
ChapiListener {
    private static final String OP_OPEN_NEWS = "openFeedItem";
    private static final String OP_PLAY_VIDEOS = "playVideo";
    public static final String OP_START_IN_BACKGROUND = "startInBackground";
    private static final String OP_UPDATED_LANGUAGE = "updateLanguage";
    private static final String ENTERTAINMENT_TAB = "EntertainmentTab";
    private static final String TOURNAMENT_TAB = "TournamentTab";
    private static final String MY_TEAM_TAB = "TeamTab";
    private static final String APPHS_ID = "HSFootballFan";
    private static final String CLASS_NAME = "com.sonyericsson.fifa.midlet.FifaMIDlet";
    private static final int SARA_PLATFORM = 432;
    private String status_Widget;
    private Model model;
    private Vector invocationList = new Vector();
    private String action = null;
    private String[] arguments = null;
    private Invocation invocation = null;
    private UpdateLanguageListener updateLanguageListener = null;
    boolean homescreenEnabled = false;
    boolean setHomescreenFlag = false;

    public ChapiHandler(Model model) {
        this.model = model;
        this.invocationList.addElement(null);
    }

    public void invocationRequestNotify(ContentHandlerServer server) {
        Invocation auxInvocation = null;
        if (server != null) {
            auxInvocation = server.getRequest(false);
            while (auxInvocation != null) {
                this.invocation = auxInvocation;
                this.action = this.invocation.getAction();
                if (this.action != null && (this.action.equalsIgnoreCase(OP_OPEN_NEWS) || this.action.equalsIgnoreCase(OP_PLAY_VIDEOS) || this.action.equalsIgnoreCase(OP_UPDATED_LANGUAGE))) {
                    this.invocationList.setElementAt(this.invocation, 0);
                }
                auxInvocation = server.getRequest(false);
            }
            server.finish(this.invocation, 8);
            if (this.invocationList.size() > 0 && this.invocationList.elementAt(0) != null) {
                this.arguments = null;
                this.invocation = (Invocation)this.invocationList.elementAt(0);
                this.action = this.invocation.getAction();
                this.arguments = this.invocation.getArgs();
                this.invocationList.setElementAt(null, 0);
                if (!this.action.equalsIgnoreCase(OP_UPDATED_LANGUAGE)) {
                    this.model.setCallByHomeScreen(true);
                    this.model.closeVideo();
                    this.checkNetwork();
                }
                this.handleInvocation(this.action, this.arguments);
            }
        }
    }

    private void checkNetwork() {
        if (SystemProperties.isFlightMode() || !this.model.isNetworkingAuthorized() || SystemProperties.isRoaming() && this.model.isHomeNetworkOnlyActivated() || !IOUtility.hasNetworkingConnection()) {
            this.model.getMyTeam().simulateUpdateFinished();
        }
    }

    public void handleInvocation(String action, String[] arguments) {
        if (action != null) {
            if (action.equalsIgnoreCase(OP_PLAY_VIDEOS)) {
                this.mountTabView(ENTERTAINMENT_TAB);
                SystemProperties.minimizeApplication();
                Display.getInstance().restoreMinimizedApplication();
                if (arguments.length > 0) {
                    if (this.isVideoAvailable(arguments[0])) {
                        this.doPlayVideo(arguments[0]);
                    } else {
                        this.showDialogInformation();
                    }
                }
            } else if (action.equalsIgnoreCase(OP_OPEN_NEWS)) {
                FeedItem feedItem = null;
                if (this.isMyTeam(arguments[0])) {
                    this.mountTabView(MY_TEAM_TAB);
                    ViewFactory.getInstance().getMyTeamView().updateView();
                } else {
                    this.mountTabView(TOURNAMENT_TAB);
                    AbstractController.pushViewOnStack(new TeamView(this.model, arguments[0]));
                    this.model.updateTeam(arguments[0]);
                }
                feedItem = this.isFeedItemAvailable(arguments[0], arguments[1]);
                if (feedItem != null) {
                    try {
                        ArticleView article = new ArticleView(this.model);
                        article.updateData(feedItem);
                        AbstractController.setCurrentView(article);
                    }
                    catch (ViewException e) {
                        e.printStackTrace();
                    }
                    SystemProperties.restoreApplication();
                } else {
                    SystemProperties.restoreApplication();
                    this.showDialogInformation();
                }
            } else if (action.equalsIgnoreCase(OP_UPDATED_LANGUAGE)) {
                SystemProperties.restoreApplication();
                if (this.updateLanguageListener != null) {
                    this.updateLanguageListener.updateLanguage();
                }
            } else {
                Logger.logError(this.getClass(), "Operation not supported: " + action);
            }
        }
        System.out.println("handleInvocation - end");
    }

    private void doPlayVideo(String videoPath) {
        int displayHeight = SystemProperties.getDisplayHeight();
        switch (displayHeight) {
            case 432: {
                try {
                    VideoPlayerViewHB209 videoViewHB209 = new VideoPlayerViewHB209(14, this.model);
                    videoViewHB209.startVideo(videoPath);
                    AbstractController.setCurrentView(videoViewHB209);
                }
                catch (ViewException e) {
                    this.showDialogInformation();
                    Logger.logError(this.getClass(), "ViewException: " + e.getMessage());
                }
                catch (IOException e) {
                    this.showDialogInformation();
                    Logger.logError(this.getClass(), "IOException: " + e.getMessage());
                }
                catch (VideoPlayerException e) {
                    this.showDialogInformation();
                    Logger.logError(this.getClass(), "VideoPlayerException: " + e.getMessage());
                }
                break;
            }
            default: {
                try {
                    VideoPlayerView videoView = new VideoPlayerView(4, this.model);
                    videoView.startVideo(videoPath);
                    AbstractController.setCurrentView(videoView);
                    break;
                }
                catch (ViewException e) {
                    this.showDialogInformation();
                    Logger.logError(this.getClass(), "ViewException: " + e.getMessage());
                    break;
                }
                catch (IOException e) {
                    this.showDialogInformation();
                    Logger.logError(this.getClass(), "IOException: " + e.getMessage());
                    break;
                }
                catch (VideoPlayerException e) {
                    this.showDialogInformation();
                    Logger.logError(this.getClass(), "VideoPlayerException: " + e.getMessage());
                }
            }
        }
    }

    private void showDialogInformation() {
        try {
            DialogsManager.showNoAccessAlert();
            View newView = AbstractController.popViewFromStack();
            AbstractController.setCurrentView(newView);
        }
        catch (ViewException e) {
            e.printStackTrace();
        }
    }

    private void mountTabView(String viewName) {
        AbstractController.cleanViewStackAndHide();
        if (AbstractController.currentView != null) {
            AbstractController.currentView.hide();
        }
        if (viewName.equalsIgnoreCase(ENTERTAINMENT_TAB)) {
            if (!this.model.isPreloadedContentUpdated()) {
                this.model.updatePreloadedContent();
            }
            AbstractController.pushViewOnStack(ViewFactory.getInstance().getEntertainmentView());
        } else if (viewName.equalsIgnoreCase(MY_TEAM_TAB)) {
            AbstractController.pushViewOnStack(ViewFactory.getInstance().getMyTeamView());
        } else if (viewName.equalsIgnoreCase(TOURNAMENT_TAB)) {
            AbstractController.pushViewOnStack(ViewFactory.getInstance().getTournamentView());
        }
    }

    private boolean isVideoAvailable(String video) {
        return IOUtility.isFileAvailable(video);
    }

    private boolean isMyTeam(String myTeamCode) {
        boolean result = false;
        Team myTeam = null;
        Team team = null;
        if (myTeamCode != null && this.model != null) {
            myTeam = this.model.getMyTeam();
            team = this.model.getTeam(myTeamCode);
        }
        if (myTeam != null && team != null && myTeam.equals(team)) {
            result = true;
        }
        return result;
    }

    private FeedItem isFeedItemAvailable(String countryCode, String title) {
        FeedItem feed = this.model.getFeedItem(countryCode, title);
        return feed;
    }

    public void registerToChapi() {
        try {
            ContentHandlerServer contentHandler = Registry.getServer((String)CLASS_NAME);
            Registry registry = Registry.getRegistry((String)CLASS_NAME);
            contentHandler.setListener((RequestListener)this);
            registry.setListener((ResponseListener)this);
        }
        catch (SecurityException e) {
            Logger.logError(this.getClass(), "SecurityException: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            Logger.logError(this.getClass(), "IllegalArgumentException: " + e.getMessage());
        }
        catch (ContentHandlerException e) {
            e.printStackTrace();
        }
    }

    public void changeWidgetStatus(String status, boolean setHomescreenFlag) {
        this.setHomescreenFlag = setHomescreenFlag;
        this.status_Widget = status;
        this.homescreenEnabled = false;
        if (status != null) {
            ChapiService chapiService = null;
            if (this.status_Widget.equalsIgnoreCase("startHomescreen")) {
                chapiService = new StartWidgetRequest(APPHS_ID);
                this.homescreenEnabled = true;
            } else if (this.status_Widget.equalsIgnoreCase("stopHomescreen")) {
                chapiService = new StopWidgetRequest(APPHS_ID);
                this.homescreenEnabled = false;
            } else {
                Logger.logError(this.getClass(), "changeWidgetStatus: invalid status: " + status);
            }
            if (chapiService != null) {
                chapiService.setListener(this);
                chapiService.run();
            }
        }
    }

    public void invocationResponseNotify(Registry registry) {
    }

    public void start() {
    }

    public void stop() {
    }

    public void setUpdateLanguageListener(UpdateLanguageListener languageListener) {
        this.updateLanguageListener = languageListener;
    }

    public void operationResult(boolean result) {
        if (result && this.setHomescreenFlag) {
            this.model.setWidgetStatus(this.homescreenEnabled);
        }
    }
}

