/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.controller;

import com.sonyericsson.fifa.controller.AbstractController;
import com.sonyericsson.fifa.controller.ChapiHandler;
import com.sonyericsson.fifa.data.OnlineContent;
import com.sonyericsson.fifa.data.PreloadedContent;
import com.sonyericsson.fifa.data.Team;
import com.sonyericsson.fifa.datastore.DBFailureListener;
import com.sonyericsson.fifa.datastore.FifaSharedDB;
import com.sonyericsson.fifa.exceptions.ViewException;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.ModelControllerListener;
import com.sonyericsson.fifa.model.UpdateGroup;
import com.sonyericsson.fifa.model.tournamentTable.TournamentTableListener;
import com.sonyericsson.fifa.services.appmanager.RunGameService;
import com.sonyericsson.fifa.services.chapiservice.ChapiService;
import com.sonyericsson.fifa.services.scheduler.ScheduleUpdateListener;
import com.sonyericsson.fifa.services.scheduler.UpdateTimerTask;
import com.sonyericsson.fifa.services.upgrade.ApplicationUpgrade;
import com.sonyericsson.fifa.utils.FeedFileCleaner;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.FifaResources;
import com.sonyericsson.fifa.view.View;
import com.sonyericsson.fifa.view.ViewActionListener;
import com.sonyericsson.fifa.view.ViewFactory;
import com.sonyericsson.fifa.view.action.AboutLicenseAction;
import com.sonyericsson.fifa.view.action.Action;
import com.sonyericsson.fifa.view.action.BackAction;
import com.sonyericsson.fifa.view.action.ChangeTeamAction;
import com.sonyericsson.fifa.view.action.ExtraVideoSelectedAction;
import com.sonyericsson.fifa.view.action.FifaWebSiteAction;
import com.sonyericsson.fifa.view.action.GNULicenseAction;
import com.sonyericsson.fifa.view.action.ManualUpdateAction;
import com.sonyericsson.fifa.view.action.MinimizeAction;
import com.sonyericsson.fifa.view.action.MoreExtrasSelected;
import com.sonyericsson.fifa.view.action.MoreSelectedAction;
import com.sonyericsson.fifa.view.action.NextTabAction;
import com.sonyericsson.fifa.view.action.OpenExtraVideosAction;
import com.sonyericsson.fifa.view.action.OpenGameAction;
import com.sonyericsson.fifa.view.action.OpenGameExtrasAction;
import com.sonyericsson.fifa.view.action.OpenLinkAction;
import com.sonyericsson.fifa.view.action.OpenVideoAction;
import com.sonyericsson.fifa.view.action.OptionsAction;
import com.sonyericsson.fifa.view.action.SelectedAction;
import com.sonyericsson.fifa.view.action.SelectedTeamAction;
import com.sonyericsson.fifa.view.action.SelectedTournamentTeamAction;
import com.sonyericsson.fifa.view.action.ShareAction;
import com.sonyericsson.fifa.view.action.TeamItemSelectedAction;
import com.sonyericsson.fifa.view.action.UpdateFailureAction;
import com.sonyericsson.fifa.view.action.UpdateMyTeamAction;
import com.sonyericsson.fifa.view.action.UpgradeAction;
import com.sonyericsson.fifa.view.action.ViewArticleAction;
import com.sonyericsson.fifa.view.action.WidgetAction;
import com.sonyericsson.fifa.view.dialogs.DialogsManager;
import com.sonyericsson.fifa.view.exceptions.VideoPlayerException;
import com.sonyericsson.fifa.view.language.Language;
import com.sonyericsson.fifa.view.language.UpdateLanguageListener;
import com.sonyericsson.fifa.view.player.VideoPlayerView;
import com.sonyericsson.fifa.view.player.VideoPlayerViewHB209;
import com.sonyericsson.fifa.view.tabs.AboutLicenseView;
import com.sonyericsson.fifa.view.tabs.ArticleView;
import com.sonyericsson.fifa.view.tabs.ChangeTeamView;
import com.sonyericsson.fifa.view.tabs.EntertaimentView;
import com.sonyericsson.fifa.view.tabs.ExtraVideosView;
import com.sonyericsson.fifa.view.tabs.GNULicenseView;
import com.sonyericsson.fifa.view.tabs.MoreExtrasView;
import com.sonyericsson.fifa.view.tabs.MoreNewsView;
import com.sonyericsson.fifa.view.tabs.MyTeamView;
import com.sonyericsson.fifa.view.tabs.OptionsView;
import com.sonyericsson.fifa.view.tabs.TeamView;
import com.sonyericsson.fifa.view.tabs.TournamentView;
import com.sonyericsson.fifa.view.tabs.WelcomeView;
import com.sun.lwuit.Display;
import java.io.IOException;
import java.util.EmptyStackException;
import javax.microedition.io.ConnectionNotFoundException;

public class FifaController
extends AbstractController
implements ModelControllerListener,
ViewActionListener,
DBFailureListener,
UpdateLanguageListener,
TournamentTableListener,
ScheduleUpdateListener {
    private Model model;
    private ChapiHandler chapiHandler;
    private Language language = null;
    private static final String FB_SHARE_URL = "http://m.facebook.com/sharer.php?u=";
    private UpdateTimerTask updateTimerTask;

    public FifaController(Model model, ChapiHandler handler) {
        this.model = model;
        this.chapiHandler = handler;
        this.chapiHandler.setUpdateLanguageListener(this);
        this.language = FifaResources.getLanguage();
        this.language.addUpdateLanguageListener(this);
        AbstractController.setViewActionListener(this);
        FifaSharedDB.setDBFailureListener(this);
    }

    public void start() {
        if (IOUtility.isMemoryAvailable()) {
            this.model.addModelControllerListener(this);
            this.model.start();
            this.model.updateConfLinks();
        } else {
            Logger.logInfo(this.getClass(), "No memory available at controller startup...");
            DialogsManager.showNoDiskSpaceAlert();
            this.fireControllerShutdown();
        }
    }

    public void viewActionPerformed(Action action) {
        block85: {
            try {
                if (action instanceof ChangeTeamAction) {
                    if (this.model.getMyTeam() != null) {
                        this.model.removeTeamListener(this.model.getMyTeam().getTeamCode(), ViewFactory.getInstance().getMyTeamView());
                    }
                    if (this.model.isTournamentUpdated()) {
                        AbstractController.pushViewOnStack(AbstractController.currentView);
                        AbstractController.setCurrentView(new ChangeTeamView(this.model));
                    } else if (this.isUpdateAuthorized()) {
                        AbstractController.pushViewOnStack(AbstractController.currentView);
                        AbstractController.setCurrentView(new ChangeTeamView(this.model));
                        this.model.updateTournamentContent();
                    } else {
                        AbstractController.currentView.show();
                    }
                    break block85;
                }
                if (action instanceof SelectedTeamAction) {
                    String contryCode = ((SelectedTeamAction)action).getContryCode();
                    if (AbstractController.getViewFromStack(0) instanceof WelcomeView) {
                        ((WelcomeView)AbstractController.getViewFromStack(0)).destroy();
                    }
                    if (this.model.getMyTeam() == null) {
                        this.model.setMyTeam(contryCode);
                        this.doShowStartupView();
                    } else {
                        Team currentTeam = this.model.getMyTeam();
                        if (currentTeam != null && currentTeam.getTeamCode() != null && currentTeam.getTeamCode().equalsIgnoreCase(contryCode)) {
                            this.doShowPreviousView();
                        } else if (this.isUpdateAuthorized()) {
                            this.doChangeTeam(contryCode, true);
                        } else if (this.model.getTeam(contryCode).hasData()) {
                            this.doChangeTeam(contryCode, false);
                        } else {
                            this.doShowPreviousView();
                        }
                    }
                    break block85;
                }
                if (action instanceof SelectedTournamentTeamAction) {
                    String countryCode = ((SelectedTournamentTeamAction)action).getContryCode();
                    if (this.isUpdateAuthorized()) {
                        AbstractController.pushViewOnStack(AbstractController.currentView);
                        AbstractController.setCurrentView(new TeamView(this.model, countryCode));
                        this.model.updateTeam(countryCode);
                    } else {
                        Team team = this.model.getTeam(countryCode);
                        if (team == null || team.getLatestNews() == null) {
                            AbstractController.currentView.show();
                        } else {
                            AbstractController.pushViewOnStack(AbstractController.currentView);
                            AbstractController.setCurrentView(new TeamView(this.model, countryCode));
                            this.model.getTeam(countryCode).simulateUpdateFinished();
                        }
                    }
                    break block85;
                }
                if (action instanceof OpenLinkAction) {
                    PreloadedContent content = (PreloadedContent)this.model.getPreloadedExtras().elementAt(((SelectedAction)action).getIndex());
                    String link = content.getLink();
                    this.doShowBrowser(link);
                    break block85;
                }
                if (action instanceof OpenVideoAction) {
                    PreloadedContent content = (PreloadedContent)this.model.getPreloadedVideos().elementAt(((SelectedAction)action).getIndex());
                    this.doShowVideoPlayerView(content.getLink());
                    break block85;
                }
                if (action instanceof OpenGameExtrasAction) {
                    ChapiService service = new ChapiService(((OpenGameExtrasAction)action).getApplicationId());
                    if (service != null) {
                        new Thread(service).start();
                    }
                    break block85;
                }
                if (action instanceof OpenGameAction) {
                    PreloadedContent content = (PreloadedContent)this.model.getPreloadedExtras().elementAt(((SelectedAction)action).getIndex());
                    if (content.getTitle().indexOf("Panini") != -1) {
                        DialogsManager.showComingSoonAlert();
                        AbstractController.currentView.show();
                    } else if (SystemProperties.getPhonePlatform() == 2) {
                        ChapiService service = new ChapiService(content.getLink());
                        if (service != null) {
                            new Thread(service).start();
                        }
                    } else {
                        new Thread(new RunGameService(content.getLink())).start();
                    }
                    break block85;
                }
                if (action instanceof TeamItemSelectedAction) {
                    ArticleView articleView = new ArticleView(this.model);
                    articleView.updateData(((TeamItemSelectedAction)action).getIndex(), ((TeamItemSelectedAction)action).getTeamCode());
                    AbstractController.pushViewOnStack(AbstractController.currentView);
                    AbstractController.setCurrentView(articleView);
                    break block85;
                }
                if (action instanceof MoreSelectedAction) {
                    AbstractController.pushViewOnStack(AbstractController.currentView);
                    String teamCode = ((MoreSelectedAction)action).getTeamCode();
                    AbstractController.setCurrentView(new MoreNewsView(this.model, teamCode));
                    break block85;
                }
                if (action instanceof MoreExtrasSelected) {
                    AbstractController.pushViewOnStack(AbstractController.currentView);
                    AbstractController.setCurrentView(new MoreExtrasView(this.model));
                    break block85;
                }
                if (action instanceof BackAction) {
                    this.doShowPreviousView();
                    break block85;
                }
                if (action instanceof MinimizeAction) {
                    if (2 == SystemProperties.getPhonePlatform()) {
                        this.doShowPreviousView();
                    } else {
                        SystemProperties.minimizeApplication();
                        Display.getInstance().minimizeApplication();
                    }
                    break block85;
                }
                if (action instanceof NextTabAction) {
                    byte index = ((NextTabAction)action).getIndexView();
                    AbstractController.setCurrentView(ViewFactory.getInstance().getNextTabView(index));
                    if (AbstractController.currentView instanceof MyTeamView) {
                        if (this.model.getMyTeam().getLatestNews() == null) {
                            if (this.model.getMyTeam() != null) {
                                this.setScheduleUpdate();
                            }
                            this.model.updateTeam(this.model.getMyTeam().getTeamCode());
                        }
                    } else if (AbstractController.currentView instanceof TournamentView) {
                        if (!this.model.isTournamentUpdated()) {
                            this.model.updateTournamentContent();
                        }
                    } else if (AbstractController.currentView instanceof EntertaimentView && !this.model.isPreloadedContentUpdated()) {
                        this.model.updatePreloadedContent();
                    }
                    break block85;
                }
                if (action instanceof OptionsAction) {
                    AbstractController.pushViewOnStack(AbstractController.currentView);
                    AbstractController.setCurrentView(new OptionsView(this.model));
                    break block85;
                }
                if (action instanceof AboutLicenseAction) {
                    AbstractController.pushViewOnStack(AbstractController.currentView);
                    AbstractController.setCurrentView(new AboutLicenseView(this.model));
                    break block85;
                }
                if (action instanceof GNULicenseAction) {
                    AbstractController.pushViewOnStack(AbstractController.currentView);
                    AbstractController.setCurrentView(new GNULicenseView(this.model));
                    break block85;
                }
                if (action instanceof WidgetAction) {
                    WidgetAction widget = (WidgetAction)action;
                    if (widget.isHomescreenEnabled() != this.model.isWidgetActivated()) {
                        if (widget.isHomescreenEnabled()) {
                            this.chapiHandler.changeWidgetStatus("startHomescreen", true);
                            UpdateGroup updateGroup = new UpdateGroup(this.model);
                            Thread thread = new Thread(updateGroup);
                            thread.start();
                        } else {
                            this.chapiHandler.changeWidgetStatus("stopHomescreen", true);
                        }
                    }
                    if (widget.isHomeNetworkOnlyEnabled() != this.model.isHomeNetworkOnlyActivated()) {
                        this.model.setHomeNetworkOnlyStatus(widget.isHomeNetworkOnlyEnabled());
                    }
                    break block85;
                }
                if (action instanceof UpgradeAction) {
                    UpgradeAction upgrade = (UpgradeAction)action;
                    boolean isUpgradeOk = false;
                    if (upgrade.getApplicationUpgradeStatus()) {
                        isUpgradeOk = SystemProperties.upgradeApplication(this.chapiHandler);
                    } else if (upgrade.getWidgetUpgradeStatus()) {
                        isUpgradeOk = SystemProperties.upgradeHomeScreen(this.chapiHandler);
                    }
                    if (!isUpgradeOk) {
                        DialogsManager.showUnableUpdateAlert();
                        AbstractController.currentView.show();
                    }
                    break block85;
                }
                if (action instanceof UpdateMyTeamAction) {
                    this.model.getMyTeam().changeToNewData();
                    break block85;
                }
                if (action instanceof UpdateFailureAction) {
                    UpdateFailureAction failure = (UpdateFailureAction)action;
                    this.doHandleFaultOnCurrentView(failure.getReason(), failure.isViewDisplayable());
                    break block85;
                }
                if (action instanceof ShareAction) {
                    String url = ((ShareAction)action).getItem().getLink();
                    try {
                        SystemProperties.platformRequest(FB_SHARE_URL + url);
                    }
                    catch (SecurityException e) {
                        DialogsManager.showNoNetworkConnectionAlert();
                        this.doShowPreviousView();
                    }
                    break block85;
                }
                if (action instanceof ManualUpdateAction) {
                    this.cancelScheduledUpdate();
                    this.update();
                    this.setScheduleUpdate();
                    break block85;
                }
                if (action instanceof ViewArticleAction) {
                    ViewArticleAction articleAction = (ViewArticleAction)action;
                    try {
                        SystemProperties.platformRequest(articleAction.getArticleURL());
                    }
                    catch (ConnectionNotFoundException connectionNotFoundException) {}
                    break block85;
                }
                if (action instanceof OpenExtraVideosAction) {
                    if (this.isUpdateAuthorized()) {
                        AbstractController.pushViewOnStack(AbstractController.currentView);
                        AbstractController.setCurrentView(new ExtraVideosView(this.model));
                        this.model.updateOnlineContentList();
                    } else if (!this.model.isOnlineContentListUpdated()) {
                        AbstractController.currentView.show();
                    } else {
                        AbstractController.pushViewOnStack(AbstractController.currentView);
                        AbstractController.setCurrentView(new ExtraVideosView(this.model));
                    }
                    break block85;
                }
                if (action instanceof ExtraVideoSelectedAction) {
                    OnlineContent content = this.model.getOnlineContent(((ExtraVideoSelectedAction)action).getIndex());
                    if (content == null) break block85;
                    switch (content.getContentStatus()) {
                        case 0: {
                            if (IOUtility.isMemoryAvailable() && IOUtility.isMemoryAvailableInCardOrPhone(content.getFileSize())) {
                                if (this.isUpdateAuthorized(false)) {
                                    content.downloadContent();
                                    break;
                                }
                                break block85;
                            }
                            DialogsManager.showNoDiskSpaceAlert();
                            AbstractController.currentView.show();
                            break;
                        }
                        case 2: {
                            this.doShowVideoPlayerView(content.getPath());
                            break;
                        }
                        default: {
                            Logger.logError(this.getClass(), "Video selected in a unexpected state.");
                            break;
                        }
                    }
                    break block85;
                }
                if (action instanceof FifaWebSiteAction) {
                    String webSite = ((FifaWebSiteAction)action).getFifaWebSite();
                    SystemProperties.platformRequest(webSite);
                }
            }
            catch (ViewException e) {
                this.doShowNoAccessWarning();
            }
            catch (ConnectionNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateLanguage() {
        DialogsManager.showLanguageChangedAlert();
        this.chapiHandler.changeWidgetStatus("stopHomescreen", false);
        this.fireControllerShutdown();
    }

    private void doHandleFaultOnCurrentView(byte reason, boolean viewDisplayable) {
        switch (reason) {
            case 4: {
                DialogsManager.showNoAccessAlert();
                break;
            }
            case 1: {
                DialogsManager.showNoNetworkConnectionAlert();
                break;
            }
            case 2: {
                DialogsManager.showNoDiskSpaceAlert();
                this.fireControllerShutdown();
                break;
            }
            default: {
                Logger.logError(this.getClass(), "doHandleFaultOnCurrentView: unexpected error: " + reason);
            }
        }
        if (viewDisplayable) {
            try {
                AbstractController.currentView.show();
            }
            catch (ViewException e) {
                this.doShowNoAccessWarning();
            }
        } else {
            this.doShowPreviousView();
        }
    }

    private boolean isUpdateAuthorized() {
        return this.isUpdateAuthorized(true);
    }

    private boolean isUpdateAuthorized(boolean checkMemory) {
        boolean authorization = true;
        if (checkMemory) {
            authorization = this.isMemoryAvailable();
        }
        if (authorization && SystemProperties.getPhonePlatform() != 2) {
            boolean bl = authorization = !this.isFlightMode();
        }
        if (authorization) {
            authorization = this.isNetworkingAuthorized();
        }
        if (authorization && this.model.isHomeNetworkOnlyActivated()) {
            authorization = this.isRoamingAuthorized();
        }
        if (SystemProperties.getPhonePlatform() != 3 && SystemProperties.getPhonePlatform() != 0 && authorization && !IOUtility.hasInternetSettings()) {
            authorization = false;
            this.doHandleFaultOnCurrentView((byte)1, true);
        }
        if (authorization) {
            authorization = this.hasNetworkingConnection();
        }
        return authorization;
    }

    private boolean isMemoryAvailable() {
        boolean memoryAvailable = IOUtility.isMemoryAvailable();
        if (!memoryAvailable) {
            DialogsManager.showNoDiskSpaceAlert();
            this.fireControllerShutdown();
        }
        return memoryAvailable;
    }

    private boolean isFlightMode() {
        boolean flightMode = SystemProperties.isFlightMode();
        if (flightMode) {
            DialogsManager.showFlightModeAlert();
            try {
                AbstractController.currentView.show();
            }
            catch (ViewException e) {
                e.printStackTrace();
            }
        }
        return flightMode;
    }

    private boolean isNetworkingAuthorized() {
        boolean auth = this.model.isNetworkingAuthorized();
        if (!auth) {
            byte userAuth = DialogsManager.getNetworkingAuthorization().getAuthorization();
            if (userAuth != 2) {
                auth = true;
            }
            if (userAuth == 0) {
                this.model.setNetworkingAuthorization(true);
            }
            try {
                AbstractController.currentView.show();
            }
            catch (ViewException e) {
                e.printStackTrace();
            }
        }
        return auth;
    }

    private boolean isRoamingAuthorized() {
        if (SystemProperties.isRoaming()) {
            boolean auth = DialogsManager.getRoamingAuthorization();
            try {
                AbstractController.currentView.show();
            }
            catch (ViewException e) {
                e.printStackTrace();
            }
            return auth;
        }
        return true;
    }

    private void doShowPreviousView() {
        try {
            View newView = AbstractController.popViewFromStack();
            AbstractController.setCurrentView(newView);
        }
        catch (EmptyStackException e) {
            this.fireControllerShutdown();
        }
        catch (ViewException e) {
            Logger.logError(this.getClass(), "ViewException: " + e.getMessage());
            this.doShowNoAccessWarning();
        }
    }

    private void doShowNoAccessWarning() {
        DialogsManager.showNoAccessAlert();
        this.doShowPreviousView();
    }

    private void doShowBrowser(String url) {
        try {
            SystemProperties.platformRequest(url);
        }
        catch (ConnectionNotFoundException e) {
            Logger.logError(this.getClass(), "ConnectionNotFoundException: " + e.getMessage());
            AbstractController.pushViewOnStack(AbstractController.currentView);
            this.doShowNoAccessWarning();
        }
    }

    private void doShowVideoPlayerView(String videoPath) {
        int platform = SystemProperties.getPhonePlatform();
        block4 : switch (platform) {
            case 1: {
                int displayHeight = SystemProperties.getDisplayHeight();
                switch (displayHeight) {
                    case 432: {
                        try {
                            AbstractController.pushViewOnStack(AbstractController.currentView);
                            VideoPlayerViewHB209 videoViewHB209 = new VideoPlayerViewHB209(14, this.model);
                            videoViewHB209.startVideo(videoPath);
                            AbstractController.setCurrentView(videoViewHB209);
                        }
                        catch (ViewException e) {
                            Logger.logError(this.getClass(), "ViewException: " + e.getMessage());
                            this.doShowNoAccessWarning();
                        }
                        catch (IOException e) {
                            Logger.logError(this.getClass(), "IOException: " + e.getMessage());
                            this.doShowNoAccessWarning();
                        }
                        catch (VideoPlayerException e) {
                            Logger.logError(this.getClass(), "VideoPlayerException: " + e.getMessage());
                            this.doShowNoAccessWarning();
                        }
                        break block4;
                    }
                }
                try {
                    AbstractController.pushViewOnStack(AbstractController.currentView);
                    VideoPlayerView videoView = new VideoPlayerView(4, this.model);
                    videoView.startVideo(videoPath);
                    AbstractController.setCurrentView(videoView);
                }
                catch (ViewException e) {
                    Logger.logError(this.getClass(), "ViewException: " + e.getMessage());
                    this.doShowNoAccessWarning();
                }
                catch (IOException e) {
                    Logger.logError(this.getClass(), "IOException: " + e.getMessage());
                    this.doShowNoAccessWarning();
                }
                catch (VideoPlayerException e) {
                    Logger.logError(this.getClass(), "VideoPlayerException: " + e.getMessage());
                    this.doShowNoAccessWarning();
                }
                break;
            }
            case 2: {
                try {
                    Logger.logInfo(this.getClass(), "Symbian plat video path: " + videoPath);
                    SystemProperties.platformRequest(videoPath);
                }
                catch (ConnectionNotFoundException e) {
                    Logger.logError(this.getClass(), "ConnectionNotFoundException: " + e.getMessage());
                    AbstractController.pushViewOnStack(AbstractController.currentView);
                    this.doShowNoAccessWarning();
                }
                break;
            }
            default: {
                try {
                    AbstractController.pushViewOnStack(AbstractController.currentView);
                    VideoPlayerView videoView = new VideoPlayerView(4, this.model);
                    videoView.startVideo(videoPath);
                    AbstractController.setCurrentView(videoView);
                    break;
                }
                catch (ViewException e) {
                    Logger.logError(this.getClass(), "ViewException: " + e.getMessage());
                    this.doShowNoAccessWarning();
                    break;
                }
                catch (IOException e) {
                    Logger.logError(this.getClass(), "IOException: " + e.getMessage());
                    this.doShowNoAccessWarning();
                    break;
                }
                catch (VideoPlayerException e) {
                    Logger.logError(this.getClass(), "VideoPlayerException: " + e.getMessage());
                    this.doShowNoAccessWarning();
                }
            }
        }
    }

    public void confLinkReady(byte reason) {
        if (reason == 0) {
            this.model.addTournamentTableListener(this);
            this.model.updateTournamentContent();
        } else {
            Logger.logError(this.getClass(), "confLinkReady, unexpected failure reason: " + reason);
            this.doHandleFaultOnCurrentView(reason, false);
        }
    }

    public void tournamentTableUpdated() {
        this.model.removeTournamentTableListener(this);
        this.model.updateTeamList();
    }

    public void tournamentTableUpdateFailed(byte reason) {
        Logger.logError(this.getClass(), "tournamentTableUpdateFailed, unexpected failure reason: " + reason);
    }

    public void modelReady(byte reason) {
        if (reason == 0) {
            this.model.removeModelControllerListener();
            this.recreateFilesFolder();
            this.doShowStartupView();
        } else {
            Logger.logError(this.getClass(), "modelReady, unexpected failure reason: " + reason);
            this.doHandleFaultOnCurrentView(reason, false);
        }
    }

    private void recreateFilesFolder() {
        if (SystemProperties.getPhonePlatform() == 2) {
            Team myTeam = this.model.getMyTeam();
            String myTeamCode = null;
            if (myTeam != null) {
                myTeamCode = myTeam.getTeamCode();
            }
            if (myTeamCode == null) {
                FeedFileCleaner.getInstance().recreateFilesRootFolder();
            }
        }
    }

    private void removeAllViews() {
        while (!AbstractController.isViewStackEmpty()) {
            View view = AbstractController.popViewFromStack();
            if (!(view instanceof MyTeamView)) continue;
            ((MyTeamView)view).focusFirstItem();
        }
    }

    private void doChangeTeam(String countryCode, boolean update) {
        this.removeAllViews();
        if (this.model.getMyTeam() != null) {
            this.cancelScheduledUpdate();
        }
        this.model.setMyTeam(countryCode);
        ViewFactory.getInstance().getMyTeamView().setFirstUpdate(true);
        try {
            AbstractController.setCurrentView(ViewFactory.getInstance().getMyTeamView());
            if (update) {
                if (this.model.getMyTeam() != null) {
                    this.setScheduleUpdate();
                }
                this.model.updateTeam(countryCode);
                if (this.model.isWidgetActivated()) {
                    this.model.updateGroup();
                }
            } else {
                this.model.getMyTeam().simulateUpdateFinished();
            }
        }
        catch (ViewException e) {
            Logger.logError(this.getClass(), "ViewException: " + e.getMessage());
            this.doShowNoAccessWarning();
        }
    }

    private void doShowStartupView() {
        AbstractController.cleanViewStack();
        try {
            Team myTeam = this.model.getMyTeam();
            String myTeamCode = null;
            if (myTeam != null) {
                myTeamCode = myTeam.getTeamCode();
            }
            if (myTeamCode == null) {
                AbstractController.setCurrentView(new WelcomeView(this.model));
            } else {
                ViewFactory.getInstance().getMyTeamView().setFirstUpdate(true);
                AbstractController.setCurrentView(ViewFactory.getInstance().getMyTeamView());
                boolean authorized = this.isUpdateAuthorized();
                if (this.model.getTeam(myTeamCode).hasData()) {
                    this.model.getTeam(myTeamCode).simulateUpdateFinished();
                }
                if (this.model.isWidgetActivated()) {
                    this.chapiHandler.changeWidgetStatus("startHomescreen", false);
                }
                if (myTeam != null) {
                    this.setScheduleUpdate();
                }
                if (authorized) {
                    this.model.updateTeam(myTeamCode);
                    if (this.model.isWidgetActivated()) {
                        this.model.updateGroup();
                    }
                    if (!ApplicationUpgrade.isUpdateStarted()) {
                        ApplicationUpgrade.start(this.chapiHandler);
                    }
                } else if (myTeam.getLatestNews() == null) {
                    this.fireControllerShutdown();
                }
            }
        }
        catch (ViewException e) {
            Logger.logError(this.getClass(), "Exception: " + e.getMessage());
            this.doShowNoAccessWarning();
        }
    }

    public final void showCurrentView() {
        if (AbstractController.currentView != null) {
            AbstractController.currentView.showNotify();
        }
    }

    public final void pauseCurrentView() {
        if (AbstractController.currentView != null) {
            Display.getInstance().keyReleased(0);
            AbstractController.currentView.pausedNotify();
        }
    }

    private boolean hasNetworkingConnection() {
        boolean hasNet = IOUtility.hasNetworkingConnection();
        if (!hasNet) {
            this.doHandleFaultOnCurrentView((byte)1, true);
        }
        return hasNet;
    }

    public void dbAccessFailed(int reason) {
        if (reason == 1) {
            DialogsManager.showNoDiskSpaceAlert();
            this.fireControllerShutdown();
        }
    }

    public void setScheduleUpdate() {
        if (this.updateTimerTask == null) {
            this.updateTimerTask = new UpdateTimerTask(this);
            this.updateTimerTask.startTimerTask();
        }
    }

    public void cancelScheduledUpdate() {
        if (this.updateTimerTask != null) {
            this.updateTimerTask.cancelTimerTask();
            this.updateTimerTask = null;
        }
    }

    public void update() {
        Team team = this.model.getMyTeam();
        boolean isAuthorized = true;
        this.cancelScheduledUpdate();
        if (this.model.isHomeNetworkOnlyActivated()) {
            isAuthorized = this.isUpdateAuthorized();
            try {
                AbstractController.currentView.show();
            }
            catch (ViewException e) {
                e.printStackTrace();
            }
        }
        if (team != null && isAuthorized) {
            if (this.model.isWidgetActivated()) {
                this.model.updateGroup();
            } else {
                this.model.updateTeam(team.getTeamCode());
            }
        }
        this.setScheduleUpdate();
    }
}

