/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.data;

import com.sonyericsson.fifa.data.Standing;
import java.util.Enumeration;
import java.util.Vector;

public class Group {
    private String groupName;
    private Vector teams = new Vector();
    private Vector standings = new Vector();

    public Group() {
    }

    public Group(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void addTeam(String teamName, Standing standing) {
        if (teamName != null && standing != null) {
            this.teams.addElement(teamName);
            this.standings.addElement(standing);
        }
    }

    public void removeTeam(String teamName) {
        int index;
        if (teamName != null && (index = this.teams.indexOf(teamName)) < this.teams.size()) {
            this.teams.removeElementAt(index);
            this.standings.removeElementAt(index);
        }
    }

    public Standing getTeamStanding(String teamName) {
        Standing standing = null;
        int index = this.teams.indexOf(teamName);
        if (index < this.teams.size()) {
            standing = (Standing)this.standings.elementAt(index);
        }
        return standing;
    }

    public Enumeration getTeamCodes() {
        return this.teams.elements();
    }

    public boolean isTeamInGroup(String teamCode) {
        return this.teams.contains(teamCode);
    }

    public String toString() {
        return this.groupName;
    }
}

