/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.data;

import com.sonyericsson.fifa.data.OnlineContentListener;
import com.sonyericsson.fifa.datastore.AbstractPersistable;
import com.sonyericsson.fifa.exceptions.NoDiskSpaceException;
import com.sonyericsson.fifa.model.AbstractModel;
import com.sonyericsson.fifa.services.downloader.DownloaderListener;
import com.sonyericsson.fifa.services.downloader.http.HttpDownloader;
import com.sonyericsson.fifa.utils.Configuration;
import com.sonyericsson.fifa.utils.FeedUtility;
import com.sonyericsson.fifa.utils.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class OnlineContent
extends AbstractPersistable {
    public static final byte CONTENT_NOT_DOWNLOADED = 0;
    public static final byte CONTENT_DOWNLOADING = 1;
    public static final byte CONTENT_DOWNLOADED = 2;
    private static OnlineContentListener onlineContentListener;
    private String productName = "";
    private String type = "";
    private String title = "";
    private String artist = "";
    private String url = "";
    private String format = "";
    private String path = "";
    private String previewUrl = "";
    private String previewFormat = "";
    private String previewPath = "";
    private int fileSize;
    private String dateAdded = "";
    private int downloadProgress;
    private byte status = 0;
    private byte previewStatus = 0;
    static /* synthetic */ Class class$0;

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getPreviewFormat() {
        return this.previewFormat;
    }

    public void setPreviewFormat(String previewFormat) {
        this.previewFormat = previewFormat;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getArtist() {
        return this.artist;
    }

    public void setArtist(String artist) {
        this.artist = artist;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPreviewUrl() {
        return this.previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public String getPreviewPath() {
        return this.previewPath;
    }

    public void setPreviewPath(String previewPath) {
        this.previewPath = previewPath;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(int fileSize) {
        this.fileSize = fileSize;
    }

    public String getDateAdded() {
        return this.dateAdded;
    }

    public void setDateAdded(String dateAdded) {
        this.dateAdded = dateAdded;
    }

    public int getDownloadProgress() {
        return this.downloadProgress;
    }

    public void setDownloadProgress(int downloadProgress) {
        this.downloadProgress = downloadProgress;
    }

    public static void setOnlineContentListener(OnlineContentListener listener) {
        onlineContentListener = listener;
    }

    public void downloadContent() {
        block2: {
            try {
                this.path = Configuration.getInstance().getFilePathForDownloadableVideo(this.format, this.title, this.fileSize);
                this.download();
            }
            catch (NoDiskSpaceException e) {
                if (onlineContentListener == null) break block2;
                onlineContentListener.updateContent((byte)2, this);
            }
        }
    }

    private void download() {
        Logger.logInfo(this.getClass(), "downloadContent, url: " + this.url + ", file path: " + this.path);
        HttpDownloader download = new HttpDownloader(this.url, this.path);
        download.enableDownloadProgress(true);
        download.addDownloaderListener(new DownloaderListener(){

            public void downloadFailed(byte reason) {
                OnlineContent.this.status = (byte)0;
                OnlineContent.this.downloadProgress = 0;
                if (onlineContentListener != null) {
                    onlineContentListener.updateContent(OnlineContent.this.mapDownloaderError(reason), OnlineContent.this);
                }
            }

            public void downloadFinished(String filePath) {
                OnlineContent.this.status = (byte)2;
                OnlineContent.this.downloadProgress = 100;
                if (onlineContentListener != null) {
                    onlineContentListener.updateContent((byte)0, OnlineContent.this);
                }
            }

            public void downloadProgress(int total, int parcial) {
                OnlineContent.this.status = (byte)1;
                if (total != 0) {
                    OnlineContent.this.downloadProgress = 1 + parcial * 100 / total;
                }
                if (onlineContentListener != null) {
                    onlineContentListener.updateContent((byte)8, OnlineContent.this);
                }
            }
        });
        this.downloadProgress = 1;
        if (onlineContentListener != null) {
            onlineContentListener.updateContent((byte)8, this);
        }
        AbstractModel.addDownloadVideoTask(download);
    }

    public void downloadPreview() {
        String previewFilePath = FeedUtility.getInstance().getFilePathForPreviewThumbnails(this.previewUrl, this.previewFormat);
        if (previewFilePath != null) {
            HttpDownloader download = new HttpDownloader(this.previewUrl, previewFilePath);
            download.addDownloaderListener(new DownloaderListener(){

                public void downloadFailed(byte reason) {
                    OnlineContent.this.previewStatus = (byte)0;
                }

                public void downloadFinished(String filePath) {
                    OnlineContent.this.previewPath = filePath;
                    OnlineContent.this.previewStatus = (byte)2;
                    if (onlineContentListener != null) {
                        onlineContentListener.updateContent((byte)0, OnlineContent.this);
                    }
                }

                public void downloadProgress(int total, int parcial) {
                    OnlineContent.this.previewStatus = (byte)1;
                }
            });
            AbstractModel.addDownloadEnclosureTask(download);
        }
    }

    private byte mapDownloaderError(byte downloaderFailureReason) {
        byte modelReason = 4;
        switch (downloaderFailureReason) {
            case 1: {
                modelReason = 1;
                break;
            }
            case 4: {
                modelReason = 1;
                break;
            }
            case 2: {
                modelReason = 2;
                break;
            }
            default: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.data.Team");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logError(clazz, "onlineContent Dowload failed.");
                Logger.logError(this.getClass(), "Downloader failed, unexpected reason: " + downloaderFailureReason);
            }
        }
        return modelReason;
    }

    public byte getContentStatus() {
        return this.status;
    }

    public byte getPreviewStatus() {
        return this.previewStatus;
    }

    public void setContentStatus(byte status) {
        this.status = status;
    }

    public void setPreviewContentStatus(byte status) {
        this.previewStatus = status;
    }

    public void loadFromByteArray(byte[] data) {
        block13: {
            if (data != null) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(data));
                try {
                    try {
                        this.productName = dataInputStream.readUTF();
                        this.type = dataInputStream.readUTF();
                        this.title = dataInputStream.readUTF();
                        this.artist = dataInputStream.readUTF();
                        this.url = dataInputStream.readUTF();
                        this.format = dataInputStream.readUTF();
                        this.path = dataInputStream.readUTF();
                        this.previewUrl = dataInputStream.readUTF();
                        this.previewFormat = dataInputStream.readUTF();
                        this.previewPath = dataInputStream.readUTF();
                        this.previewStatus = dataInputStream.readByte();
                        this.fileSize = dataInputStream.readInt();
                        this.dateAdded = dataInputStream.readUTF();
                        this.downloadProgress = dataInputStream.readInt();
                        this.status = dataInputStream.readByte();
                    }
                    catch (IOException ignored) {
                        ignored.printStackTrace();
                        if (dataInputStream == null) break block13;
                        try {
                            dataInputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    if (dataInputStream != null) {
                        try {
                            dataInputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    public byte[] toByteArray() {
        byte[] data;
        block12: {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(baos);
            data = null;
            try {
                try {
                    dataOutputStream.writeUTF(this.productName);
                    dataOutputStream.writeUTF(this.type);
                    dataOutputStream.writeUTF(this.title);
                    dataOutputStream.writeUTF(this.artist);
                    dataOutputStream.writeUTF(this.url);
                    dataOutputStream.writeUTF(this.format);
                    dataOutputStream.writeUTF(this.path);
                    dataOutputStream.writeUTF(this.previewUrl);
                    dataOutputStream.writeUTF(this.previewFormat);
                    dataOutputStream.writeUTF(this.previewPath);
                    dataOutputStream.writeByte(this.previewStatus);
                    dataOutputStream.writeInt(this.fileSize);
                    dataOutputStream.writeUTF(this.dateAdded);
                    dataOutputStream.writeInt(this.downloadProgress);
                    dataOutputStream.writeByte(this.status);
                    dataOutputStream.flush();
                    data = baos.toByteArray();
                }
                catch (IOException ignored) {
                    ignored.printStackTrace();
                    if (dataOutputStream == null) break block12;
                    try {
                        dataOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (dataOutputStream != null) {
                    try {
                        dataOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return data;
    }
}

