/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.data;

import com.sonyericsson.fifa.data.feed.Enclosure;
import com.sonyericsson.fifa.data.feed.Feed;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.data.feed.FeedListener;
import com.sonyericsson.fifa.datastore.FeedDB;
import com.sonyericsson.fifa.datastore.TeamLatestNewsDB;
import com.sonyericsson.fifa.datastore.storeobject.TeamLatestNews;
import com.sonyericsson.fifa.model.AbstractModel;
import com.sonyericsson.fifa.model.teamList.TeamListener;
import com.sonyericsson.fifa.services.parser.ParserListener;
import com.sonyericsson.fifa.services.parser.sax.SaxParser;
import com.sonyericsson.fifa.services.parser.sax.handler.RssHandler;
import com.sonyericsson.fifa.utils.FeedFileCleaner;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import java.util.Vector;

public class Team {
    private String teamCode;
    private int numberOfTweets;
    private Feed newLatestNews;
    private int numberOfItemsNew;
    private Feed latestNews;
    private String feedUrl;
    private Vector listeners = new Vector();
    private String tempItemFeedPubDate = null;
    private int thumbdownloadfailedreason = 0;
    private int INIT_STATE = 0;
    private int UPDATING_TEAM_NEWS = 1;
    private int UPDATED_TEAM_WITH_NEW_ITEMS = 2;
    private int UPDATED_TEAM_WITHOUT_NEW_ITEMS = 3;
    private int currentState = this.INIT_STATE;
    private boolean updatingRMS = false;
    private boolean updateAllowed = true;
    static /* synthetic */ Class class$0;

    public Team() {
    }

    public Team(String code, String feedUrl) {
        this.teamCode = code;
        this.feedUrl = feedUrl;
        this.loadData();
    }

    private void loadData() {
        FeedDB feedDB;
        Feed feed;
        TeamLatestNewsDB latestNewsDB = new TeamLatestNewsDB(this.teamCode);
        TeamLatestNews latestNews = latestNewsDB.retrieveLatestNews();
        if (latestNews.getLastItemPubDateToUse() != null && (feed = (feedDB = new FeedDB(this.teamCode)).retrieveFeed()) != null) {
            feed.setLastItemPubDate(latestNews.getLastItemPubDateToUse());
            this.setLatestNews(feed);
        }
    }

    public boolean hasData() {
        return this.latestNews != null;
    }

    public String getTeamCode() {
        return this.teamCode;
    }

    public int getNumberOfTweets() {
        return this.numberOfTweets;
    }

    public void setNumberOfTweets(int numberOfTweets) {
        this.numberOfTweets = numberOfTweets;
    }

    public Feed getLatestNews() {
        return this.latestNews;
    }

    public void setLatestNews(Feed latestNews) {
        if (this.latestNews == null) {
            this.latestNews = latestNews;
        } else if (latestNews.getItems().size() > 0) {
            int numberOfLatests = latestNews.getItems().size();
            if (this.latestNews.getItems().size() <= numberOfLatests) {
                this.latestNews = latestNews;
            } else {
                Vector currentItems = this.latestNews.getItems();
                int i = 0;
                while (i < numberOfLatests) {
                    currentItems.removeElementAt(currentItems.size() - 1);
                    ++i;
                }
                this.latestNews = latestNews;
                i = 0;
                while (i < currentItems.size()) {
                    this.latestNews.getItems().addElement(currentItems.elementAt(i));
                    ++i;
                }
            }
        }
    }

    public String getFeedUrl() {
        return this.feedUrl;
    }

    public void setFeedUrl(String feedUrl) {
        this.feedUrl = feedUrl;
    }

    public void setTeamCode(String teamCode) {
        this.teamCode = teamCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLatestNews() {
        Team team = this;
        synchronized (team) {
            this.thumbdownloadfailedreason = 0;
        }
        final RssHandler handler = new RssHandler();
        String lastItemPubDateToUse = null;
        if (!this.isTeamNewsUpdating()) {
            if (this.latestNews != null) {
                lastItemPubDateToUse = this.latestNews.getLastItemPubDate();
                Logger.logInfo(this.getClass(), "ITEMS SIZE = " + this.latestNews.getItems().size());
            }
            if (lastItemPubDateToUse != null) {
                handler.setLastItemPubDate(lastItemPubDateToUse);
            }
            SaxParser parser = new SaxParser(this.getFeedUrl(), handler);
            handler.setItemsToParse(25);
            ParserListener listener = new ParserListener(){

                public void parserFinished() {
                    int itemsSize = handler.getParsedFeed().getItems().size();
                    if (handler.getParsedFeed() != null && itemsSize > 0) {
                        if (Team.this.latestNews == null) {
                            Team.this.setLatestNews(handler.getParsedFeed());
                            Team.this.currentState = Team.this.INIT_STATE;
                            Team.this.fireTeamUpdateFinished(true);
                            if (Team.this.updateAllowed) {
                                Team.this.downloadThumbnails(itemsSize);
                                Team.this.updatingRMS = true;
                                TeamLatestNews ln = new TeamLatestNews();
                                ln.setLastItemPubDateToUse(handler.getParsedFeed().getLastItemPubDate());
                                TeamLatestNewsDB latestNewsDB = new TeamLatestNewsDB(Team.this.teamCode);
                                latestNewsDB.saveLatestNews(ln);
                                FeedDB feedDB = new FeedDB(Team.this.teamCode);
                                feedDB.saveFeed(handler.getParsedFeed());
                                Team.this.updatingRMS = false;
                            }
                        } else {
                            if (Team.this.tempItemFeedPubDate == null) {
                                Team.this.tempItemFeedPubDate = Team.this.getLatestNews().getLastItemPubDate();
                            }
                            Team.this.numberOfItemsNew = itemsSize;
                            Team.this.setNewLatestNews(handler.getParsedFeed());
                            Team.this.currentState = Team.this.UPDATED_TEAM_WITH_NEW_ITEMS;
                            Team.this.fireTeamUpdateFinished(true);
                            if (Team.this.updateAllowed) {
                                Team.this.downloadThumbnails(25);
                            }
                        }
                    } else {
                        if (Team.this.currentState != Team.this.UPDATED_TEAM_WITH_NEW_ITEMS || Team.this.tempItemFeedPubDate == null && Team.this.tempItemFeedPubDate == null) {
                            Team.this.currentState = Team.this.UPDATED_TEAM_WITHOUT_NEW_ITEMS;
                        }
                        Team.this.fireTeamUpdateFinished(false);
                        if (Team.this.updateAllowed) {
                            Team.this.downloadThumbnails(25);
                        }
                    }
                }

                public void parserFailed(byte reason) {
                    if (Team.this.currentState != Team.this.UPDATED_TEAM_WITH_NEW_ITEMS || Team.this.tempItemFeedPubDate == null && Team.this.tempItemFeedPubDate == null) {
                        Team.this.currentState = Team.this.UPDATED_TEAM_WITHOUT_NEW_ITEMS;
                    }
                    switch (reason) {
                        case 1: {
                            Team.this.fireTeamUpdateFailed((byte)1);
                            break;
                        }
                        case 2: {
                            Team.this.fireTeamUpdateFailed((byte)4);
                            break;
                        }
                        default: {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.data.Team");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Logger.logError(clazz, "updateLatestNews failed.");
                            Logger.logError(this.getClass(), "Parser failed, unexpected reason: " + reason);
                            Team.this.fireTeamUpdateFailed((byte)4);
                        }
                    }
                }
            };
            parser.addParserListener(listener);
            this.currentState = this.UPDATING_TEAM_NEWS;
            AbstractModel.addFeedsParserTask(parser);
            this.fireTeamUpdateStarted();
        }
    }

    public boolean isTeamNewsUpdating() {
        return this.currentState == this.UPDATING_TEAM_NEWS;
    }

    public boolean isTeamNewsUpdatedWithNewItems() {
        return this.newLatestNews != null;
    }

    private void saveItem(int index) {
        FeedItem item = (FeedItem)this.latestNews.getItems().elementAt(index);
        if (item != null) {
            this.updatingRMS = true;
            FeedDB feedDB = new FeedDB(this.teamCode);
            feedDB.saveFeedItem(item);
            this.updatingRMS = false;
        }
    }

    public boolean isUpdatingRMS() {
        return this.updatingRMS;
    }

    public void stopUpdatingRMS() {
        this.updateAllowed = false;
    }

    private void downloadThumbnails(int numberOfItems) {
        if (this.latestNews != null) {
            this.latestNews.addFeedListener(FeedFileCleaner.getInstance());
            this.latestNews.addFeedListener(new FeedListener(){

                public void enclosureDownloaded(int index, Enclosure enclosure) {
                    Team.this.fireThumbnailDownloaded(index, enclosure);
                    Team.this.saveItem(index);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void enclosureDownloadFailed(int index, byte reason) {
                    2 var3_3 = this;
                    synchronized (var3_3) {
                        byte modelReason = 0;
                        switch (reason) {
                            case 1: {
                                modelReason = 1;
                                break;
                            }
                            case 4: {
                                modelReason = 1;
                                break;
                            }
                            case 2: {
                                modelReason = 2;
                                break;
                            }
                            default: {
                                Logger.logError(this.getClass(), "enclosureDownloadFailed, unexpected reason: " + reason);
                                modelReason = 4;
                            }
                        }
                        if ((Team.this.thumbdownloadfailedreason & modelReason) == 0) {
                            Team.this.fireTeamUpdateFailed(modelReason);
                            Team team = Team.this;
                            team.thumbdownloadfailedreason = team.thumbdownloadfailedreason | modelReason;
                        }
                    }
                }
            });
            this.latestNews.downloadEnclosures(this.getTeamCode(), numberOfItems);
        }
    }

    public void addTeamListener(TeamListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeTeamListener(TeamListener listener) {
        this.listeners.removeElement(listener);
    }

    public void simulateUpdateFinished() {
        this.fireTeamUpdateFinished(true);
    }

    private void fireTeamUpdateFinished(boolean newItemsAvailable) {
        int i = 0;
        while (i < this.listeners.size()) {
            TeamListener listener = (TeamListener)this.listeners.elementAt(i);
            listener.teamUpdateFinished(newItemsAvailable, this.teamCode);
            ++i;
        }
    }

    private void fireTeamUpdateStarted() {
        int i = 0;
        while (i < this.listeners.size()) {
            TeamListener listener = (TeamListener)this.listeners.elementAt(i);
            listener.teamUpdateStarted();
            ++i;
        }
    }

    private void fireTeamUpdateFailed(byte reason) {
        int i = 0;
        while (i < this.listeners.size()) {
            TeamListener listener = (TeamListener)this.listeners.elementAt(i);
            listener.teamUpdateFailed(reason);
            ++i;
        }
    }

    private void fireThumbnailDownloaded(int index, Enclosure thumbnail) {
        int i = 0;
        while (i < this.listeners.size()) {
            TeamListener listener = (TeamListener)this.listeners.elementAt(i);
            listener.thumbnailDownloaded(index, thumbnail);
            ++i;
        }
    }

    public void update() {
        if (IOUtility.isMemoryAvailable()) {
            this.updateLatestNews();
        } else {
            this.fireTeamUpdateFailed((byte)2);
        }
    }

    public String toString() {
        return "TeamCode: " + this.teamCode + ", LatestNewsUrl: " + this.feedUrl;
    }

    public Feed getNewLatestNews() {
        return this.newLatestNews;
    }

    public void setNewLatestNews(Feed newLatestNews) {
        this.newLatestNews = newLatestNews;
    }

    public void changeToNewData() {
        this.currentState = this.INIT_STATE;
        if (this.newLatestNews != null) {
            this.setLatestNews(this.newLatestNews);
            TeamLatestNews ln = new TeamLatestNews();
            ln.setLastItemPubDateToUse(this.newLatestNews.getLastItemPubDate());
            TeamLatestNewsDB latestNewsDB = new TeamLatestNewsDB(this.teamCode);
            latestNewsDB.saveLatestNews(ln);
            FeedDB feedDB = new FeedDB(this.teamCode);
            feedDB.saveFeed(this.latestNews);
            this.fireTeamUpdateFinished(true);
            this.downloadThumbnails(this.numberOfItemsNew);
            this.setNewLatestNews(null);
            this.tempItemFeedPubDate = null;
            this.numberOfItemsNew = -1;
        }
    }
}

