/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.data.feed;

import com.sonyericsson.fifa.data.feed.Enclosure;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.data.feed.FeedListener;
import com.sonyericsson.fifa.model.AbstractModel;
import com.sonyericsson.fifa.services.downloader.DownloaderListener;
import com.sonyericsson.fifa.services.downloader.http.HttpDownloader;
import com.sonyericsson.fifa.utils.FeedUtility;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.attributes.VerifyScreenDimension;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.media.MediaException;

public class Feed {
    private final Vector items = new Vector();
    private int timeToLive;
    private String lastItemPubDate;
    private final Vector listeners = new Vector();
    static /* synthetic */ Class class$0;

    public Vector getItems() {
        return this.items;
    }

    public void addItem(FeedItem pItem) {
        this.getItems().addElement(pItem);
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int ptimeToLive) {
        this.timeToLive = ptimeToLive;
    }

    public String toString() {
        StringBuffer feed = new StringBuffer();
        feed.append("<Feed> TimeToLive: ");
        feed.append(this.timeToLive);
        feed.append("\n");
        if (this.items != null) {
            int size = this.items.size();
            feed.append("<Feed> Nuber of items: ");
            feed.append(size);
            feed.append("\n");
            int i = 0;
            while (i < size) {
                FeedItem item;
                if (this.items.elementAt(i) instanceof FeedItem && (item = (FeedItem)this.items.elementAt(i)) != null) {
                    feed.append("<FeedItem ");
                    feed.append(i);
                    feed.append(" > ");
                    feed.append(item.toString());
                    feed.append("\n");
                }
                ++i;
            }
        } else {
            feed.append("<Feed> Nuber of items: 0\n");
        }
        return feed.toString();
    }

    public void downloadEnclosures(String teamCode, int numberOfItems) {
        if (this.items != null && !this.items.isEmpty()) {
            int i = 0;
            while (i < numberOfItems) {
                FeedItem item = (FeedItem)this.items.elementAt(i);
                if (item != null) {
                    this.downloadEnclosure(i, item.getEnclosure(), teamCode);
                }
                ++i;
            }
        }
    }

    private void downloadEnclosure(final int index, final Enclosure enclosure, String teamCode) {
        if (enclosure != null && enclosure.getUrl() != null && !enclosure.getEnclosureDownloaded()) {
            Logger.logInfo(this.getClass(), "downloadEnclosure: " + enclosure.getUrl());
            HttpDownloader downloader = new HttpDownloader(enclosure.getUrl(), FeedUtility.getInstance().getFilePathForDownload(enclosure.getUrl(), teamCode));
            DownloaderListener listener = new DownloaderListener(){

                public void downloadFailed(byte reason) {
                    switch (reason) {
                        case 1: {
                            Feed.this.fireEnclosureDownloadFailed(index, (byte)1);
                            break;
                        }
                        case 4: {
                            Feed.this.fireEnclosureDownloadFailed(index, (byte)4);
                            break;
                        }
                        case 2: {
                            Feed.this.fireEnclosureDownloadFailed(index, (byte)2);
                        }
                        default: {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("com.sonyericsson.fifa.data.feed.Feed");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Logger.logError(clazz, "downloadEnclosure failed.");
                            Logger.logError(this.getClass(), "downloader failed, unexpected reason: " + reason);
                            Feed.this.fireEnclosureDownloadFailed(index, (byte)4);
                        }
                    }
                }

                public void downloadFinished(String filePath) {
                    enclosure.setPath(filePath);
                    enclosure.setEnclosureDownloaded(true);
                    try {
                        String thumbPath = FeedUtility.getInstance().getFilePathForThumbnail(filePath);
                        IOUtility.resizeImage(filePath, thumbPath, VerifyScreenDimension.getAttributesInstance().getThumbnailWidth(), VerifyScreenDimension.getAttributesInstance().getThumbnailHeight());
                        enclosure.setThumbPath(thumbPath);
                    }
                    catch (IOException e) {
                        Logger.logError(this.getClass(), "IOExcetion to resize image: " + e.getMessage());
                    }
                    catch (MediaException e) {
                        Logger.logError(this.getClass(), "MediaException to resize image: " + e.getMessage());
                    }
                    Feed.this.fireEnclosureDownloaded(index, enclosure);
                }

                public void downloadProgress(int total, int parcial) {
                }
            };
            downloader.addDownloaderListener(listener);
            AbstractModel.addDownloadEnclosureTask(downloader);
        }
    }

    public void addFeedListener(FeedListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeFeedListener(FeedListener listener) {
        this.listeners.removeElement(listener);
    }

    private void fireEnclosureDownloaded(int index, Enclosure enclosure) {
        int i = 0;
        while (i < this.listeners.size()) {
            FeedListener listener = (FeedListener)this.listeners.elementAt(i);
            listener.enclosureDownloaded(index, enclosure);
            ++i;
        }
    }

    private void fireEnclosureDownloadFailed(int index, byte reason) {
        int i = 0;
        while (i < this.listeners.size()) {
            FeedListener listener = (FeedListener)this.listeners.elementAt(i);
            listener.enclosureDownloadFailed(index, reason);
            ++i;
        }
    }

    public String getLastItemPubDate() {
        return this.lastItemPubDate;
    }

    public void setLastItemPubDate(String lastItemPubDate) {
        this.lastItemPubDate = lastItemPubDate;
    }

    public FeedItem getItemByTitle(String titleText) {
        FeedItem itemFound = null;
        int itemVetSize = this.items.size();
        int i = 0;
        while (i < itemVetSize) {
            FeedItem item = (FeedItem)this.items.elementAt(i);
            if (item.getTitle().compareTo(titleText) == 0) {
                itemFound = item;
                break;
            }
            ++i;
        }
        return itemFound;
    }
}

