/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.data.feed;

import com.sonyericsson.fifa.data.feed.Enclosure;
import com.sonyericsson.fifa.datastore.AbstractPersistable;
import com.sonyericsson.fifa.utils.FeedUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FeedItem
extends AbstractPersistable {
    private String title = "";
    private String description = "";
    private String link = "";
    private Enclosure enclosure;
    private String teamCode;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public Enclosure getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(Enclosure enclosure) {
        this.enclosure = enclosure;
    }

    public String toString() {
        String item = "";
        item = String.valueOf(item) + "<ItemTitle> " + this.title;
        item = String.valueOf(item) + "<ItemDescription> " + this.description;
        item = this.enclosure == null ? String.valueOf(item) + "No enclosure" : String.valueOf(item) + this.enclosure.toString();
        return item;
    }

    public void setTeamCode(String teamCode) {
        this.teamCode = teamCode;
    }

    public byte[] toByteArray() {
        byte[] data;
        block12: {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(baos);
            data = null;
            try {
                try {
                    dataOutputStream.writeUTF(this.title);
                    dataOutputStream.writeUTF(this.description);
                    dataOutputStream.writeUTF(this.link);
                    dataOutputStream.writeUTF(this.enclosure.getUrl());
                    String enclosurePath = FeedUtility.getInstance().getFilePathForDownload(this.enclosure.getUrl(), this.teamCode);
                    dataOutputStream.writeUTF(enclosurePath);
                    String thumbnailPath = FeedUtility.getInstance().getFilePathForThumbnail(enclosurePath);
                    dataOutputStream.writeUTF(thumbnailPath);
                    dataOutputStream.writeUTF(this.enclosure.getMimeType());
                    dataOutputStream.writeBoolean(this.enclosure.getEnclosureDownloaded());
                    dataOutputStream.flush();
                    data = baos.toByteArray();
                }
                catch (IOException ignored) {
                    ignored.printStackTrace();
                    if (dataOutputStream == null) break block12;
                    try {
                        dataOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (dataOutputStream != null) {
                    try {
                        dataOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return data;
    }

    public void loadFromByteArray(byte[] data) {
        block13: {
            if (data != null) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(data));
                try {
                    try {
                        this.title = dataInputStream.readUTF();
                        this.description = dataInputStream.readUTF();
                        this.link = dataInputStream.readUTF();
                        this.enclosure = new Enclosure();
                        this.enclosure.setUrl(dataInputStream.readUTF());
                        this.enclosure.setPath(dataInputStream.readUTF());
                        this.enclosure.setThumbPath(dataInputStream.readUTF());
                        this.enclosure.setMimeType(dataInputStream.readUTF());
                        this.enclosure.setEnclosureDownloaded(dataInputStream.readBoolean());
                    }
                    catch (IOException ignored) {
                        ignored.printStackTrace();
                        if (dataInputStream == null) break block13;
                        try {
                            dataInputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                finally {
                    if (dataInputStream != null) {
                        try {
                            dataInputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

