/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.datastore;

import com.sonyericsson.fifa.data.feed.Feed;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.datastore.FifaSharedDB;
import java.util.Vector;
import javax.microedition.rms.RecordStore;

public class FeedDB
extends FifaSharedDB {
    private static final String SUFIX_STORE_NAME = "_NEWS";
    private String storeName;
    private String teamCode;

    protected String getDBName() {
        return this.storeName;
    }

    public FeedDB(String teamCode) {
        this.teamCode = teamCode;
        this.storeName = String.valueOf(teamCode) + SUFIX_STORE_NAME;
    }

    public boolean saveFeed(Feed feed) {
        boolean result = false;
        if (feed != null) {
            result = true;
            Vector feedItems = feed.getItems();
            int i = 0;
            while (i < feedItems.size()) {
                ((FeedItem)feedItems.elementAt(i)).setTeamCode(this.teamCode);
                ++i;
            }
            result = this.saveAll(feedItems, false);
        }
        return result;
    }

    public boolean saveFeedItem(FeedItem item) {
        return this.saveRecord(item, false);
    }

    public Feed retrieveFeed() {
        Feed feed = null;
        Vector records = this.retrieveAll(false);
        if (records != null && records.size() == 25) {
            feed = new Feed();
            int i = 0;
            while (i < records.size()) {
                byte[] data = (byte[])records.elementAt(i);
                FeedItem feedItem = new FeedItem();
                feedItem.loadFromByteArray(data);
                feed.addItem(feedItem);
                ++i;
            }
        } else {
            this.deleteAllRecords();
        }
        return feed;
    }

    public boolean deleteAllRecords() {
        return this.deleteAll(false);
    }

    public static Vector retrieveTeamsWithFeeds() {
        String[] list = RecordStore.listRecordStores();
        Vector<String> teams = new Vector<String>();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                if (list[i].endsWith(SUFIX_STORE_NAME)) {
                    teams.addElement(list[i].substring(0, list[i].indexOf(SUFIX_STORE_NAME)));
                }
                ++i;
            }
        }
        return teams;
    }
}

