/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.datastore;

import com.sonyericsson.fifa.datastore.DBFailureListener;
import com.sonyericsson.fifa.datastore.Persistable;
import java.util.Vector;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public abstract class FifaSharedDB {
    private static final int FIRST_RECORD = 1;
    private static DBFailureListener dbFailureListener;

    protected abstract String getDBName();

    public static void setDBFailureListener(DBFailureListener listener) {
        dbFailureListener = listener;
    }

    private static void fireDBAccessFailure(int reason) {
        if (dbFailureListener != null) {
            dbFailureListener.dbAccessFailed(reason);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean save(Persistable persistable, boolean writable) {
        RecordStore recordStore = null;
        boolean result = true;
        try {
            try {
                recordStore = RecordStore.openRecordStore((String)this.getDBName(), (boolean)true, (int)1, (boolean)writable);
                byte[] data = persistable.toByteArray();
                if (recordStore.getNumRecords() > 0 && data != null) {
                    recordStore.setRecord(1, data, 0, data.length);
                    return result;
                } else {
                    if (data == null) return result;
                    recordStore.addRecord(data, 0, data.length);
                    return result;
                }
            }
            catch (RecordStoreFullException e) {
                result = false;
                FifaSharedDB.fireDBAccessFailure(1);
                if (recordStore == null) return result;
                try {
                    recordStore.closeRecordStore();
                    return result;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return result;
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
                FifaSharedDB.fireDBAccessFailure(0);
                if (recordStore == null) return result;
                try {
                    recordStore.closeRecordStore();
                    return result;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                return result;
            }
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean saveAll(Vector persistables, boolean writable) {
        this.deleteAll(writable);
        RecordStore recordStore = null;
        boolean result = true;
        try {
            try {
                recordStore = RecordStore.openRecordStore((String)this.getDBName(), (boolean)true, (int)1, (boolean)writable);
                int i = 0;
                while (i < persistables.size()) {
                    Persistable persistable = (Persistable)persistables.elementAt(i);
                    byte[] data = persistable.toByteArray();
                    int recordId = recordStore.addRecord(data, 0, data.length);
                    persistable.setRecordId(recordId);
                    ++i;
                }
                return result;
            }
            catch (RecordStoreFullException e) {
                result = false;
                FifaSharedDB.fireDBAccessFailure(1);
                if (recordStore == null) return result;
                try {
                    recordStore.closeRecordStore();
                    return result;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return result;
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
                FifaSharedDB.fireDBAccessFailure(0);
                if (recordStore == null) return result;
                try {
                    recordStore.closeRecordStore();
                    return result;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                return result;
            }
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean saveRecord(Persistable persistable, boolean writable) {
        RecordStore recordStore = null;
        boolean result = true;
        try {
            try {
                if (persistable.getRecordId() == -1) return result;
                recordStore = RecordStore.openRecordStore((String)this.getDBName(), (boolean)true, (int)1, (boolean)writable);
                byte[] data = persistable.toByteArray();
                recordStore.setRecord(persistable.getRecordId(), data, 0, data.length);
                return result;
            }
            catch (RecordStoreFullException e) {
                result = false;
                persistable.setRecordId(-1);
                FifaSharedDB.fireDBAccessFailure(1);
                if (recordStore == null) return result;
                try {
                    recordStore.closeRecordStore();
                    return result;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return result;
            }
            catch (Exception e) {
                result = false;
                persistable.setRecordId(-1);
                e.printStackTrace();
                FifaSharedDB.fireDBAccessFailure(0);
                if (recordStore == null) return result;
                try {
                    recordStore.closeRecordStore();
                    return result;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                return result;
            }
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected byte[] retrieve(boolean writable) {
        byte[] data = this.retrieve(1, writable);
        return data;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] retrieve(int index, boolean writable) {
        RecordStore recordStore = null;
        byte[] data = null;
        try {
            try {
                recordStore = RecordStore.openRecordStore((String)this.getDBName(), (boolean)true, (int)1, (boolean)writable);
                if (recordStore.getNumRecords() <= 0) return data;
                data = recordStore.getRecord(index);
                return data;
            }
            catch (RecordStoreFullException e) {
                FifaSharedDB.fireDBAccessFailure(1);
                if (recordStore == null) return data;
                try {
                    recordStore.closeRecordStore();
                    return data;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return data;
            }
            catch (RecordStoreNotFoundException e) {
                if (recordStore == null) return data;
                try {
                    recordStore.closeRecordStore();
                    return data;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                return data;
            }
            catch (Exception e) {
                e.printStackTrace();
                FifaSharedDB.fireDBAccessFailure(0);
                if (recordStore == null) return data;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    recordStore.closeRecordStore();
                    return data;
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
                return data;
            }
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Vector retrieveAll(boolean writable) {
        RecordStore recordStore = null;
        Vector<byte[]> records = new Vector<byte[]>();
        try {
            try {
                int startIndex;
                recordStore = RecordStore.openRecordStore((String)this.getDBName(), (boolean)true, (int)1, (boolean)writable);
                int numberOfRecords = recordStore.getNumRecords();
                int nextRecordId = recordStore.getNextRecordID();
                int i = startIndex = nextRecordId - numberOfRecords;
                while (i <= nextRecordId - 1) {
                    byte[] data = recordStore.getRecord(i);
                    records.addElement(data);
                    ++i;
                }
                return records;
            }
            catch (RecordStoreFullException e) {
                FifaSharedDB.fireDBAccessFailure(1);
                if (recordStore == null) return records;
                try {
                    recordStore.closeRecordStore();
                    return records;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return records;
            }
            catch (RecordStoreNotFoundException e) {
                if (recordStore == null) return records;
                try {
                    recordStore.closeRecordStore();
                    return records;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                return records;
            }
            catch (Exception e) {
                e.printStackTrace();
                FifaSharedDB.fireDBAccessFailure(0);
                if (recordStore == null) return records;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    recordStore.closeRecordStore();
                    return records;
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
                return records;
            }
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean deleteAll(boolean writable) {
        RecordStore recordStore = null;
        int numberOfRecords = 0;
        boolean result = true;
        try {
            try {
                recordStore = RecordStore.openRecordStore((String)this.getDBName(), (boolean)true, (int)1, (boolean)writable);
                numberOfRecords = recordStore.getNumRecords();
                int i = 1;
                while (i <= numberOfRecords) {
                    recordStore.deleteRecord(recordStore.getNextRecordID() - i);
                    ++i;
                }
                return result;
            }
            catch (RecordStoreFullException e) {
                result = false;
                FifaSharedDB.fireDBAccessFailure(1);
                if (recordStore == null) return result;
                try {
                    recordStore.closeRecordStore();
                    return result;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return result;
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
                FifaSharedDB.fireDBAccessFailure(0);
                if (recordStore == null) return result;
                try {
                    recordStore.closeRecordStore();
                    return result;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                }
                return result;
            }
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void deleteRecordStore() {
        try {
            RecordStore.deleteRecordStore((String)this.getDBName());
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }
}

