/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.midlet;

import com.sonyericsson.fifa.controller.ChapiHandler;
import com.sonyericsson.fifa.controller.FifaController;
import com.sonyericsson.fifa.model.FifaModel;
import com.sonyericsson.fifa.utils.SystemProperties;
import com.sonyericsson.fifa.view.ViewFactory;
import com.sonyericsson.fifa.view.components.FifaLookAndFeelManager;
import com.sonyericsson.fifa.view.dialogs.DialogsManager;
import com.sun.lwuit.Display;
import com.sun.lwuit.plaf.DefaultLookAndFeel;
import com.sun.lwuit.plaf.UIManager;
import javax.microedition.midlet.MIDlet;

public class ObjectFactory {
    private FifaController controllerImp;
    private FifaModel modelImp;
    private MIDlet midlet;
    private ChapiHandler chapiHandlerImp;

    public ObjectFactory(MIDlet midlet) {
        this.midlet = midlet;
        this.initializeLwuit();
        SystemProperties.initialize(this.midlet);
    }

    public final FifaController getControllerImp() {
        if (this.controllerImp == null) {
            this.controllerImp = new FifaController(this.getModelImp(), this.getChapiHandlerImp());
            ViewFactory.getInstance().setModel(this.getModelImp());
            DialogsManager.start(this.getModelImp());
        }
        return this.controllerImp;
    }

    public final ChapiHandler getChapiHandlerImp() {
        if (this.chapiHandlerImp == null) {
            this.chapiHandlerImp = new ChapiHandler(this.getModelImp());
            this.chapiHandlerImp.registerToChapi();
        }
        return this.chapiHandlerImp;
    }

    public FifaModel getModelImp() {
        if (this.modelImp == null) {
            this.modelImp = new FifaModel();
        }
        return this.modelImp;
    }

    private void initializeLwuit() {
        Display.init(this.midlet);
        DefaultLookAndFeel fifaLookAndFeell = new DefaultLookAndFeel();
        if (FifaLookAndFeelManager.configCheckedFifaCheckbox() != null || FifaLookAndFeelManager.configUncheckedFifaCheckbox() != null) {
            fifaLookAndFeell.setCheckBoxImages(FifaLookAndFeelManager.configCheckedFifaCheckbox(), FifaLookAndFeelManager.configUncheckedFifaCheckbox());
            UIManager.getInstance().setLookAndFeel(fifaLookAndFeell);
        }
    }
}

