/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.model;

import com.sonyericsson.ams.Application;
import com.sonyericsson.fifa.data.OnlineContent;
import com.sonyericsson.fifa.data.PreloadedContent;
import com.sonyericsson.fifa.data.Team;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.model.Model;
import com.sonyericsson.fifa.model.ModelControllerListener;
import com.sonyericsson.fifa.model.onlineContent.OnlineContentListListener;
import com.sonyericsson.fifa.model.preloadedContent.PreloadedContentListener;
import com.sonyericsson.fifa.model.teamList.TeamListener;
import com.sonyericsson.fifa.model.tournamentTable.TournamentTableListener;
import com.sonyericsson.fifa.utils.TaskHandler;
import com.sonyericsson.fifa.view.player.VideoPlayerView;
import com.sonyericsson.fifa.view.player.VideoPlayerViewHB209;
import com.sun.lwuit.Image;
import java.util.Enumeration;
import java.util.Vector;

public abstract class AbstractModel
implements Model {
    private static ModelTaskHandler enclosureDownloadTaskHandler;
    private static ModelTaskHandler videoDownloadTaskHandler;
    private static ModelTaskHandler feedsParserTaskHandler;

    public void start() {
        if (enclosureDownloadTaskHandler == null) {
            enclosureDownloadTaskHandler = new ModelTaskHandler();
        }
        enclosureDownloadTaskHandler.start();
        if (videoDownloadTaskHandler == null) {
            videoDownloadTaskHandler = new ModelTaskHandler();
        }
        videoDownloadTaskHandler.start();
        if (feedsParserTaskHandler == null) {
            feedsParserTaskHandler = new ModelTaskHandler();
        }
        feedsParserTaskHandler.start();
    }

    public void stop() {
        enclosureDownloadTaskHandler.stop();
        videoDownloadTaskHandler.stop();
        feedsParserTaskHandler.stop();
    }

    public static void addDownloadEnclosureTask(Runnable task) {
        enclosureDownloadTaskHandler.addTask(task);
    }

    public static void addDownloadVideoTask(Runnable task) {
        videoDownloadTaskHandler.addTask(task);
    }

    public static void addFeedsParserTask(Runnable task) {
        feedsParserTaskHandler.addTask(task);
    }

    public abstract /* synthetic */ void updateTournamentContent();

    public abstract /* synthetic */ void updateTeamList();

    public abstract /* synthetic */ void updateTeam(String var1);

    public abstract /* synthetic */ void updatePreloadedContent();

    public abstract /* synthetic */ void updateOnlineContentList();

    public abstract /* synthetic */ void updateGroup();

    public abstract /* synthetic */ void updateConfLinks();

    public abstract /* synthetic */ void stopWriteRMSGroup();

    public abstract /* synthetic */ void setWidgetStatus(boolean var1);

    public abstract /* synthetic */ void setVideoPlayerHB209(VideoPlayerViewHB209 var1);

    public abstract /* synthetic */ void setVideoPlayer(VideoPlayerView var1);

    public abstract /* synthetic */ void setOnlineContentListListener(OnlineContentListListener var1);

    public abstract /* synthetic */ void setNetworkingAuthorization(boolean var1);

    public abstract /* synthetic */ void setMyTeam(String var1);

    public abstract /* synthetic */ void setHomeNetworkOnlyStatus(boolean var1);

    public abstract /* synthetic */ void setCallByHomeScreen(boolean var1);

    public abstract /* synthetic */ void removeTournamentTableListener(TournamentTableListener var1);

    public abstract /* synthetic */ void removeTeamListener(String var1, TeamListener var2);

    public abstract /* synthetic */ void removePreloadedContentListener(PreloadedContentListener var1);

    public abstract /* synthetic */ void removeModelControllerListener();

    public abstract /* synthetic */ boolean isWidgetActivated();

    public abstract /* synthetic */ boolean isUpdatingGroup();

    public abstract /* synthetic */ boolean isTournamentUpdated();

    public abstract /* synthetic */ boolean isPreloadedContentUpdated();

    public abstract /* synthetic */ boolean isOnlineContentListUpdated();

    public abstract /* synthetic */ boolean isNetworkingAuthorized();

    public abstract /* synthetic */ boolean isHomeNetworkOnlyActivated();

    public abstract /* synthetic */ Vector getTournamentGroups();

    public abstract /* synthetic */ Team getTeam(String var1);

    public abstract /* synthetic */ Vector getPreloadedVideos();

    public abstract /* synthetic */ Vector getPreloadedPictures();

    public abstract /* synthetic */ Vector getPreloadedExtras();

    public abstract /* synthetic */ PreloadedContent getPreloadedContent(int var1);

    public abstract /* synthetic */ Enumeration getOnlineContentEnumeration();

    public abstract /* synthetic */ OnlineContent getOnlineContent(int var1);

    public abstract /* synthetic */ Vector getOngoingGames();

    public abstract /* synthetic */ int getNumberOfGamesPreloaded();

    public abstract /* synthetic */ Vector getNotStartedGames();

    public abstract /* synthetic */ Team getMyTeam();

    public abstract /* synthetic */ Image getIconMainApplication(String var1, Application var2);

    public abstract /* synthetic */ String getGroupByTeamCode(String var1);

    public abstract /* synthetic */ Vector getFinishedGames();

    public abstract /* synthetic */ FeedItem getFeedItem(String var1, String var2);

    public abstract /* synthetic */ boolean getCallByHomeScreen();

    public abstract /* synthetic */ String[] getApplicationIdList();

    public abstract /* synthetic */ String[] getApplicationGameName();

    public abstract /* synthetic */ void closeVideo();

    public abstract /* synthetic */ void addTournamentTableListener(TournamentTableListener var1);

    public abstract /* synthetic */ void addTeamListener(String var1, TeamListener var2);

    public abstract /* synthetic */ void addPreloadedContentListener(PreloadedContentListener var1);

    public abstract /* synthetic */ void addModelControllerListener(ModelControllerListener var1);

    static class ModelTaskHandler
    extends TaskHandler {
        ModelTaskHandler() {
        }

        protected void exec(Object task) {
            Runnable r = (Runnable)task;
            r.run();
        }
    }
}

