/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.model;

import com.sonyericsson.ams.Application;
import com.sonyericsson.fifa.data.ConfLink;
import com.sonyericsson.fifa.data.Group;
import com.sonyericsson.fifa.data.OnlineContent;
import com.sonyericsson.fifa.data.PreloadedContent;
import com.sonyericsson.fifa.data.Team;
import com.sonyericsson.fifa.data.feed.Feed;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.datastore.ConfigurationDB;
import com.sonyericsson.fifa.model.AbstractModel;
import com.sonyericsson.fifa.model.ModelControllerListener;
import com.sonyericsson.fifa.model.NetAuth;
import com.sonyericsson.fifa.model.StartupConfiguration;
import com.sonyericsson.fifa.model.gameList.GameList;
import com.sonyericsson.fifa.model.onlineContent.OnlineContentList;
import com.sonyericsson.fifa.model.onlineContent.OnlineContentListListener;
import com.sonyericsson.fifa.model.preloadedContent.PreloadedContentList;
import com.sonyericsson.fifa.model.preloadedContent.PreloadedContentListener;
import com.sonyericsson.fifa.model.teamList.TeamList;
import com.sonyericsson.fifa.model.teamList.TeamListener;
import com.sonyericsson.fifa.model.tournamentTable.TournamentTable;
import com.sonyericsson.fifa.model.tournamentTable.TournamentTableListener;
import com.sonyericsson.fifa.services.parser.ParserListener;
import com.sonyericsson.fifa.services.parser.sax.SaxParser;
import com.sonyericsson.fifa.services.parser.sax.handler.ConflinksHandler;
import com.sonyericsson.fifa.utils.Configuration;
import com.sonyericsson.fifa.utils.FeedFileCleaner;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.view.player.VideoPlayerView;
import com.sonyericsson.fifa.view.player.VideoPlayerViewHB209;
import com.sun.lwuit.Image;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.content.ContentHandler;

public class FifaModel
extends AbstractModel {
    private PreloadedContentList preloadedContentList;
    private static final int COUNTRY_CODE_LENGTH = 3;
    private static final int NUMBER_OF_LINKS = 2;
    private static final int PANINI_GAME = 1;
    private String[] applicationGameName;
    private TournamentTable tournamentTable;
    private String myTeamCode;
    private TeamList teamList;
    private GameList todayGameList;
    private NetAuth netAuth;
    private Vector confLinks;
    private ModelControllerListener listener;
    private String tournamentTabLink = null;
    private ConfigurationDB configurationDB = new ConfigurationDB();
    private StartupConfiguration startupConfiguration = this.configurationDB.retrieveConfiguration();
    private OnlineContentList onlineContentList;
    private boolean callByHomeScreen;
    private VideoPlayerViewHB209 videoPlayerHB209;
    private VideoPlayerView videoPlayer;
    static /* synthetic */ Class class$0;

    public FifaModel() {
        if (this.startupConfiguration != null) {
            if (this.startupConfiguration.getMyTeamCountryCode().length() == 3) {
                this.setMyTeam(this.startupConfiguration.getMyTeamCountryCode());
            } else {
                this.setHomeNetworkOnlyStatus(true);
                if (IOUtility.getJavaApplication("footballfanhs") != null) {
                    this.setWidgetStatus(true);
                }
            }
            if (IOUtility.getJavaApplication("footballfanhs") == null) {
                this.setWidgetStatus(false);
            }
            this.setNetworkingAuthorization(this.startupConfiguration.getYesNeverAsk());
            String currentLanguage = Configuration.getInstance().getFeedsLanguage(this.startupConfiguration.getLanguage());
            this.setCurrentLanguage(currentLanguage);
        }
    }

    public boolean isWidgetActivated() {
        this.startupConfiguration = this.configurationDB.retrieveConfiguration();
        return this.startupConfiguration.isHomescreenEnabled();
    }

    public boolean isHomeNetworkOnlyActivated() {
        this.startupConfiguration = this.configurationDB.retrieveConfiguration();
        return this.startupConfiguration.isHomeNetworkOnlyEnabled();
    }

    public void setWidgetStatus(boolean status) {
        this.startupConfiguration = this.configurationDB.retrieveConfiguration();
        this.startupConfiguration.setHomescreen(status);
        this.configurationDB.saveConfiguration(this.startupConfiguration);
    }

    public void setHomeNetworkOnlyStatus(boolean status) {
        this.startupConfiguration = this.configurationDB.retrieveConfiguration();
        this.startupConfiguration.setHomeNetworkOnly(status);
        this.configurationDB.saveConfiguration(this.startupConfiguration);
    }

    private OnlineContentList getOnlineContentList() {
        if (this.onlineContentList == null) {
            this.onlineContentList = new OnlineContentList();
        }
        return this.onlineContentList;
    }

    public void updateOnlineContentList() {
        this.getOnlineContentList().updateOnlineContentList();
    }

    public boolean isOnlineContentListUpdated() {
        Enumeration list = this.getOnlineContentList().getOnlineContentList();
        return list != null && list.hasMoreElements();
    }

    public void setOnlineContentListListener(OnlineContentListListener listener) {
        this.getOnlineContentList().setContentListListener(listener);
    }

    public OnlineContent getOnlineContent(int index) {
        return this.getOnlineContentList().getOnlineContent(index);
    }

    public Enumeration getOnlineContentEnumeration() {
        return this.getOnlineContentList().getOnlineContentList();
    }

    public void setCurrentLanguage(String language) {
        this.getTeamList().setFeedsLanguage(language);
        this.startupConfiguration = this.configurationDB.retrieveConfiguration();
        this.startupConfiguration.setLanguage(language);
        this.configurationDB.saveConfiguration(this.startupConfiguration);
    }

    private PreloadedContentList getPreloadedContentList() {
        if (this.preloadedContentList == null) {
            this.preloadedContentList = new PreloadedContentList();
        }
        return this.preloadedContentList;
    }

    public PreloadedContent getPreloadedContent(int index) {
        return this.getPreloadedContentList().getPreloadedContent(index);
    }

    public Vector getPreloadedExtras() {
        return this.getPreloadedContentList().getPreloadedExtras();
    }

    public Vector getPreloadedVideos() {
        return this.getPreloadedContentList().getPreloadedVideos();
    }

    public Vector getPreloadedPictures() {
        return this.getPreloadedContentList().getPreloadedPictures();
    }

    public void updatePreloadedContent() {
        this.getPreloadedContentList().updatePreloadedContent();
    }

    public boolean isPreloadedContentUpdated() {
        return this.getPreloadedContentList().isPreloadedContentUpdated();
    }

    public void addPreloadedContentListener(PreloadedContentListener listener) {
        this.getPreloadedContentList().addPreloadedContentListener(listener);
    }

    public void removePreloadedContentListener(PreloadedContentListener listener) {
        this.getPreloadedContentList().removePreloadedContentListener(listener);
    }

    private GameList getTodayGameList() {
        if (this.todayGameList == null) {
            this.todayGameList = new GameList();
        }
        return this.todayGameList;
    }

    public Vector getNotStartedGames() {
        return this.getTodayGameList().getNotStartedGames();
    }

    public Vector getOngoingGames() {
        return this.getTodayGameList().getOngoingGames();
    }

    public Vector getFinishedGames() {
        return this.getTodayGameList().getFinishedGames();
    }

    private TeamList getTeamList() {
        if (this.teamList == null) {
            this.teamList = new TeamList();
        }
        return this.teamList;
    }

    public Team getMyTeam() {
        return this.getTeam(this.myTeamCode);
    }

    public void setMyTeam(String teamCode) {
        this.myTeamCode = teamCode;
        this.getTeamList().setMyTeam(teamCode);
        ConfigurationDB configurationDB = new ConfigurationDB();
        StartupConfiguration startupConfiguration = configurationDB.retrieveConfiguration();
        startupConfiguration.setMyTeamCountryCode(teamCode);
        configurationDB.saveConfiguration(startupConfiguration);
    }

    public Team getTeam(String teamCode) {
        return this.getTeamList().getTeam(teamCode);
    }

    public void updateTeam(String teamCode) {
        Team team = this.getTeamList().getTeam(teamCode);
        if (team != null) {
            team.update();
            FeedFileCleaner.getInstance().startFeedFilesCleanUp();
        }
    }

    public void initModel() {
    }

    public void updateTeamList() {
        this.getTeamList().updateTeamList();
    }

    public void addTeamListener(String teamCode, TeamListener listener) {
        Team team = this.getTeamList().getTeam(teamCode);
        if (team != null) {
            team.addTeamListener(listener);
        }
    }

    public void addModelControllerListener(ModelControllerListener listener) {
        this.listener = listener;
        this.getTeamList().setListerner(listener);
    }

    public void removeModelControllerListener() {
        this.listener = null;
        this.getTeamList().removeListener();
    }

    public void removeTeamListener(String teamCode, TeamListener listener) {
        Team team = this.getTeamList().getTeam(teamCode);
        if (team != null) {
            team.removeTeamListener(listener);
        }
    }

    private TournamentTable getTournamentTable() {
        if (this.tournamentTable == null) {
            this.tournamentTable = new TournamentTable();
        }
        return this.tournamentTable;
    }

    public Vector getTournamentGroups() {
        return this.getTournamentTable().getTournamentGroups();
    }

    public void updateTournamentContent() {
        this.getTournamentTable().updateTournamentContent(this.getTournamentLink());
    }

    public boolean isTournamentUpdated() {
        return this.getTournamentTable().isTournamentUpdated();
    }

    public void addTournamentTableListener(TournamentTableListener listener) {
        this.getTournamentTable().addTournamentTableListener(listener);
    }

    public void removeTournamentTableListener(TournamentTableListener listener) {
        this.getTournamentTable().removeTournamentTableListener(listener);
    }

    public String getGroupByTeamCode(String teamCode) {
        return this.getTournamentTable().getGroupByTeamCode(teamCode);
    }

    public boolean isNetworkingAuthorized() {
        return this.getNetAuth().isNetworkingAuthorized();
    }

    public void setNetworkingAuthorization(boolean auth) {
        this.getNetAuth().setNetworkingAuthorization(auth);
    }

    public boolean isRoamingAuthorized() {
        return this.getNetAuth().isRoamingAuthorized();
    }

    public void setRoamingAuthorization(boolean auth) {
        this.getNetAuth().setRoamingAuthorization(auth);
    }

    private NetAuth getNetAuth() {
        if (this.netAuth == null) {
            this.netAuth = new NetAuth();
        }
        return this.netAuth;
    }

    private String getTournamentLink() {
        if (this.tournamentTabLink == null && this.confLinks != null) {
            int i = 0;
            while (i < this.confLinks.size()) {
                ConfLink element = (ConfLink)this.confLinks.elementAt(i);
                if (element.getType() == 1) {
                    this.tournamentTabLink = element.url;
                }
                ++i;
            }
        }
        return this.tournamentTabLink;
    }

    public void updateConfLinks() {
        final ConflinksHandler handler = new ConflinksHandler();
        SaxParser parser = new SaxParser("/confLinks.xml", handler);
        ParserListener listener = new ParserListener(){

            public void parserFinished() {
                Vector contentList = handler.getParsedConfLinks();
                if (contentList != null && !contentList.isEmpty()) {
                    FifaModel.this.confLinks = contentList;
                    FifaModel.this.fireConfLinkReady((byte)0);
                }
            }

            public void parserFailed(byte reason) {
                FifaModel.this.confLinks = null;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.model.FifaModel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logError(clazz, "updateConfLinks failed.");
                Logger.logError(this.getClass(), "Parser failed, unexpected reason: " + reason);
                FifaModel.this.fireConfLinkReady((byte)4);
            }
        };
        parser.addParserListener(listener);
        parser.run();
    }

    public void setModelControllerListener(ModelControllerListener listener) {
        this.listener = listener;
    }

    private void fireConfLinkReady(byte reason) {
        if (this.listener != null) {
            this.listener.confLinkReady(reason);
        }
    }

    public void updateGroup() {
        Group group;
        String countryCode = this.getMyTeam().getTeamCode();
        if (countryCode != null && this.tournamentTable != null && (group = this.tournamentTable.getGroupObjByTeamCode(countryCode)) != null) {
            Enumeration teams = group.getTeamCodes();
            while (teams.hasMoreElements()) {
                String teamCode = (String)teams.nextElement();
                this.updateTeam(teamCode);
            }
        }
    }

    public void stopWriteRMSGroup() {
        Group group;
        String countryCode = this.getMyTeam().getTeamCode();
        if (countryCode != null && this.tournamentTable != null && (group = this.tournamentTable.getGroupObjByTeamCode(countryCode)) != null) {
            Enumeration teams = group.getTeamCodes();
            while (teams.hasMoreElements()) {
                String teamCode = (String)teams.nextElement();
                Team team = this.getTeamList().getTeam(teamCode);
                team.stopUpdatingRMS();
            }
        }
    }

    public boolean isUpdatingGroup() {
        Group group;
        boolean isUpdating = false;
        String countryCode = this.getMyTeam().getTeamCode();
        if (countryCode != null && this.tournamentTable != null && (group = this.tournamentTable.getGroupObjByTeamCode(countryCode)) != null) {
            Enumeration teams = group.getTeamCodes();
            while (teams.hasMoreElements()) {
                String teamCode = (String)teams.nextElement();
                Team team = this.getTeamList().getTeam(teamCode);
                boolean bl = isUpdating = isUpdating || team.isUpdatingRMS();
            }
        }
        return isUpdating;
    }

    public FeedItem getFeedItem(String countryCode, String itemTitleText) {
        Feed feed;
        Team team;
        FeedItem item = null;
        if (countryCode != null && itemTitleText != null && (team = this.getTeam(countryCode)) != null && (feed = team.getLatestNews()) != null) {
            item = feed.getItemByTitle(itemTitleText);
        }
        return item;
    }

    public String[] getApplicationGameName() {
        return this.applicationGameName;
    }

    public String[] getApplicationIdList() {
        int posApplication = 0;
        int position = 0;
        boolean preloaded = false;
        Vector extras = this.getPreloadedExtras();
        ContentHandler[] contentHandler = IOUtility.getGameList();
        String[] applicationIdList = new String[IOUtility.sizeGameList()];
        this.applicationGameName = new String[IOUtility.sizeGameList()];
        String[] preloadedGameName = new String[extras.size() - 2];
        int i = 2;
        while (i < extras.size()) {
            preloadedGameName[position++] = ((PreloadedContent)extras.elementAt(i)).getLink();
            ++i;
        }
        int pos = 0;
        while (pos < contentHandler.length) {
            preloaded = false;
            int k = 0;
            while (k < preloadedGameName.length) {
                if (preloadedGameName[k].equalsIgnoreCase(contentHandler[pos].getAppName())) {
                    preloaded = true;
                    break;
                }
                ++k;
            }
            if (!preloaded) {
                applicationIdList[posApplication] = contentHandler[pos].getID();
                this.applicationGameName[posApplication++] = contentHandler[pos].getAppName();
            }
            ++pos;
        }
        return applicationIdList;
    }

    public Image getIconMainApplication(String iconPath, Application application) {
        Image image = null;
        int index = -1;
        String mainIconPath = null;
        InputStream inputStream = null;
        try {
            index = iconPath.indexOf(",");
            mainIconPath = index != -1 ? iconPath.substring(0, index) : iconPath;
            if (mainIconPath != null) {
                inputStream = application.getResourceAsStream(mainIconPath);
            }
            if (inputStream != null) {
                image = Image.createImage(inputStream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    public int getNumberOfGamesPreloaded() {
        Vector extras = this.getPreloadedExtras();
        return extras.size() - 2 - 1;
    }

    public void setCallByHomeScreen(boolean callByHomeScreen) {
        this.callByHomeScreen = callByHomeScreen;
    }

    public boolean getCallByHomeScreen() {
        return this.callByHomeScreen;
    }

    public void setVideoPlayerHB209(VideoPlayerViewHB209 videoPlayerHB209) {
        this.videoPlayerHB209 = videoPlayerHB209;
    }

    public void setVideoPlayer(VideoPlayerView videoPlayer) {
        this.videoPlayer = videoPlayer;
    }

    public void closeVideo() {
        if (this.videoPlayer != null) {
            this.videoPlayer.turnLitghtsOffByHomeScreen();
        } else if (this.videoPlayerHB209 != null) {
            this.videoPlayerHB209.turnLitghtsOffByHomeScreen();
        }
    }
}

