/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.model.onlineContent;

import com.sonyericsson.fifa.data.OnlineContent;
import com.sonyericsson.fifa.data.OnlineContentListener;
import com.sonyericsson.fifa.datastore.OnlineContentDB;
import com.sonyericsson.fifa.model.onlineContent.OnlineContentListListener;
import com.sonyericsson.fifa.services.parser.ParserListener;
import com.sonyericsson.fifa.services.parser.sax.SaxParser;
import com.sonyericsson.fifa.services.parser.sax.handler.OnlineContentHandler;
import com.sonyericsson.fifa.utils.Configuration;
import com.sonyericsson.fifa.utils.IOUtility;
import com.sonyericsson.fifa.utils.Logger;
import java.util.Enumeration;
import java.util.Vector;

public class OnlineContentList
implements OnlineContentListener {
    private Vector onlineContentList = new Vector();
    private OnlineContentListListener onlineContentListener;
    static /* synthetic */ Class class$0;

    public OnlineContentList() {
        this.retriveOnlineContentListFromRMS();
        OnlineContent.setOnlineContentListener(this);
    }

    public void setContentListListener(OnlineContentListListener listener) {
        this.onlineContentListener = listener;
    }

    public void updateOnlineContentList() {
        final OnlineContentHandler handler = new OnlineContentHandler();
        handler.setLastPublishDate(this.getDateForLastUpdated());
        SaxParser parser = new SaxParser(Configuration.getInstance().getExtraVideosUrl(), handler);
        parser.addParserListener(new ParserListener(){

            public void parserFailed(byte reason) {
                switch (reason) {
                    case 1: {
                        OnlineContentList.this.fireOnlineContentListUpdated((byte)1);
                        break;
                    }
                    case 2: {
                        OnlineContentList.this.fireOnlineContentListUpdated((byte)4);
                        break;
                    }
                    default: {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("com.sonyericsson.fifa.data.Team");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Logger.logError(clazz, "updateLatestNews failed.");
                        Logger.logError(this.getClass(), "Parser failed, unexpected reason: " + reason);
                        OnlineContentList.this.fireOnlineContentListUpdated((byte)4);
                    }
                }
                OnlineContentList.this.downloadPreviews();
            }

            public void parserFinished() {
                Vector list = handler.getOnlineContentList();
                if (list != null && !list.isEmpty()) {
                    OnlineContentList.this.updateOnlineContentList(list);
                    OnlineContentList.this.fireOnlineContentListUpdated((byte)0);
                } else if (OnlineContentList.this.onlineContentList.isEmpty()) {
                    Logger.logError(this.getClass(), "Failure to parse online content list.");
                    OnlineContentList.this.fireOnlineContentListUpdated((byte)4);
                }
                OnlineContentList.this.downloadPreviews();
            }
        });
        new Thread(parser).start();
    }

    private void updateOnlineContentList(Vector parsedItems) {
        int i = 0;
        while (i < this.onlineContentList.size()) {
            parsedItems.addElement(this.onlineContentList.elementAt(i));
            ++i;
        }
        this.onlineContentList = parsedItems;
        this.saveOnlineContentListIntoRMS();
    }

    private String getDateForLastUpdated() {
        OnlineContent content;
        String date = null;
        if (!this.onlineContentList.isEmpty() && (content = (OnlineContent)this.onlineContentList.elementAt(0)) != null) {
            date = content.getDateAdded();
        }
        return date;
    }

    private void downloadPreviews() {
        int i = 0;
        while (i < this.onlineContentList.size()) {
            byte status;
            OnlineContent content = (OnlineContent)this.onlineContentList.elementAt(i);
            if (content != null && (status = content.getPreviewStatus()) == 0) {
                content.downloadPreview();
            }
            ++i;
        }
    }

    public Enumeration getOnlineContentList() {
        return this.onlineContentList.elements();
    }

    private void saveOnlineContentListIntoRMS() {
        OnlineContentDB contentDB = new OnlineContentDB();
        contentDB.saveOnlineContentList(this.onlineContentList);
    }

    private void retriveOnlineContentListFromRMS() {
        OnlineContentDB contentDB = new OnlineContentDB();
        Vector storedData = contentDB.retrieveOnlineContent();
        if (storedData != null && !storedData.isEmpty()) {
            int i = 0;
            while (i < storedData.size()) {
                boolean contentChanged = false;
                OnlineContent content = (OnlineContent)storedData.elementAt(i);
                if (content.getContentStatus() == 2 && !IOUtility.isFileAvailable(content.getPath())) {
                    content.setContentStatus((byte)0);
                    content.setDownloadProgress(0);
                    contentChanged = true;
                }
                if (content.getPreviewStatus() == 2 && !IOUtility.isFileAvailable(content.getPreviewPath())) {
                    content.setPreviewContentStatus((byte)0);
                    contentChanged = true;
                }
                if (contentChanged) {
                    contentDB.saveOnlineContent(content);
                }
                ++i;
            }
            this.onlineContentList = storedData;
        }
    }

    private void fireOnlineContentListUpdated(byte reason) {
        if (this.onlineContentListener != null) {
            this.onlineContentListener.updateList(reason);
        }
    }

    private void fireOnlineContentUpdated(byte reason, OnlineContent content) {
        if (this.onlineContentListener != null) {
            this.onlineContentListener.updateContent(reason, content);
        }
    }

    public OnlineContent getOnlineContent(int index) {
        if (this.onlineContentList.size() > index) {
            return (OnlineContent)this.onlineContentList.elementAt(index);
        }
        return null;
    }

    public void updateContent(byte reason, OnlineContent content) {
        if (reason == 0 && content != null) {
            OnlineContentDB contentDB = new OnlineContentDB();
            contentDB.saveOnlineContent(content);
        }
        this.fireOnlineContentUpdated(reason, content);
    }
}

