/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.model.preloadedContent;

import com.sonyericsson.fifa.data.PreloadedContent;
import com.sonyericsson.fifa.model.preloadedContent.PreloadedContentListener;
import com.sonyericsson.fifa.services.content.ContentVerifierListener;
import com.sonyericsson.fifa.services.content.GenericContentVerifier;
import com.sonyericsson.fifa.services.parser.ParserListener;
import com.sonyericsson.fifa.services.parser.sax.SaxParser;
import com.sonyericsson.fifa.services.parser.sax.handler.PreloadedHandler;
import com.sonyericsson.fifa.utils.Logger;
import java.util.Vector;

public class PreloadedContentList {
    private Vector preloadedVideos = new Vector();
    private Vector preloadedExtras = new Vector();
    private Vector preloadedPictures = new Vector();
    private Vector listeners = new Vector();
    static /* synthetic */ Class class$0;

    public PreloadedContent getPreloadedContent(int index) {
        PreloadedContent content = null;
        if (index >= 0) {
            if (index < this.preloadedVideos.size()) {
                content = (PreloadedContent)this.preloadedVideos.elementAt(index);
            } else if (index < this.preloadedVideos.size() + this.preloadedExtras.size()) {
                content = (PreloadedContent)this.preloadedExtras.elementAt(index - this.preloadedVideos.size());
            } else if (index < this.preloadedVideos.size() + this.preloadedExtras.size() + this.preloadedPictures.size()) {
                content = (PreloadedContent)this.preloadedPictures.elementAt(index - this.preloadedVideos.size() - this.preloadedExtras.size());
            }
        }
        return content;
    }

    public Vector getPreloadedExtras() {
        return this.preloadedExtras;
    }

    public Vector getPreloadedVideos() {
        return this.preloadedVideos;
    }

    public Vector getPreloadedPictures() {
        return this.preloadedPictures;
    }

    public void updatePreloadedContent() {
        final PreloadedHandler handler = new PreloadedHandler();
        SaxParser parser = new SaxParser("/preloadedContent.xml", handler);
        ParserListener listener = new ParserListener(){

            public void parserFinished() {
                Vector contentList = handler.getPreloadedContent();
                if (contentList != null && !contentList.isEmpty()) {
                    PreloadedContentList.this.verifyContent(contentList);
                } else {
                    PreloadedContentList.this.firePreloadedContentReady();
                }
            }

            public void parserFailed(byte reason) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.model.preloadedContent.PreloadedContentList");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logError(clazz, "updatePreloadedContent failed.");
                Logger.logError(this.getClass(), "Parser failed, unexpected reason: " + reason);
                PreloadedContentList.this.firePreloadedContentFailed((byte)4);
            }
        };
        parser.addParserListener(listener);
        new Thread(parser).start();
    }

    private void verifyContent(Vector contentList) {
        GenericContentVerifier verifier = new GenericContentVerifier(contentList);
        ContentVerifierListener listener = new ContentVerifierListener(){

            public void contentVerificationFailed() {
                PreloadedContentList.this.firePreloadedContentFailed((byte)4);
            }

            public void contentVerified(Vector contentList) {
                if (contentList != null && !contentList.isEmpty()) {
                    int i = 0;
                    while (i < contentList.size()) {
                        PreloadedContent content = (PreloadedContent)contentList.elementAt(i);
                        if (content != null) {
                            if (content.getType() == 1) {
                                PreloadedContentList.this.preloadedVideos.addElement(content);
                            } else if (content.getType() == 0 || content.getType() == 2) {
                                PreloadedContentList.this.preloadedExtras.addElement(content);
                            } else if (content.getType() == 3) {
                                PreloadedContentList.this.preloadedPictures.addElement(content);
                            }
                        }
                        ++i;
                    }
                }
                PreloadedContentList.this.firePreloadedContentReady();
            }
        };
        verifier.addContentVerifierListener(listener);
        new Thread(verifier).start();
    }

    public boolean isPreloadedContentUpdated() {
        boolean contentUpdated = true;
        if (this.getPreloadedVideos().isEmpty() && this.getPreloadedExtras().isEmpty()) {
            contentUpdated = false;
        }
        return contentUpdated;
    }

    public void addPreloadedContentListener(PreloadedContentListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removePreloadedContentListener(PreloadedContentListener listener) {
        this.listeners.removeElement(listener);
    }

    private void firePreloadedContentReady() {
        int i = 0;
        while (i < this.listeners.size()) {
            PreloadedContentListener listener = (PreloadedContentListener)this.listeners.elementAt(i);
            listener.preloadedContentReady();
            ++i;
        }
    }

    private void firePreloadedContentFailed(byte reason) {
        int i = 0;
        while (i < this.listeners.size()) {
            PreloadedContentListener listener = (PreloadedContentListener)this.listeners.elementAt(i);
            listener.preloadedContentFailed(reason);
            ++i;
        }
    }
}

