/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.model.teamList;

import com.sonyericsson.fifa.data.Team;
import com.sonyericsson.fifa.data.TeamLinks;
import com.sonyericsson.fifa.model.ModelControllerListener;
import com.sonyericsson.fifa.services.parser.ParserListener;
import com.sonyericsson.fifa.services.parser.sax.SaxParser;
import com.sonyericsson.fifa.services.parser.sax.handler.TeamsHandler;
import com.sonyericsson.fifa.utils.Configuration;
import com.sonyericsson.fifa.utils.Logger;
import java.util.Hashtable;

public class TeamList {
    private Team[] teamList = new Team[2];
    private String myTeamCode;
    private Hashtable configLinksForTeams = new Hashtable();
    private ModelControllerListener listener;
    private String feedsLanguage = "en";
    private static final int MYTEAM_INDEX = 0;
    private static final int OTHERTEAM_INDEX = 1;
    static /* synthetic */ Class class$0;

    public Team getTeam(String teamCode) {
        Team team = null;
        if (teamCode != null && (team = this.getExistingTeam(teamCode)) == null) {
            team = this.createTeam(teamCode);
            if (this.myTeamCode != null && this.myTeamCode.equalsIgnoreCase(teamCode)) {
                this.teamList[0] = team;
            } else {
                this.teamList[1] = team;
            }
        }
        return team;
    }

    private Team getExistingTeam(String teamCode) {
        Team team = null;
        int i = 0;
        while (i < this.teamList.length) {
            String code;
            if (this.teamList[i] != null && (code = this.teamList[i].getTeamCode()) != null && code.equalsIgnoreCase(teamCode)) {
                team = this.teamList[i];
                break;
            }
            ++i;
        }
        return team;
    }

    public void setMyTeam(String teamCode) {
        this.myTeamCode = teamCode;
        this.teamList[0] = this.getTeam(teamCode);
    }

    public void setFeedsLanguage(String language) {
        this.feedsLanguage = language;
    }

    private Team createTeam(String teamCode) {
        TeamLinks teamConfig;
        Team team = null;
        if (teamCode != null && this.configLinksForTeams != null && (teamConfig = (TeamLinks)this.configLinksForTeams.get(teamCode)) != null) {
            team = new Team(teamCode, teamConfig.getLatestNewsUrl());
        }
        return team;
    }

    public void updateTeamList() {
        Logger.logInfo(this.getClass(), "updateTeamList");
        final TeamsHandler handler = new TeamsHandler();
        SaxParser parser = new SaxParser(Configuration.getInstance().getTeamListXML(this.feedsLanguage), handler);
        ParserListener listener = new ParserListener(){

            public void parserFinished() {
                TeamList.this.configLinksForTeams = handler.getTeamLinks();
                TeamList.this.fireModelReady((byte)0);
            }

            public void parserFailed(byte reason) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.sonyericsson.fifa.model.teamList.TeamList");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Logger.logError(clazz, "updateTeamList Finished Fail");
                Logger.logError(this.getClass(), "Parser failed, unexpected reason: " + reason);
                TeamList.this.fireModelReady((byte)4);
            }
        };
        parser.addParserListener(listener);
        parser.run();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.teamList.length) {
            Team team = this.teamList[i];
            if (team != null) {
                result.append(team.toString());
                result.append("\n");
            }
            ++i;
        }
        return result.toString();
    }

    public void setListerner(ModelControllerListener listener) {
        this.listener = listener;
    }

    public void removeListener() {
        this.listener = null;
    }

    public void fireModelReady(byte reason) {
        if (this.listener != null) {
            this.listener.modelReady(reason);
        }
    }
}

