/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.model.tournamentTable;

import com.sonyericsson.fifa.data.Group;
import com.sonyericsson.fifa.datastore.TournamentDataDB;
import com.sonyericsson.fifa.model.tournamentTable.TournamentTableListener;
import com.sonyericsson.fifa.services.parser.ParserListener;
import com.sonyericsson.fifa.services.parser.sax.SaxParser;
import com.sonyericsson.fifa.services.parser.sax.handler.TournamentHandler;
import com.sonyericsson.fifa.utils.Logger;
import java.util.Vector;

public class TournamentTable {
    private Vector groups = new Vector();
    private Vector listeners = new Vector();
    private static final int TOURNAMENT_UPDATE_NOT_STARTED = 0;
    private static final int TOURNAMENT_UPDATE_STARTED = 1;
    private static final int TOURNAMENT_UPDATE_FINISHED = 2;
    private int currentState = 0;
    static /* synthetic */ Class class$0;

    public Vector getTournamentGroups() {
        if (this.currentState != 2) {
            this.retrieveFromRMSGroups();
        }
        return this.groups;
    }

    private void retrieveFromRMSGroups() {
        TournamentDataDB tournamentDataDB = new TournamentDataDB();
        this.groups = tournamentDataDB.retrieveGroups();
    }

    public void updateTournamentContent(String tournamentName) {
        final TournamentHandler handler = new TournamentHandler();
        SaxParser parser = new SaxParser(tournamentName, handler);
        ParserListener listener = new ParserListener(){

            public void parserFinished() {
                Vector contentList = handler.getGroups();
                if (contentList != null && !contentList.isEmpty()) {
                    TournamentTable.this.groups = contentList;
                    TournamentTable.this.currentState = 2;
                    TournamentDataDB tournamentDataDB = new TournamentDataDB();
                    tournamentDataDB.saveGroups(TournamentTable.this.groups);
                    TournamentTable.this.fireTournamentTableUpdated();
                }
            }

            public void parserFailed(byte reason) {
                TournamentTable.this.retrieveFromRMSGroups();
                if (TournamentTable.this.groups != null && TournamentTable.this.groups.size() > 0) {
                    TournamentTable.this.fireTournamentTableUpdated();
                } else {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.sonyericsson.fifa.model.tournamentTable.TournamentTable");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Logger.logError(clazz, "updateTorunamentContent failed.");
                    Logger.logError(this.getClass(), "Parser failed, unexpected reason: " + reason);
                    TournamentTable.this.fireTournamentTableUpdateFailed((byte)4);
                }
                TournamentTable.this.currentState = 2;
            }
        };
        this.currentState = 1;
        parser.addParserListener(listener);
        parser.run();
    }

    public boolean isTournamentUpdated() {
        return !this.getTournamentGroups().isEmpty();
    }

    public void addTournamentTableListener(TournamentTableListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeTournamentTableListener(TournamentTableListener listener) {
        this.listeners.removeElement(listener);
    }

    private void fireTournamentTableUpdated() {
        int i = 0;
        while (i < this.listeners.size()) {
            TournamentTableListener listener = (TournamentTableListener)this.listeners.elementAt(i);
            listener.tournamentTableUpdated();
            ++i;
        }
    }

    private void fireTournamentTableUpdateFailed(byte reason) {
        int i = 0;
        while (i < this.listeners.size()) {
            TournamentTableListener listener = (TournamentTableListener)this.listeners.elementAt(i);
            listener.tournamentTableUpdateFailed(reason);
            ++i;
        }
    }

    public String getGroupByTeamCode(String teamCode) {
        String groupName = null;
        if (this.getTournamentGroups() != null) {
            int i = 0;
            while (i < this.groups.size()) {
                Group vectorGroup = (Group)this.groups.elementAt(i);
                if (vectorGroup != null && vectorGroup.isTeamInGroup(teamCode.trim())) {
                    groupName = vectorGroup.getGroupName();
                    break;
                }
                ++i;
            }
        }
        return groupName;
    }

    public Group getGroupObjByTeamCode(String teamCode) {
        Group groupFound = null;
        if (this.groups != null) {
            int groupSize = this.groups.size();
            int i = 0;
            while (i < groupSize) {
                Group objGroup = (Group)this.groups.elementAt(i);
                if (objGroup != null && objGroup.isTeamInGroup(teamCode.trim())) {
                    groupFound = objGroup;
                    break;
                }
                ++i;
            }
        }
        return groupFound;
    }
}

