/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.services.chapiservice;

import com.sonyericsson.fifa.services.chapiservice.ChapiListener;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.SystemProperties;
import java.io.IOException;
import javax.microedition.content.ContentHandlerException;
import javax.microedition.content.Invocation;
import javax.microedition.content.Registry;

public class ChapiService
implements Runnable {
    protected String applicationId;
    protected ChapiListener listener;
    protected String operationId;

    public ChapiService(String applicationId) {
        this.applicationId = applicationId;
    }

    public boolean requestInvocation() {
        boolean result = false;
        if (this.applicationId != null) {
            Registry registry = Registry.getRegistry((String)SystemProperties.getMainMidletPath());
            Invocation invocation = new Invocation();
            invocation.setResponseRequired(false);
            invocation.setID(this.applicationId);
            if (this.operationId != null) {
                invocation.setAction(this.operationId);
                result = true;
            }
            try {
                registry.invoke(invocation);
            }
            catch (IllegalArgumentException e) {
                Logger.logError(this.getClass(), "IllegalArgumentException in ChapiService.requestInvocation() : " + e);
                result = false;
            }
            catch (ContentHandlerException e) {
                Logger.logError(this.getClass(), "ContentHandlerException in ChapiService.requestInvocation() : code = " + e.getErrorCode());
                result = false;
            }
            catch (SecurityException e) {
                Logger.logError(this.getClass(), "SecurityException in ChapiService.requestInvocation() : " + e);
                result = false;
            }
            catch (IOException e) {
                Logger.logError(this.getClass(), "IOException in ChapiService.requestInvocation() : " + e);
                result = false;
            }
            Logger.logInfo(this.getClass(), "Invocation done");
        }
        if (this.listener != null) {
            this.listener.operationResult(result);
        }
        Logger.logInfo(this.getClass(), "exiting requestInvokation ");
        return result;
    }

    public void run() {
        this.requestInvocation();
    }

    public void setListener(ChapiListener listener) {
        this.listener = listener;
    }

    public void removeListener() {
        this.listener = null;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }
}

