/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.services.content;

import com.sonyericsson.ams.Application;
import com.sonyericsson.ams.ApplicationManager;
import com.sonyericsson.fifa.data.PreloadedContent;
import com.sonyericsson.fifa.services.chapiservice.CheckExistService;
import com.sonyericsson.fifa.services.content.AbstractContentVerifier;
import com.sonyericsson.fifa.utils.Configuration;
import com.sonyericsson.fifa.utils.FeedUtility;
import com.sonyericsson.fifa.utils.Logger;
import com.sonyericsson.fifa.utils.SystemProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public final class GenericContentVerifier
extends AbstractContentVerifier {
    private Vector contentList;
    private ApplicationManager appManager;
    private Application[] installedApps;

    public GenericContentVerifier(Vector contentList) {
        this.contentList = contentList;
    }

    public void verifyContent() {
        Vector verifiedContentList = new Vector();
        if (this.contentList == null || this.contentList.isEmpty()) {
            this.fireContentVerificationFailed();
        } else {
            int i = 0;
            while (i < this.contentList.size()) {
                Object object = this.contentList.elementAt(i);
                if (object instanceof PreloadedContent) {
                    if (this.verifyContent((PreloadedContent)object)) {
                        verifiedContentList.addElement(object);
                    }
                } else {
                    this.fireContentVerificationFailed();
                    break;
                }
                ++i;
            }
            this.fireContentVerified(verifiedContentList);
        }
    }

    private boolean verifyContent(PreloadedContent content) {
        boolean verificationResult = false;
        if (content != null) {
            if (content.getType() == 0) {
                verificationResult = this.verifyJavaApplication(content.getLink(), null);
            } else if (content.getType() == 2) {
                verificationResult = true;
            } else if (content.getType() == 1) {
                String link = String.valueOf(Configuration.getInstance().getPreloadedVideosDirectory()) + content.getLink();
                verificationResult = this.verifyFile(link);
                if (!verificationResult) {
                    link = String.valueOf(Configuration.getInstance().getPreloadedMemoryVideosDirectory()) + content.getLink();
                    verificationResult = this.verifyFile(link);
                }
                content.setLink(link);
            } else if (content.getType() == 3) {
                content.setLink(String.valueOf(FeedUtility.getInstance().getPreloadedImagesDirectory()) + content.getLink());
                verificationResult = this.verifyFile(content.getLink());
            }
        }
        return verificationResult;
    }

    private boolean verifyFile(String filePath) {
        boolean result = false;
        result = filePath != null && filePath.startsWith("file:///") ? this.verifyFileInFileSystem(filePath) : this.verifyFileInRes(filePath);
        return result;
    }

    private boolean verifyFileInFileSystem(String filePath) {
        boolean result = false;
        FileConnection fc = null;
        try {
            try {
                fc = (FileConnection)Connector.open((String)filePath);
                if (fc.exists()) {
                    result = true;
                }
            }
            catch (IOException e) {
                Logger.logInfo(this.getClass(), "IOExcetion: " + e.getMessage());
                e.printStackTrace();
                try {
                    if (fc != null) {
                        fc.close();
                    }
                }
                catch (IOException e2) {
                    Logger.logInfo(this.getClass(), "IOExcetion: " + e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException e) {
                Logger.logInfo(this.getClass(), "IOExcetion: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return result;
    }

    private boolean verifyFileInRes(String filePath) {
        boolean result;
        block13: {
            result = false;
            InputStream is = null;
            try {
                try {
                    is = this.getClass().getResourceAsStream(filePath);
                    if (is != null) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    Logger.logInfo(this.getClass(), "IOExcetion: " + e.getMessage());
                    e.printStackTrace();
                    if (is == null) break block13;
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        Logger.logInfo(this.getClass(), "IOExcetion: " + e2.getMessage());
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        Logger.logInfo(this.getClass(), "IOExcetion: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    private boolean verifyJavaApplication(String appName, String appVendor) {
        if (appName != null && appName.equalsIgnoreCase("Panini WC album")) {
            return true;
        }
        boolean result = false;
        try {
            if (SystemProperties.getPhonePlatform() == 2) {
                result = CheckExistService.checkExist(appName);
            } else if (appName != null && appVendor != null) {
                Application app;
                if (this.appManager == null) {
                    this.appManager = ApplicationManager.getApplicationManager();
                }
                if ((app = this.appManager.getApplication(appName, appVendor)) != null) {
                    result = true;
                }
            } else if (appName != null) {
                result = this.verifyJavaApplication(appName);
            }
        }
        catch (Exception e) {
            Logger.logInfo(this.getClass(), "Exception: " + e.getMessage());
        }
        return result;
    }

    private boolean verifyJavaApplication(String appName) {
        boolean result = false;
        if (SystemProperties.getPhonePlatform() != 2) {
            if (this.appManager == null) {
                this.appManager = ApplicationManager.getApplicationManager();
            }
            if (this.installedApps == null) {
                try {
                    this.installedApps = this.appManager.getApplications();
                }
                catch (Exception e) {
                    Logger.logInfo(this.getClass(), "Exception: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            if (this.installedApps != null && this.installedApps.length != 0) {
                int i = 0;
                while (i < this.installedApps.length) {
                    if (this.installedApps[i].getSuiteName().equals(appName)) {
                        result = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public void run() {
        this.verifyContent();
    }
}

