/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.services.downloader;

import com.sonyericsson.fifa.services.downloader.Downloader;
import com.sonyericsson.fifa.services.downloader.DownloaderListener;
import java.util.Vector;

public abstract class AbstractDownloader
implements Downloader {
    private Vector downloaderListeners = new Vector();

    public void addDownloaderListener(DownloaderListener listener) {
        if (listener != null) {
            this.downloaderListeners.addElement(listener);
        }
    }

    public void removeDownloaderListener(DownloaderListener listener) {
        if (listener != null) {
            this.downloaderListeners.removeElement(listener);
        }
    }

    protected void fireDownloadFinished(String filePath) {
        int i = 0;
        while (i < this.downloaderListeners.size()) {
            DownloaderListener listener = (DownloaderListener)this.downloaderListeners.elementAt(i);
            listener.downloadFinished(filePath);
            ++i;
        }
    }

    protected void fireDownloadFailed(byte reason) {
        int i = 0;
        while (i < this.downloaderListeners.size()) {
            DownloaderListener listener = (DownloaderListener)this.downloaderListeners.elementAt(i);
            listener.downloadFailed(reason);
            ++i;
        }
    }

    protected void fireDownloadProgress(int total, int partial) {
        int i = 0;
        while (i < this.downloaderListeners.size()) {
            DownloaderListener listener = (DownloaderListener)this.downloaderListeners.elementAt(i);
            listener.downloadProgress(total, partial);
            ++i;
        }
    }

    public abstract /* synthetic */ void setProgressPrecision(int var1);

    public abstract /* synthetic */ void setFileSize(int var1);

    public abstract /* synthetic */ void run();

    public abstract /* synthetic */ void enableDownloadProgress(boolean var1);
}

