/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.services.downloader.http;

import com.sonyericsson.fifa.exceptions.InvalidUrlException;
import com.sonyericsson.fifa.exceptions.NoDiskSpaceException;
import com.sonyericsson.fifa.services.downloader.AbstractDownloader;
import com.sonyericsson.fifa.utils.SystemProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class HttpDownloader
extends AbstractDownloader {
    private String httpUrl;
    private String filePath;
    private int fileSize;
    private boolean progressEnabled;
    private int progressPrecision;
    private static final int TYPICAL_ENCLOSURE_SIZE = 10000;
    private static final int DEFAULT_PROGRESS_NOTIFICATION_PRECISION = 10;
    private static final int DEFAULT_DOWNLOAD_CHUNK = 1024;

    public HttpDownloader(String httpUrl, String filePath) {
        this.httpUrl = httpUrl;
        this.filePath = filePath;
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HttpConnection openHttpConnection(String url) throws IOException, InvalidUrlException {
        if (url == null) {
            throw new InvalidUrlException();
        }
        HttpConnection httpConnection = (HttpConnection)Connector.open((String)this.httpUrl);
        if (SystemProperties.getPhonePlatform() == 3) {
            httpConnection.setRequestProperty("User-Agent", SystemProperties.EMULATOR_USER_AGENT);
        }
        if (SystemProperties.getPhonePlatform() == 2) {
            String PhoneModel = System.getProperty("microedition.platform");
            PhoneModel = PhoneModel.substring(0, PhoneModel.indexOf("/"));
            httpConnection.setRequestProperty("User-Agent", PhoneModel);
        }
        httpConnection.setRequestMethod("GET");
        if (httpConnection.getResponseCode() != 200) {
            throw new InvalidUrlException();
        }
        return httpConnection;
    }

    private void downloadFile(HttpConnection httpConnection, OutputStream outputStream) throws IOException, NoDiskSpaceException {
        if (httpConnection != null && outputStream != null) {
            if (this.fileSize == 0) {
                this.fileSize = (int)httpConnection.getLength();
            }
            int size = this.readBytesFromInputAndSaveIntoOutput(httpConnection.openInputStream(), outputStream);
            if (this.fileSize > 0 && size != this.fileSize) {
                throw new IOException();
            }
        }
    }

    private int readBytesFromInputAndSaveIntoOutput(InputStream inputStream, OutputStream outputStream) throws IOException {
        int totalBytesRead = 0;
        if (inputStream != null && outputStream != null) {
            int numberOfBytesRead = 0;
            byte[] bytesRead = new byte[1024];
            try {
                while ((numberOfBytesRead = inputStream.read(bytesRead, 0, 1024)) != -1) {
                    outputStream.write(bytesRead, 0, numberOfBytesRead);
                    outputStream.flush();
                    this.notifyProgress(totalBytesRead += numberOfBytesRead);
                }
            }
            finally {
                outputStream.flush();
                outputStream.close();
            }
        }
        return totalBytesRead;
    }

    private void notifyProgress(int bytesRead) {
        long multiple;
        if (this.progressEnabled && this.fileSize > 0 && (long)bytesRead / (multiple = (long)(this.fileSize / this.progressPrecision)) > 0L && (long)bytesRead % multiple <= 1024L && bytesRead != this.fileSize) {
            this.fireDownloadProgress(this.fileSize, bytesRead);
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void enableDownloadProgress(boolean enable) {
        this.progressEnabled = enable;
        this.progressPrecision = 10;
    }

    public void setFileSize(int fileSize) {
        this.fileSize = fileSize;
    }

    public void setProgressPrecision(int percentage) {
        this.progressPrecision = percentage;
    }
}

